/*
 * Decompiled with CFR 0.152.
 */
package robot.api;

import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyFrame;
import org.python.core.PyFunctionTable;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=38)
@MTime(value=1615466350934L)
@Filename(value="/Users/juhosaarinen/git/robotframework/build/Lib/robot/api/parsing.py")
public class parsing$py
extends PyFunctionTable
implements PyRunnable {
    static parsing$py self;
    static final PyCode f$0;

    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setglobal("__doc__", PyString.fromInterned(new StringBuilder(18512).append("Public API for parsing, inspecting and modifying test data.\n\nExposed API\n-----------\n\nThe publicly exposed parsing entry points are the following:\n\n* :func:`~.lexer.lexer.get_tokens`,\n  :func:`~.lexer.lexer.get_resource_tokens`, and\n  :func:`~.lexer.lexer.get_init_tokens`\n  functions for `parsing data to tokens`_.\n\n* :class:`~.lexer.tokens.Token` class that contains all token types as\n  class attributes.\n\n* :func:`~.parser.parser.get_model`,\n  :func:`~.parser.parser.get_resource_model`, and\n  :func:`~.parser.parser.get_init_model`\n  functions for `parsing data to model`_ represented as\n  an abstract syntax tree (AST).\n\n* `Model objects`_ used by the AST model.\n\n* :class:`~robot.parsing.model.visitor.ModelVisitor`\n  to ease `inspecting model`_ and `modifying data`_.\n\n* :class:`~robot.parsing.model.visitor.ModelTransformer`\n  for `adding and removing nodes`_.\n\n.. note:: This module is new in Robot Framework 4.0. In Robot Framework 3.2 functions\n          for getting tokens and model as well as the :class:`~.lexer.tokens.Token`\n          class were exposed directly via the :mod:`robot.api` package, but other\n          parts of the parsing API were not publicly exposed. All code targeting\n          Robot Framework 4.0 or newer should use this module because parsing related\n          functions and classes will be removed from :mod:`robot.api` in the future.\n\n.. note:: Parsing was totally rewritten in Robot Framework 3.2 and external\n          tools using the parsing APIs need to be updated. Depending on\n          the use case, it may be possible to use the higher level\n          :func:`~robot.running.builder.builders.TestSuiteBuilder` instead.\n\nParsing data to tokens\n----------------------\n\nData can be parsed to tokens by using\n:func:`~.lexer.lexer.get_tokens`,\n:func:`~.lexer.lexer.get_resource_tokens` or\n:func:`~.lexer.lexer.get_init_tokens` functions depending on whether the data\nrepresent a test case (or task) file, a resource file, or a suite\ninitialization file. In practice the difference between these functions is\nwhat settings and sections are valid.\n\nTypically the data is easier to inspect and modify by using the higher level\nmodel discussed in the next section, but in some cases having just the tokens\ncan be enough. Tokens returned by the aforementioned functions are\n:class:`~.lexer.tokens.Token` instances and they have the token type, value,\nand position easily available as their attributes. Tokens also have useful\nstring representation used by the example below::\n\n    from robot.api.parsing import get_tokens\n\n    path = 'example.robot'\n\n    for token in get_tokens(path):\n        print(repr(token))\n\nIf the :file:`example.robot` used by the above example would contain\n\n.. code-block:: robotframework\n\n    *** Test Cases ***\n    Example\n        Keyword    argument\n\n    Second example\n        Keyword    xxx\n\n    *** Keywords ***\n    Keyword\n        [Arguments]    ${arg}\n        Log    ${arg}\n\nthen the beginning of the output got when running the earlier code would\nlook like this::\n\n    Token(TESTCASE_HEADER, '*** Test Cases ***', 1, 0)\n    Token(EOL, '\\n', 1, 18)\n    Token(EOS, '', 1, 19)\n    Token(TESTCASE_NAME, 'Example', 2, 0)\n    Token(EOL, '\\n', 2, 7)\n    Token(EOS, '', 2, 8)\n    Token(SEPARATOR, '    ', 3, 0)\n    Token(KEYWORD, 'Keyword', 3, 4)\n    Token(SEPARATOR, '    ', 3, 11)\n    Token(ARGUMENT, 'argument', 3, 15)\n    Token(EOL, '\\n', 3, 23)\n    Token(EOS, '', 3, 24)\n    Token(EOL, '\\n', 4, 0)\n    Token(EOS, '', 4, 1)\n\nThe output shows the token type, value, line number and column offset. When finding\ntokens by their type, the constants in the :class:`~.lexer.tokens.Token` class such\nas ``Token.TESTCASE_NAME`` and ``Token.EOL`` should be used instead the values\nof these constants like ``'TESTCASE NAME'`` and ``'EOL'``. These values have\nchanged slightly in Robot Framework 4.0 and they may change in the future as well.\n\nThe ``EOL`` tokens denote end of a line and they include the newline character\nand possible trailing spaces. The ``EOS`` tokens denote end of a logical\nstatement. Typically a single line forms a statement, but when the ``...``\nsyntax is used for continuation, a statement spans multiple lines. In\nspecial cases a single line can also contain multiple statements.\n\nErrors caused by unrecognized data such as non-existing section or setting names\nare handled during the tokenizing phase. Such errors are reported using tokens\nthat have ``ERROR`` type and the actual error message in their ``error`` attribute.\nSyntax errors such as empty FOR loops are only handled when building the higher\nlevel model discussed below.\n\nSee the documentation of :func:`~.lexer.lexer.get_tokens` for details\nabout different ways how to specify the data to be parsed, how to control\nshould all tokens or only data tokens be returned, and should variables in\nkeyword arguments and elsewhere be tokenized or not.\n\nParsing data to model\n---------------------\n\nData can be parsed to a higher level model by using\n:func:`~.parser.parser.get_model`,\n:func:`~.parser.parser.get_resource_model`, or\n:func:`~.parser.parser.get_init_model` functions depending on the type of\nthe parsed file same way as when `parsing data to tokens`_.\n\nThe model is represented as an abstract syntax tree (AST) implemented on top\nof Python's standard `ast.AST`_ class. To see how the model looks like, it is\npossible to use the `ast.dump()`_ function or the third-party astpretty_\nmodule::\n\n    import ast\n    import astpretty\n    from robot.api.parsing import get_model\n\n    model = get_model('example.robot')\n    print(ast.dump(model, include_attributes=True))\n    print('-' * 72)\n    astpretty.pprint(model)\n\nRunning this code with the :file:`example.robot` file from the previous\nsection would produce so much output that it is not included here. If\nyou are going to work with Robot Framework's AST, you are recommended to\ntry that on your own.\n\n.. _ast: https://docs.python.org/library/ast.html\n.. _ast.AST: https://docs.python.org/library/ast.html#ast.AST\n.. _ast.NodeVisitor: https://docs.python.org/library/ast.html#ast.NodeVisitor\n.. _ast.NodeTransformer: https://docs.python.org/library/ast.html#ast.NodeTransformer\n.. _ast.dump(): https://docs.python.org/library/ast.html#ast.dump\n.. _astpretty: https://pypi.org/project/astpretty\n\nModel objects\n-------------\n\nThe model is build from nodes that are based `ast.AST`_ and further categorized\nto blocks and statements. Blocks can contain other blocks and statements as\nchild nodes whereas statements only have tokens containing the actual data as\n:class:`~.lexer.tokens.Token` instances. Both statements and blocks expose\ntheir position information via ``lineno``, ``col_offset``, ``end_lineno`` and\n``end_col_offset`` attributes and some nodes have also other special attributes\navailable.\n\nBlocks:\n\n- :class:`~robot.parsing.model.blocks.File` (the root of the model)\n- :class:`~robot.parsing.model.blocks.SettingSection`\n- :class:`~robot.parsing.model.blocks.VariableSection`\n- :class:`~robot.parsing.model.blocks.TestCaseSection`\n- :class:`~robot.parsing.model.blocks.KeywordSection`\n- :class:`~robot.parsing.model.blocks.CommentSection`\n- :class:`~robot.parsing.model.blocks.TestCase`\n- :class:`~robot.parsing.model.blocks.Keyword`\n- :class:`~robot.parsing.model.blocks.For`\n- :class:`~robot.parsing.model.blocks.If`\n\nStatements:\n\n- :class:`~robot.parsing.model.statements.SectionHeader`\n- :class:`~robot.parsing.model.statements.LibraryImport`\n- :class:`~robot.parsing.model.statements.ResourceImport`\n- :class:`~robot.parsing.model.statements.VariablesImport`\n- :class:`~robot.parsing.model.statements.Documentation`\n- :class:`~robot.parsing.model.statements.Metadata`\n- :class:`~robot.parsing.model.statements.ForceTags`\n- :class:`~robot.parsing.model.statements.DefaultTags`\n- :class:`~robot.parsing.model.statements.SuiteSetup`\n- :class:`~robot.parsing.model.statements.SuiteTeardown`\n- :class:`~robot.parsing.model.statements.TestSetup`\n- :class:`~robot.parsing.model.statements.TestTeardown`\n- :class:`~robot.parsing.model.statements.TestTemplate`\n- :class:`~robot.parsing.model.statements.TestTimeout`\n- :class:`~robot.parsing.model.statements.Variable`\n- :class:`~robot.parsing.model.statements.TestCaseName`\n- :class:`~robot.parsing.model.statements.KeywordName`\n- :class:`~robot.parsing.model.statements.Setup`\n- :class:`~robot.parsing.model.statements.Teardown`\n- :class:`~robot.parsing.model.statements.Tags`\n- :class:`~robot.parsing.model.statements.Template`\n- :class:`~robot.parsing.model.statements.Timeout`\n- :class:`~robot.parsing.model.statements.Arguments`\n- :class:`~robot.parsing.model.statements.Return`\n- :class:`~robot.parsing.model.statements.KeywordCall`\n- :class:`~robot.parsing.model.statements.TemplateArguments`\n- :class:`~robot.parsing.model.statements.ForHeader`\n- :class:`~robot.parsing.model.statements.IfHeader`\n- :class:`~robot.parsing.model.statements.ElseIfHeader`\n- :class:`~robot.parsing.model.statements.ElseHeader`\n- :class:`~robot.parsing.model.statements.End`\n- :class:`~robot.parsing.model.statements.Comment`\n- :class:`~robot.parsing.model.statements.Error`\n- :class:`~robot.parsing.model.statements.EmptyLine`\n\nInspecting model\n----------------\n\nThe easiest way to inspect what data a model contains is implementing\n:class:`~robot.parsing.model.visitor.ModelVisitor` and creating\n``visit_NodeName`` to visit nodes with name ``NodeName`` as needed.\nThe following example illustrates how to find what tests a certain test\ncase file contains::\n\n    from robot.api.parsing import get_model, ModelVisitor\n\n\n    class TestNamePrinter(ModelVisitor):\n\n        def visit_File(self, node):\n            print(f\"File '{node.source}' has following tests:\")\n            # Call `generic_visit` to visit also child nodes.\n            self.generic_visit(node)\n\n        def visit_TestCaseName(self, node):\n            print(f\"- {node.name} (on line {node.lineno})\")\n\n\n    model = get_model('example.robot')\n    printer = TestNamePrinter()\n    printer.visit(model)\n\nWhen the above code is run using the earlier :file:`example.robot`, the\noutput is this::\n\n    File 'example.robot' has following tests:\n    - Example (on line 2)\n    - Second example (on line 5)\n\nHandling errors in model\n------------------------\n\nAll nodes in the model have ``errors`` attribute that contains possible errors\nthe node has. These errors include syntax errors such as empty FOR loops or IF\nwithout a condition as well as errors caused by unrecognized data such as\nnon-existing section or setting names.\n\nUnrecognized data is handled already during the tokenizing__ phase. In the model\nsuch data is represented as :class:`~robot.parsing.model.statements.Error`\nnodes and their ``errors`` attribute contain error information got from the\nunderlying ``ERROR`` tokens. Syntax errors do not create\n:class:`~robot.parsing.model.statements.Error`\nnodes, but instead the model has normal nodes such as\n:class:`~robot.parsing.model.blocks.If`\nwith errors in their ``errors`` attribute.\n\nA simple way to go through the model and see are there errors is using the\n:class:`~robot.parsing.model.visitor.ModelVisitor`\ndiscussed in the previous section::\n\n    class ErrorReporter(ModelVisitor):\n\n        # Implement `generic_visit` to visit all nodes.\n        def generic_visit(self, node):\n            if node.errors:\n                print(f'Error on line {node.lineno}:')\n                for error in node.errors:\n                    print(f'- {error}')\n            ModelVisitor.generic_visit(self, node)\n\n__ `Parsing data to tokens`_\n\nModifying data\n--------------\n\nExisting data the model contains can be modified simply by modifying values of\nthe underlying tokens. If changes need to be saved, that is as easy as calling\nthe :meth:`~.model.blocks.File.save` method of the root model object. When\njust modifying token values, it is possible to still use\n:class:`~robot.parsing.model.visitor.ModelVisitor`\ndiscussed in the above section. The next section discusses adding or removing\nnodes and then\n:class:`~robot.parsing.model.visitor.ModelTransformer`\nshould be used instead.\n\nModifications to tokens obviously require finding the tokens to be modified.\nThe first step is finding nodes containing the tokens by implementing\nneeded ``visit_NodeName`` methods. Then the exact token or tokens\ncan be found using nodes'\n:meth:`~.model.statements.Statement.get_token` or\n:meth:`~.model.statements.Statement.get_tokens` methods.\nIf only token values are needed,\n:meth:`~.model.statements.Statement.get_value` or\n:meth:`~.model.statements.Statement.get_values` can be used as a shortcut.\nFirst finding nodes and then the right tokens is illustrated by\nthis keyword renaming example::\n\n    from robot.api.parsing import get_model, ModelVisitor, Token\n\n\n    class KeywordRenamer(ModelVisitor):\n\n        def __init__(self, old_name, new_name):\n            self.old_name = self.normalize(old_name)\n            self.new_name = new_name\n\n        def normalize(self, name):\n            return name.lower().replace(' ', '').replace('_', '')\n\n        def visit_KeywordName(self, node):\n            '''Rename keyword definitions.'''\n            if self.normalize(node.name) == self.old_name:\n                token = node.get_token(Token.KEYWORD_NAME)\n                token.value = self.new_name\n\n        def visit_KeywordCall(self, node):\n            '''Rename keyword usages.'''\n            if self.normalize(node.keyword) == self.old_name:\n                token = node.get_token(Token.KEYWORD)\n                token.value = self.new_name\n\n\n    model = get_model('example.robot')\n    renamer = KeywordRenamer('Keyword', 'New Name')\n    renamer.visit(model)\n    model.save()\n\nIf you run the above example using the earlier :file:`example.robot`, you\ncan see that the ``Keyword`` keyword has been renamed to ``New Name``. Notice\nthat a real keyword renamer needed to take into account also keywords used\nwith setups, teardowns and templates.\n\nWhen token values are changed, column offset of the other tokens on same\nline are likely to be wrong. This does not affect saving the model or other\ntypical usages, but if it is a problem then the caller needs to updated\noffsets separately.\n\nAdding and removing nodes\n-------------------------\n\nBigger changes to the model are somewhat more complicated than just modifying\nexisting token values. When doing this kind of changes,\n:class:`~robot.parsing.model.visitor.ModelTransformer`\nshould be used instead of\n:class:`~robot.parsing.model.visitor.ModelVisitor`\nthat was discussed in the previous sections.\n\nRemoving nodes is relative easy and is accomplished by returning ``None``\nfrom ``visit_NodeName`` methods. Remember to return the original node,\nor possibly a replacement node, from all of these methods when you do not\nwant a node to be removed.\n\nAdding nodes requires constructing needed `Model objects`_ and adding them\nto the model. The following example demonstrates both removing and adding nodes.\nIf you run it against the earlier :file:`example.robot`, you see that\nthe first test gets a new keyword, the second test is removed, and\nsettings section with documentation is added.\n\n::\n\n    from robot.api.parsing import (\n        get_model, Documentation, EmptyLine, KeywordCall,\n        ModelTransformer, SettingSection, SectionHeader, Token\n    )\n\n\n    class TestModifier(ModelTransformer):\n\n        def visit_TestCase(self, node):\n            # The matched `TestCase` node is a block with `header` and\n            # `body` attributes. `header` is a statement with familiar\n            # `get_token` and `get_value` methods for getting certain\n            # tokens or their value.\n            name = node.header.get_value(Token.TESTCASE_NAME)\n            # Returning `None` drops the node altogether i.e. removes\n            # this test.\n            if name == 'Second example':\n                return None\n            # Construct new keyword call statement from tokens. See `visit_File`\n            # below for an example creating statements").append(" using `from_params`.\n            new_keyword = KeywordCall([\n                Token(Token.SEPARATOR, '    '),\n                Token(Token.KEYWORD, 'New Keyword'),\n                Token(Token.SEPARATOR, '    '),\n                Token(Token.ARGUMENT, 'xxx'),\n                Token(Token.EOL)\n            ])\n            # Add the keyword call to test as the second item.\n            node.body.insert(1, new_keyword)\n            # No need to call `generic_visit` because we are not\n            # modifying child nodes. The node itself must to be\n            # returned to avoid dropping it.\n            return node\n\n        def visit_File(self, node):\n            # Create settings section with documentation. Needed header and body\n            # statements are created using `from_params` method. This is typically\n            # more convenient than creating statements based on tokens like above.\n            settings = SettingSection(\n                header=SectionHeader.from_params(Token.SETTING_HEADER),\n                body=[\n                    Documentation.from_params('This is a really\\npowerful API!'),\n                    EmptyLine.from_params()\n                ]\n            )\n            # Add settings to the beginning of the file.\n            node.sections.insert(0, settings)\n            # Call `generic_visit` to visit also child nodes.\n            return self.generic_visit(node)\n\n\n    model = get_model('example.robot')\n    TestModifier().visit(model)\n    model.save('modified.robot')\n\nExecuting model\n---------------\n\nIt is possible to convert a parsed and possibly modified model into an\nexecutable :class:`~robot.running.model.TestSuite` structure by using its\n:func:`~robot.running.model.TestSuite.from_model` class method. In this case\nthe :func:`~.parser.parser.get_model` function should be given the ``curdir``\nargument to get possible ``${CURDIR}`` variable resolved correctly.\n\n::\n\n     from robot.api import TestSuite\n     from robot.api.parsing import get_model\n\n     model = get_model('example.robot', curdir='/home/robot/example')\n     # modify model as needed\n     suite = TestSuite.from_model(model)\n     suite.run()\n\nFor more details about executing the created\n:class:`~robot.running.model.TestSuite` object, see the documentation\nof its :meth:`~robot.running.model.TestSuite.run` method. Notice also\nthat if you do not need to modify the parsed model, it is easier to\nget the executable suite by using the\n:func:`~robot.running.model.TestSuite.from_file_system` class method.\n").toString()));
        pyFrame.setline(470);
        PyString.fromInterned(new StringBuilder(18512).append("Public API for parsing, inspecting and modifying test data.\n\nExposed API\n-----------\n\nThe publicly exposed parsing entry points are the following:\n\n* :func:`~.lexer.lexer.get_tokens`,\n  :func:`~.lexer.lexer.get_resource_tokens`, and\n  :func:`~.lexer.lexer.get_init_tokens`\n  functions for `parsing data to tokens`_.\n\n* :class:`~.lexer.tokens.Token` class that contains all token types as\n  class attributes.\n\n* :func:`~.parser.parser.get_model`,\n  :func:`~.parser.parser.get_resource_model`, and\n  :func:`~.parser.parser.get_init_model`\n  functions for `parsing data to model`_ represented as\n  an abstract syntax tree (AST).\n\n* `Model objects`_ used by the AST model.\n\n* :class:`~robot.parsing.model.visitor.ModelVisitor`\n  to ease `inspecting model`_ and `modifying data`_.\n\n* :class:`~robot.parsing.model.visitor.ModelTransformer`\n  for `adding and removing nodes`_.\n\n.. note:: This module is new in Robot Framework 4.0. In Robot Framework 3.2 functions\n          for getting tokens and model as well as the :class:`~.lexer.tokens.Token`\n          class were exposed directly via the :mod:`robot.api` package, but other\n          parts of the parsing API were not publicly exposed. All code targeting\n          Robot Framework 4.0 or newer should use this module because parsing related\n          functions and classes will be removed from :mod:`robot.api` in the future.\n\n.. note:: Parsing was totally rewritten in Robot Framework 3.2 and external\n          tools using the parsing APIs need to be updated. Depending on\n          the use case, it may be possible to use the higher level\n          :func:`~robot.running.builder.builders.TestSuiteBuilder` instead.\n\nParsing data to tokens\n----------------------\n\nData can be parsed to tokens by using\n:func:`~.lexer.lexer.get_tokens`,\n:func:`~.lexer.lexer.get_resource_tokens` or\n:func:`~.lexer.lexer.get_init_tokens` functions depending on whether the data\nrepresent a test case (or task) file, a resource file, or a suite\ninitialization file. In practice the difference between these functions is\nwhat settings and sections are valid.\n\nTypically the data is easier to inspect and modify by using the higher level\nmodel discussed in the next section, but in some cases having just the tokens\ncan be enough. Tokens returned by the aforementioned functions are\n:class:`~.lexer.tokens.Token` instances and they have the token type, value,\nand position easily available as their attributes. Tokens also have useful\nstring representation used by the example below::\n\n    from robot.api.parsing import get_tokens\n\n    path = 'example.robot'\n\n    for token in get_tokens(path):\n        print(repr(token))\n\nIf the :file:`example.robot` used by the above example would contain\n\n.. code-block:: robotframework\n\n    *** Test Cases ***\n    Example\n        Keyword    argument\n\n    Second example\n        Keyword    xxx\n\n    *** Keywords ***\n    Keyword\n        [Arguments]    ${arg}\n        Log    ${arg}\n\nthen the beginning of the output got when running the earlier code would\nlook like this::\n\n    Token(TESTCASE_HEADER, '*** Test Cases ***', 1, 0)\n    Token(EOL, '\\n', 1, 18)\n    Token(EOS, '', 1, 19)\n    Token(TESTCASE_NAME, 'Example', 2, 0)\n    Token(EOL, '\\n', 2, 7)\n    Token(EOS, '', 2, 8)\n    Token(SEPARATOR, '    ', 3, 0)\n    Token(KEYWORD, 'Keyword', 3, 4)\n    Token(SEPARATOR, '    ', 3, 11)\n    Token(ARGUMENT, 'argument', 3, 15)\n    Token(EOL, '\\n', 3, 23)\n    Token(EOS, '', 3, 24)\n    Token(EOL, '\\n', 4, 0)\n    Token(EOS, '', 4, 1)\n\nThe output shows the token type, value, line number and column offset. When finding\ntokens by their type, the constants in the :class:`~.lexer.tokens.Token` class such\nas ``Token.TESTCASE_NAME`` and ``Token.EOL`` should be used instead the values\nof these constants like ``'TESTCASE NAME'`` and ``'EOL'``. These values have\nchanged slightly in Robot Framework 4.0 and they may change in the future as well.\n\nThe ``EOL`` tokens denote end of a line and they include the newline character\nand possible trailing spaces. The ``EOS`` tokens denote end of a logical\nstatement. Typically a single line forms a statement, but when the ``...``\nsyntax is used for continuation, a statement spans multiple lines. In\nspecial cases a single line can also contain multiple statements.\n\nErrors caused by unrecognized data such as non-existing section or setting names\nare handled during the tokenizing phase. Such errors are reported using tokens\nthat have ``ERROR`` type and the actual error message in their ``error`` attribute.\nSyntax errors such as empty FOR loops are only handled when building the higher\nlevel model discussed below.\n\nSee the documentation of :func:`~.lexer.lexer.get_tokens` for details\nabout different ways how to specify the data to be parsed, how to control\nshould all tokens or only data tokens be returned, and should variables in\nkeyword arguments and elsewhere be tokenized or not.\n\nParsing data to model\n---------------------\n\nData can be parsed to a higher level model by using\n:func:`~.parser.parser.get_model`,\n:func:`~.parser.parser.get_resource_model`, or\n:func:`~.parser.parser.get_init_model` functions depending on the type of\nthe parsed file same way as when `parsing data to tokens`_.\n\nThe model is represented as an abstract syntax tree (AST) implemented on top\nof Python's standard `ast.AST`_ class. To see how the model looks like, it is\npossible to use the `ast.dump()`_ function or the third-party astpretty_\nmodule::\n\n    import ast\n    import astpretty\n    from robot.api.parsing import get_model\n\n    model = get_model('example.robot')\n    print(ast.dump(model, include_attributes=True))\n    print('-' * 72)\n    astpretty.pprint(model)\n\nRunning this code with the :file:`example.robot` file from the previous\nsection would produce so much output that it is not included here. If\nyou are going to work with Robot Framework's AST, you are recommended to\ntry that on your own.\n\n.. _ast: https://docs.python.org/library/ast.html\n.. _ast.AST: https://docs.python.org/library/ast.html#ast.AST\n.. _ast.NodeVisitor: https://docs.python.org/library/ast.html#ast.NodeVisitor\n.. _ast.NodeTransformer: https://docs.python.org/library/ast.html#ast.NodeTransformer\n.. _ast.dump(): https://docs.python.org/library/ast.html#ast.dump\n.. _astpretty: https://pypi.org/project/astpretty\n\nModel objects\n-------------\n\nThe model is build from nodes that are based `ast.AST`_ and further categorized\nto blocks and statements. Blocks can contain other blocks and statements as\nchild nodes whereas statements only have tokens containing the actual data as\n:class:`~.lexer.tokens.Token` instances. Both statements and blocks expose\ntheir position information via ``lineno``, ``col_offset``, ``end_lineno`` and\n``end_col_offset`` attributes and some nodes have also other special attributes\navailable.\n\nBlocks:\n\n- :class:`~robot.parsing.model.blocks.File` (the root of the model)\n- :class:`~robot.parsing.model.blocks.SettingSection`\n- :class:`~robot.parsing.model.blocks.VariableSection`\n- :class:`~robot.parsing.model.blocks.TestCaseSection`\n- :class:`~robot.parsing.model.blocks.KeywordSection`\n- :class:`~robot.parsing.model.blocks.CommentSection`\n- :class:`~robot.parsing.model.blocks.TestCase`\n- :class:`~robot.parsing.model.blocks.Keyword`\n- :class:`~robot.parsing.model.blocks.For`\n- :class:`~robot.parsing.model.blocks.If`\n\nStatements:\n\n- :class:`~robot.parsing.model.statements.SectionHeader`\n- :class:`~robot.parsing.model.statements.LibraryImport`\n- :class:`~robot.parsing.model.statements.ResourceImport`\n- :class:`~robot.parsing.model.statements.VariablesImport`\n- :class:`~robot.parsing.model.statements.Documentation`\n- :class:`~robot.parsing.model.statements.Metadata`\n- :class:`~robot.parsing.model.statements.ForceTags`\n- :class:`~robot.parsing.model.statements.DefaultTags`\n- :class:`~robot.parsing.model.statements.SuiteSetup`\n- :class:`~robot.parsing.model.statements.SuiteTeardown`\n- :class:`~robot.parsing.model.statements.TestSetup`\n- :class:`~robot.parsing.model.statements.TestTeardown`\n- :class:`~robot.parsing.model.statements.TestTemplate`\n- :class:`~robot.parsing.model.statements.TestTimeout`\n- :class:`~robot.parsing.model.statements.Variable`\n- :class:`~robot.parsing.model.statements.TestCaseName`\n- :class:`~robot.parsing.model.statements.KeywordName`\n- :class:`~robot.parsing.model.statements.Setup`\n- :class:`~robot.parsing.model.statements.Teardown`\n- :class:`~robot.parsing.model.statements.Tags`\n- :class:`~robot.parsing.model.statements.Template`\n- :class:`~robot.parsing.model.statements.Timeout`\n- :class:`~robot.parsing.model.statements.Arguments`\n- :class:`~robot.parsing.model.statements.Return`\n- :class:`~robot.parsing.model.statements.KeywordCall`\n- :class:`~robot.parsing.model.statements.TemplateArguments`\n- :class:`~robot.parsing.model.statements.ForHeader`\n- :class:`~robot.parsing.model.statements.IfHeader`\n- :class:`~robot.parsing.model.statements.ElseIfHeader`\n- :class:`~robot.parsing.model.statements.ElseHeader`\n- :class:`~robot.parsing.model.statements.End`\n- :class:`~robot.parsing.model.statements.Comment`\n- :class:`~robot.parsing.model.statements.Error`\n- :class:`~robot.parsing.model.statements.EmptyLine`\n\nInspecting model\n----------------\n\nThe easiest way to inspect what data a model contains is implementing\n:class:`~robot.parsing.model.visitor.ModelVisitor` and creating\n``visit_NodeName`` to visit nodes with name ``NodeName`` as needed.\nThe following example illustrates how to find what tests a certain test\ncase file contains::\n\n    from robot.api.parsing import get_model, ModelVisitor\n\n\n    class TestNamePrinter(ModelVisitor):\n\n        def visit_File(self, node):\n            print(f\"File '{node.source}' has following tests:\")\n            # Call `generic_visit` to visit also child nodes.\n            self.generic_visit(node)\n\n        def visit_TestCaseName(self, node):\n            print(f\"- {node.name} (on line {node.lineno})\")\n\n\n    model = get_model('example.robot')\n    printer = TestNamePrinter()\n    printer.visit(model)\n\nWhen the above code is run using the earlier :file:`example.robot`, the\noutput is this::\n\n    File 'example.robot' has following tests:\n    - Example (on line 2)\n    - Second example (on line 5)\n\nHandling errors in model\n------------------------\n\nAll nodes in the model have ``errors`` attribute that contains possible errors\nthe node has. These errors include syntax errors such as empty FOR loops or IF\nwithout a condition as well as errors caused by unrecognized data such as\nnon-existing section or setting names.\n\nUnrecognized data is handled already during the tokenizing__ phase. In the model\nsuch data is represented as :class:`~robot.parsing.model.statements.Error`\nnodes and their ``errors`` attribute contain error information got from the\nunderlying ``ERROR`` tokens. Syntax errors do not create\n:class:`~robot.parsing.model.statements.Error`\nnodes, but instead the model has normal nodes such as\n:class:`~robot.parsing.model.blocks.If`\nwith errors in their ``errors`` attribute.\n\nA simple way to go through the model and see are there errors is using the\n:class:`~robot.parsing.model.visitor.ModelVisitor`\ndiscussed in the previous section::\n\n    class ErrorReporter(ModelVisitor):\n\n        # Implement `generic_visit` to visit all nodes.\n        def generic_visit(self, node):\n            if node.errors:\n                print(f'Error on line {node.lineno}:')\n                for error in node.errors:\n                    print(f'- {error}')\n            ModelVisitor.generic_visit(self, node)\n\n__ `Parsing data to tokens`_\n\nModifying data\n--------------\n\nExisting data the model contains can be modified simply by modifying values of\nthe underlying tokens. If changes need to be saved, that is as easy as calling\nthe :meth:`~.model.blocks.File.save` method of the root model object. When\njust modifying token values, it is possible to still use\n:class:`~robot.parsing.model.visitor.ModelVisitor`\ndiscussed in the above section. The next section discusses adding or removing\nnodes and then\n:class:`~robot.parsing.model.visitor.ModelTransformer`\nshould be used instead.\n\nModifications to tokens obviously require finding the tokens to be modified.\nThe first step is finding nodes containing the tokens by implementing\nneeded ``visit_NodeName`` methods. Then the exact token or tokens\ncan be found using nodes'\n:meth:`~.model.statements.Statement.get_token` or\n:meth:`~.model.statements.Statement.get_tokens` methods.\nIf only token values are needed,\n:meth:`~.model.statements.Statement.get_value` or\n:meth:`~.model.statements.Statement.get_values` can be used as a shortcut.\nFirst finding nodes and then the right tokens is illustrated by\nthis keyword renaming example::\n\n    from robot.api.parsing import get_model, ModelVisitor, Token\n\n\n    class KeywordRenamer(ModelVisitor):\n\n        def __init__(self, old_name, new_name):\n            self.old_name = self.normalize(old_name)\n            self.new_name = new_name\n\n        def normalize(self, name):\n            return name.lower().replace(' ', '').replace('_', '')\n\n        def visit_KeywordName(self, node):\n            '''Rename keyword definitions.'''\n            if self.normalize(node.name) == self.old_name:\n                token = node.get_token(Token.KEYWORD_NAME)\n                token.value = self.new_name\n\n        def visit_KeywordCall(self, node):\n            '''Rename keyword usages.'''\n            if self.normalize(node.keyword) == self.old_name:\n                token = node.get_token(Token.KEYWORD)\n                token.value = self.new_name\n\n\n    model = get_model('example.robot')\n    renamer = KeywordRenamer('Keyword', 'New Name')\n    renamer.visit(model)\n    model.save()\n\nIf you run the above example using the earlier :file:`example.robot`, you\ncan see that the ``Keyword`` keyword has been renamed to ``New Name``. Notice\nthat a real keyword renamer needed to take into account also keywords used\nwith setups, teardowns and templates.\n\nWhen token values are changed, column offset of the other tokens on same\nline are likely to be wrong. This does not affect saving the model or other\ntypical usages, but if it is a problem then the caller needs to updated\noffsets separately.\n\nAdding and removing nodes\n-------------------------\n\nBigger changes to the model are somewhat more complicated than just modifying\nexisting token values. When doing this kind of changes,\n:class:`~robot.parsing.model.visitor.ModelTransformer`\nshould be used instead of\n:class:`~robot.parsing.model.visitor.ModelVisitor`\nthat was discussed in the previous sections.\n\nRemoving nodes is relative easy and is accomplished by returning ``None``\nfrom ``visit_NodeName`` methods. Remember to return the original node,\nor possibly a replacement node, from all of these methods when you do not\nwant a node to be removed.\n\nAdding nodes requires constructing needed `Model objects`_ and adding them\nto the model. The following example demonstrates both removing and adding nodes.\nIf you run it against the earlier :file:`example.robot`, you see that\nthe first test gets a new keyword, the second test is removed, and\nsettings section with documentation is added.\n\n::\n\n    from robot.api.parsing import (\n        get_model, Documentation, EmptyLine, KeywordCall,\n        ModelTransformer, SettingSection, SectionHeader, Token\n    )\n\n\n    class TestModifier(ModelTransformer):\n\n        def visit_TestCase(self, node):\n            # The matched `TestCase` node is a block with `header` and\n            # `body` attributes. `header` is a statement with familiar\n            # `get_token` and `get_value` methods for getting certain\n            # tokens or their value.\n            name = node.header.get_value(Token.TESTCASE_NAME)\n            # Returning `None` drops the node altogether i.e. removes\n            # this test.\n            if name == 'Second example':\n                return None\n            # Construct new keyword call statement from tokens. See `visit_File`\n            # below for an example creating statements").append(" using `from_params`.\n            new_keyword = KeywordCall([\n                Token(Token.SEPARATOR, '    '),\n                Token(Token.KEYWORD, 'New Keyword'),\n                Token(Token.SEPARATOR, '    '),\n                Token(Token.ARGUMENT, 'xxx'),\n                Token(Token.EOL)\n            ])\n            # Add the keyword call to test as the second item.\n            node.body.insert(1, new_keyword)\n            # No need to call `generic_visit` because we are not\n            # modifying child nodes. The node itself must to be\n            # returned to avoid dropping it.\n            return node\n\n        def visit_File(self, node):\n            # Create settings section with documentation. Needed header and body\n            # statements are created using `from_params` method. This is typically\n            # more convenient than creating statements based on tokens like above.\n            settings = SettingSection(\n                header=SectionHeader.from_params(Token.SETTING_HEADER),\n                body=[\n                    Documentation.from_params('This is a really\\npowerful API!'),\n                    EmptyLine.from_params()\n                ]\n            )\n            # Add settings to the beginning of the file.\n            node.sections.insert(0, settings)\n            # Call `generic_visit` to visit also child nodes.\n            return self.generic_visit(node)\n\n\n    model = get_model('example.robot')\n    TestModifier().visit(model)\n    model.save('modified.robot')\n\nExecuting model\n---------------\n\nIt is possible to convert a parsed and possibly modified model into an\nexecutable :class:`~robot.running.model.TestSuite` structure by using its\n:func:`~robot.running.model.TestSuite.from_model` class method. In this case\nthe :func:`~.parser.parser.get_model` function should be given the ``curdir``\nargument to get possible ``${CURDIR}`` variable resolved correctly.\n\n::\n\n     from robot.api import TestSuite\n     from robot.api.parsing import get_model\n\n     model = get_model('example.robot', curdir='/home/robot/example')\n     # modify model as needed\n     suite = TestSuite.from_model(model)\n     suite.run()\n\nFor more details about executing the created\n:class:`~robot.running.model.TestSuite` object, see the documentation\nof its :meth:`~robot.running.model.TestSuite.run` method. Notice also\nthat if you do not need to modify the parsed model, it is easier to\nget the executable suite by using the\n:func:`~robot.running.model.TestSuite.from_file_system` class method.\n").toString());
        pyFrame.setline(472);
        Object[] objectArray = new String[]{"get_tokens", "get_resource_tokens", "get_init_tokens", "get_model", "get_resource_model", "get_init_model", "Token"};
        objectArray = imp.importFrom("robot.parsing", (String[])objectArray, pyFrame, -1);
        Object object = objectArray[0];
        pyFrame.setlocal("get_tokens", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("get_resource_tokens", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("get_init_tokens", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("get_model", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("get_resource_model", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("get_init_model", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("Token", (PyObject)object);
        object = null;
        pyFrame.setline(481);
        objectArray = new String[]{"File", "SettingSection", "VariableSection", "TestCaseSection", "KeywordSection", "CommentSection", "TestCase", "Keyword", "For", "If"};
        objectArray = imp.importFrom("robot.parsing.model.blocks", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("File", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("SettingSection", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("VariableSection", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("TestCaseSection", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("KeywordSection", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("CommentSection", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("TestCase", (PyObject)object);
        object = null;
        object = objectArray[7];
        pyFrame.setlocal("Keyword", (PyObject)object);
        object = null;
        object = objectArray[8];
        pyFrame.setlocal("For", (PyObject)object);
        object = null;
        object = objectArray[9];
        pyFrame.setlocal("If", (PyObject)object);
        object = null;
        pyFrame.setline(493);
        objectArray = new String[]{"SectionHeader", "LibraryImport", "ResourceImport", "VariablesImport", "Documentation", "Metadata", "ForceTags", "DefaultTags", "SuiteSetup", "SuiteTeardown", "TestSetup", "TestTeardown", "TestTemplate", "TestTimeout", "Variable", "TestCaseName", "KeywordName", "Setup", "Teardown", "Tags", "Template", "Timeout", "Arguments", "Return", "KeywordCall", "TemplateArguments", "ForHeader", "IfHeader", "ElseIfHeader", "ElseHeader", "End", "Comment", "Error", "EmptyLine"};
        objectArray = imp.importFrom("robot.parsing.model.statements", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("SectionHeader", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("LibraryImport", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("ResourceImport", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("VariablesImport", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("Documentation", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("Metadata", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("ForceTags", (PyObject)object);
        object = null;
        object = objectArray[7];
        pyFrame.setlocal("DefaultTags", (PyObject)object);
        object = null;
        object = objectArray[8];
        pyFrame.setlocal("SuiteSetup", (PyObject)object);
        object = null;
        object = objectArray[9];
        pyFrame.setlocal("SuiteTeardown", (PyObject)object);
        object = null;
        object = objectArray[10];
        pyFrame.setlocal("TestSetup", (PyObject)object);
        object = null;
        object = objectArray[11];
        pyFrame.setlocal("TestTeardown", (PyObject)object);
        object = null;
        object = objectArray[12];
        pyFrame.setlocal("TestTemplate", (PyObject)object);
        object = null;
        object = objectArray[13];
        pyFrame.setlocal("TestTimeout", (PyObject)object);
        object = null;
        object = objectArray[14];
        pyFrame.setlocal("Variable", (PyObject)object);
        object = null;
        object = objectArray[15];
        pyFrame.setlocal("TestCaseName", (PyObject)object);
        object = null;
        object = objectArray[16];
        pyFrame.setlocal("KeywordName", (PyObject)object);
        object = null;
        object = objectArray[17];
        pyFrame.setlocal("Setup", (PyObject)object);
        object = null;
        object = objectArray[18];
        pyFrame.setlocal("Teardown", (PyObject)object);
        object = null;
        object = objectArray[19];
        pyFrame.setlocal("Tags", (PyObject)object);
        object = null;
        object = objectArray[20];
        pyFrame.setlocal("Template", (PyObject)object);
        object = null;
        object = objectArray[21];
        pyFrame.setlocal("Timeout", (PyObject)object);
        object = null;
        object = objectArray[22];
        pyFrame.setlocal("Arguments", (PyObject)object);
        object = null;
        object = objectArray[23];
        pyFrame.setlocal("Return", (PyObject)object);
        object = null;
        object = objectArray[24];
        pyFrame.setlocal("KeywordCall", (PyObject)object);
        object = null;
        object = objectArray[25];
        pyFrame.setlocal("TemplateArguments", (PyObject)object);
        object = null;
        object = objectArray[26];
        pyFrame.setlocal("ForHeader", (PyObject)object);
        object = null;
        object = objectArray[27];
        pyFrame.setlocal("IfHeader", (PyObject)object);
        object = null;
        object = objectArray[28];
        pyFrame.setlocal("ElseIfHeader", (PyObject)object);
        object = null;
        object = objectArray[29];
        pyFrame.setlocal("ElseHeader", (PyObject)object);
        object = null;
        object = objectArray[30];
        pyFrame.setlocal("End", (PyObject)object);
        object = null;
        object = objectArray[31];
        pyFrame.setlocal("Comment", (PyObject)object);
        object = null;
        object = objectArray[32];
        pyFrame.setlocal("Error", (PyObject)object);
        object = null;
        object = objectArray[33];
        pyFrame.setlocal("EmptyLine", (PyObject)object);
        object = null;
        pyFrame.setline(529);
        objectArray = new String[]{"ModelTransformer", "ModelVisitor"};
        objectArray = imp.importFrom("robot.parsing.model.visitor", (String[])objectArray, pyFrame, -1);
        object = objectArray[0];
        pyFrame.setlocal("ModelTransformer", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("ModelVisitor", (PyObject)object);
        object = null;
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public parsing$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
    }

    @Override
    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new parsing$py("robot/api/parsing$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(parsing$py.class);
    }

    @Override
    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        switch (n) {
            case 0: {
                return this.f$0(pyFrame, threadState);
            }
        }
        return null;
    }
}

