/*
 * Decompiled with CFR 0.152.
 */
package robot.libraries;

import java.util.Arrays;
import org.python.compiler.APIVersion;
import org.python.compiler.Filename;
import org.python.compiler.MTime;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.ContextGuard;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyFunctionTable;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.imp;

@APIVersion(value=38)
@MTime(value=1634749319947L)
@Filename(value="/Users/juhosaarinen/git/robotframework/build/Lib/robot/libraries/String.py")
public class String$py
extends PyFunctionTable
implements PyRunnable {
    static String$py self;
    static final PyCode f$0;
    static final PyCode String$1;
    static final PyCode convert_to_lower_case$2;
    static final PyCode convert_to_upper_case$3;
    static final PyCode convert_to_title_case$4;
    static final PyCode title$5;
    static final PyCode f$6;
    static final PyCode f$7;
    static final PyCode encode_string_to_bytes$8;
    static final PyCode decode_bytes_to_string$9;
    static final PyCode format_string$10;
    static final PyCode get_line_count$11;
    static final PyCode split_to_lines$12;
    static final PyCode get_line$13;
    static final PyCode get_lines_containing_string$14;
    static final PyCode f$15;
    static final PyCode f$16;
    static final PyCode get_lines_matching_pattern$17;
    static final PyCode f$18;
    static final PyCode f$19;
    static final PyCode get_lines_matching_regexp$20;
    static final PyCode _get_matching_lines$21;
    static final PyCode get_regexp_matches$22;
    static final PyCode _parse_group$23;
    static final PyCode replace_string$24;
    static final PyCode replace_string_using_regexp$25;
    static final PyCode remove_string$26;
    static final PyCode remove_string_using_regexp$27;
    static final PyCode split_string$28;
    static final PyCode split_string_from_right$29;
    static final PyCode split_string_to_characters$30;
    static final PyCode fetch_from_left$31;
    static final PyCode fetch_from_right$32;
    static final PyCode generate_random_string$33;
    static final PyCode f$34;
    static final PyCode get_substring$35;
    static final PyCode strip_string$36;
    static final PyCode f$37;
    static final PyCode should_be_string$38;
    static final PyCode should_not_be_string$39;
    static final PyCode should_be_unicode_string$40;
    static final PyCode should_be_byte_string$41;
    static final PyCode should_be_lower_case$42;
    static final PyCode should_be_upper_case$43;
    static final PyCode should_be_title_case$44;
    static final PyCode _convert_to_index$45;
    static final PyCode _convert_to_integer$46;
    static final PyCode _fail$47;
    static final PyCode f$48;

    public PyObject f$0(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(16);
        Object[] objectArray = new String[]{"absolute_import"};
        objectArray = imp.importFrom("__future__", (String[])objectArray, pyFrame, 0);
        Object object = objectArray[0];
        pyFrame.setlocal("absolute_import", (PyObject)object);
        object = null;
        pyFrame.setline(18);
        objectArray = imp.importOne("os", pyFrame, 0);
        pyFrame.setlocal("os", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(19);
        objectArray = imp.importOne("re", pyFrame, 0);
        pyFrame.setlocal("re", (PyObject)objectArray);
        objectArray = null;
        pyFrame.setline(20);
        objectArray = new String[]{"fnmatchcase"};
        objectArray = imp.importFrom("fnmatch", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("fnmatchcase", (PyObject)object);
        object = null;
        pyFrame.setline(21);
        objectArray = new String[]{"randint"};
        objectArray = imp.importFrom("random", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("randint", (PyObject)object);
        object = null;
        pyFrame.setline(22);
        objectArray = new String[]{"ascii_lowercase", "ascii_uppercase", "digits"};
        objectArray = imp.importFrom("string", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("ascii_lowercase", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("ascii_uppercase", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("digits", (PyObject)object);
        object = null;
        pyFrame.setline(25);
        objectArray = new String[]{"logger"};
        objectArray = imp.importFrom("robot.api", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("logger", (PyObject)object);
        object = null;
        pyFrame.setline(26);
        objectArray = new String[]{"keyword"};
        objectArray = imp.importFrom("robot.api.deco", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("keyword", (PyObject)object);
        object = null;
        pyFrame.setline(27);
        objectArray = new String[]{"is_bytes", "is_string", "is_truthy", "is_unicode", "lower", "unic", "FileReader", "PY2", "PY3"};
        objectArray = imp.importFrom("robot.utils", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("is_bytes", (PyObject)object);
        object = null;
        object = objectArray[1];
        pyFrame.setlocal("is_string", (PyObject)object);
        object = null;
        object = objectArray[2];
        pyFrame.setlocal("is_truthy", (PyObject)object);
        object = null;
        object = objectArray[3];
        pyFrame.setlocal("is_unicode", (PyObject)object);
        object = null;
        object = objectArray[4];
        pyFrame.setlocal("lower", (PyObject)object);
        object = null;
        object = objectArray[5];
        pyFrame.setlocal("unic", (PyObject)object);
        object = null;
        object = objectArray[6];
        pyFrame.setlocal("FileReader", (PyObject)object);
        object = null;
        object = objectArray[7];
        pyFrame.setlocal("PY2", (PyObject)object);
        object = null;
        object = objectArray[8];
        pyFrame.setlocal("PY3", (PyObject)object);
        object = null;
        pyFrame.setline(29);
        objectArray = new String[]{"get_version"};
        objectArray = imp.importFrom("robot.version", (String[])objectArray, pyFrame, 0);
        object = objectArray[0];
        pyFrame.setlocal("get_version", (PyObject)object);
        object = null;
        pyFrame.setline(32);
        objectArray = new PyObject[]{pyFrame.getname("object")};
        object = Py.makeClass("String", (PyObject[])objectArray, String$1);
        pyFrame.setlocal("String", (PyObject)object);
        object = null;
        Arrays.fill(objectArray, null);
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject String$1(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setlocal("__module__", pyFrame.getname("__name__"));
        pyFrame.setlocal("__doc__", (PyObject)PyString.fromInterned("A test library for string manipulation and verification.\n\n    ``String`` is Robot Framework's standard library for manipulating\n    strings (e.g. `Replace String Using Regexp`, `Split To Lines`) and\n    verifying their contents (e.g. `Should Be String`).\n\n    Following keywords from ``BuiltIn`` library can also be used with strings:\n\n    - `Catenate`\n    - `Get Length`\n    - `Length Should Be`\n    - `Should (Not) Be Empty`\n    - `Should (Not) Be Equal (As Strings/Integers/Numbers)`\n    - `Should (Not) Match (Regexp)`\n    - `Should (Not) Contain`\n    - `Should (Not) Start With`\n    - `Should (Not) End With`\n    - `Convert To String`\n    - `Convert To Bytes`\n    "));
        pyFrame.setline(52);
        PyString.fromInterned("A test library for string manipulation and verification.\n\n    ``String`` is Robot Framework's standard library for manipulating\n    strings (e.g. `Replace String Using Regexp`, `Split To Lines`) and\n    verifying their contents (e.g. `Should Be String`).\n\n    Following keywords from ``BuiltIn`` library can also be used with strings:\n\n    - `Catenate`\n    - `Get Length`\n    - `Length Should Be`\n    - `Should (Not) Be Empty`\n    - `Should (Not) Be Equal (As Strings/Integers/Numbers)`\n    - `Should (Not) Match (Regexp)`\n    - `Should (Not) Contain`\n    - `Should (Not) Start With`\n    - `Should (Not) End With`\n    - `Convert To String`\n    - `Convert To Bytes`\n    ");
        pyFrame.setline(53);
        Object object = PyString.fromInterned("GLOBAL");
        pyFrame.setlocal("ROBOT_LIBRARY_SCOPE", (PyObject)object);
        object = null;
        pyFrame.setline(54);
        object = pyFrame.getname("get_version").__call__(threadState);
        pyFrame.setlocal("ROBOT_LIBRARY_VERSION", (PyObject)object);
        object = null;
        pyFrame.setline(56);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert_to_lower_case$2, PyString.fromInterned("Converts string to lower case.\n\n        Uses Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.lower|lower()]\n        method.\n\n        Examples:\n        | ${str1} = | Convert To Lower Case | ABC |\n        | ${str2} = | Convert To Lower Case | 1A2c3D |\n        | Should Be Equal | ${str1} | abc |\n        | Should Be Equal | ${str2} | 1a2c3d |\n        "));
        pyFrame.setlocal("convert_to_lower_case", (PyObject)object);
        object = null;
        pyFrame.setline(73);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert_to_upper_case$3, PyString.fromInterned("Converts string to upper case.\n\n        Uses Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.upper|upper()]\n        method.\n\n        Examples:\n        | ${str1} = | Convert To Upper Case | abc |\n        | ${str2} = | Convert To Upper Case | 1a2C3d |\n        | Should Be Equal | ${str1} | ABC |\n        | Should Be Equal | ${str2} | 1A2C3D |\n        "));
        pyFrame.setlocal("convert_to_upper_case", (PyObject)object);
        object = null;
        pyFrame.setline(88);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, convert_to_title_case$4, PyString.fromInterned("Converts string to title case.\n\n        Uses the following algorithm:\n\n        - Split the string to words from whitespace characters (spaces,\n          newlines, etc.).\n        - Exclude words that are not all lower case. This preserves,\n          for example, \"OK\" and \"iPhone\".\n        - Exclude also words listed in the optional ``exclude`` argument.\n        - Title case the first alphabetical character of each word that has\n          not been excluded.\n        - Join all words together so that original whitespace is preserved.\n\n        Explicitly excluded words can be given as a list or as a string with\n        words separated by a comma and an optional space. Excluded words are\n        actually considered to be regular expression patterns, so it is\n        possible to use something like \"example[.!?]?\" to match the word\n        \"example\" on it own and also if followed by \".\", \"!\" or \"?\".\n        See `BuiltIn.Should Match Regexp` for more information about Python\n        regular expression syntax in general and how to use it in Robot\n        Framework test data in particular.\n\n        Examples:\n        | ${str1} = | Convert To Title Case | hello, world!     |\n        | ${str2} = | Convert To Title Case | it's an OK iPhone | exclude=a, an, the |\n        | ${str3} = | Convert To Title Case | distance is 1 km. | exclude=is, km.? |\n        | Should Be Equal | ${str1} | Hello, World! |\n        | Should Be Equal | ${str2} | It's an OK iPhone |\n        | Should Be Equal | ${str3} | Distance is 1 km. |\n\n        The reason this keyword does not use Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.title|title()]\n        method is that it can yield undesired results, for example, if\n        strings contain upper case letters or special characters like\n        apostrophes. It would, for example, convert \"it's an OK iPhone\"\n        to \"It'S An Ok Iphone\".\n\n        New in Robot Framework 3.2.\n        "));
        PyObject[] pyObjectArray = new PyObject[]{pyFrame.getname("None")};
        String[] stringArray = new String[]{"types"};
        PyObject pyObject = pyFrame.getname("keyword").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        object = pyObject.__call__(threadState, (PyObject)object);
        pyFrame.setlocal("convert_to_title_case", (PyObject)object);
        object = null;
        pyFrame.setline(148);
        object = new PyObject[]{PyString.fromInterned("strict")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, encode_string_to_bytes$8, PyString.fromInterned("Encodes the given Unicode ``string`` to bytes using the given ``encoding``.\n\n        ``errors`` argument controls what to do if encoding some characters fails.\n        All values accepted by ``encode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be encoded (default)\n        - ``ignore``: ignore characters that cannot be encoded\n        - ``replace``: replace characters that cannot be encoded with\n          a replacement character\n\n        Examples:\n        | ${bytes} = | Encode String To Bytes | ${string} | UTF-8 |\n        | ${bytes} = | Encode String To Bytes | ${string} | ASCII | errors=ignore |\n\n        Use `Convert To Bytes` in ``BuiltIn`` if you want to create bytes based\n        on character or integer sequences. Use `Decode Bytes To String` if you\n        need to convert byte strings to Unicode strings and `Convert To String`\n        in ``BuiltIn`` if you need to convert arbitrary objects to Unicode.\n        "));
        pyFrame.setlocal("encode_string_to_bytes", (PyObject)object);
        object = null;
        pyFrame.setline(171);
        object = new PyObject[]{PyString.fromInterned("strict")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, decode_bytes_to_string$9, PyString.fromInterned("Decodes the given ``bytes`` to a Unicode string using the given ``encoding``.\n\n        ``errors`` argument controls what to do if decoding some bytes fails.\n        All values accepted by ``decode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be decoded (default)\n        - ``ignore``: ignore characters that cannot be decoded\n        - ``replace``: replace characters that cannot be decoded with\n          a replacement character\n\n        Examples:\n        | ${string} = | Decode Bytes To String | ${bytes} | UTF-8 |\n        | ${string} = | Decode Bytes To String | ${bytes} | ASCII | errors=ignore |\n\n        Use `Encode String To Bytes` if you need to convert Unicode strings to\n        byte strings, and `Convert To String` in ``BuiltIn`` if you need to\n        convert arbitrary objects to Unicode strings.\n        "));
        pyFrame.setlocal("decode_bytes_to_string", (PyObject)object);
        object = null;
        pyFrame.setline(195);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, format_string$10, PyString.fromInterned("Formats a ``template`` using the given ``positional`` and ``named`` arguments.\n\n        The template can be either be a string or an absolute path to\n        an existing file. In the latter case the file is read and its contents\n        are used as the template. If the template file contains non-ASCII\n        characters, it must be encoded using UTF-8.\n\n        The template is formatted using Python's\n        [https://docs.python.org/library/string.html#format-string-syntax|format\n        string syntax]. Placeholders are marked using ``{}`` with possible\n        field name and format specification inside. Literal curly braces\n        can be inserted by doubling them like `{{` and `}}`.\n\n        Examples:\n        | ${to} = | Format String | To: {} <{}>                    | ${user}      | ${email} |\n        | ${to} = | Format String | To: {name} <{email}>           | name=${name} | email=${email} |\n        | ${to} = | Format String | To: {user.name} <{user.email}> | user=${user} |\n        | ${xx} = | Format String | {:*^30}                        | centered     |\n        | ${yy} = | Format String | {0:{width}{base}}              | ${42}        | base=X | width=10 |\n        | ${zz} = | Format String | ${CURDIR}/template.txt         | positional   | named=value |\n\n        New in Robot Framework 3.1.\n        "));
        pyFrame.setlocal("format_string", (PyObject)object);
        object = null;
        pyFrame.setline(227);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_line_count$11, PyString.fromInterned("Returns and logs the number of lines in the given string."));
        pyFrame.setlocal("get_line_count", (PyObject)object);
        object = null;
        pyFrame.setline(233);
        object = new PyObject[]{Py.newInteger(0), pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_to_lines$12, PyString.fromInterned("Splits the given string to lines.\n\n        It is possible to get only a selection of lines from ``start``\n        to ``end`` so that ``start`` index is inclusive and ``end`` is\n        exclusive. Line numbering starts from 0, and it is possible to\n        use negative indices to refer to lines from the end.\n\n        Lines are returned without the newlines. The number of\n        returned lines is automatically logged.\n\n        Examples:\n        | @{lines} =        | Split To Lines | ${manylines} |    |    |\n        | @{ignore first} = | Split To Lines | ${manylines} | 1  |    |\n        | @{ignore last} =  | Split To Lines | ${manylines} |    | -1 |\n        | @{5th to 10th} =  | Split To Lines | ${manylines} | 4  | 10 |\n        | @{first two} =    | Split To Lines | ${manylines} |    | 1  |\n        | @{last two} =     | Split To Lines | ${manylines} | -2 |    |\n\n        Use `Get Line` if you only need to get a single line.\n        "));
        pyFrame.setlocal("split_to_lines", (PyObject)object);
        object = null;
        pyFrame.setline(260);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_line$13, PyString.fromInterned("Returns the specified line from the given ``string``.\n\n        Line numbering starts from 0 and it is possible to use\n        negative indices to refer to lines from the end. The line is\n        returned without the newline character.\n\n        Examples:\n        | ${first} =    | Get Line | ${string} | 0  |\n        | ${2nd last} = | Get Line | ${string} | -2 |\n\n        Use `Split To Lines` if all lines are needed.\n        "));
        pyFrame.setlocal("get_line", (PyObject)object);
        object = null;
        pyFrame.setline(276);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_containing_string$14, PyString.fromInterned("Returns lines of the given ``string`` that contain the ``pattern``.\n\n        The ``pattern`` is always considered to be a normal string, not a glob\n        or regexp pattern. A line matches if the ``pattern`` is found anywhere\n        on it.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Containing String | ${result} | An example |\n        | ${ret} =   | Get Lines Containing String | ${ret} | FAIL | case-insensitive |\n\n        See `Get Lines Matching Pattern` and `Get Lines Matching Regexp`\n        if you need more complex pattern matching.\n        "));
        pyFrame.setlocal("get_lines_containing_string", (PyObject)object);
        object = null;
        pyFrame.setline(307);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_matching_pattern$17, PyString.fromInterned("Returns lines of the given ``string`` that match the ``pattern``.\n\n        The ``pattern`` is a _glob pattern_ where:\n        | ``*``        | matches everything |\n        | ``?``        | matches any single character |\n        | ``[chars]``  | matches any character inside square brackets (e.g. ``[abc]`` matches either ``a``, ``b`` or ``c``) |\n        | ``[!chars]`` | matches any character not inside square brackets |\n\n        A line matches only if it matches the ``pattern`` fully.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Pattern | ${result} | Wild???? example |\n        | ${ret} = | Get Lines Matching Pattern | ${ret} | FAIL: * | case_insensitive=true |\n\n        See `Get Lines Matching Regexp` if you need more complex\n        patterns and `Get Lines Containing String` if searching\n        literal strings is enough.\n        "));
        pyFrame.setlocal("get_lines_matching_pattern", (PyObject)object);
        object = null;
        pyFrame.setline(343);
        object = new PyObject[]{pyFrame.getname("False")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_lines_matching_regexp$20, PyString.fromInterned("Returns lines of the given ``string`` that match the regexp ``pattern``.\n\n        See `BuiltIn.Should Match Regexp` for more information about\n        Python regular expression syntax in general and how to use it\n        in Robot Framework test data in particular.\n\n        By default lines match only if they match the pattern fully, but\n        partial matching can be enabled by giving the ``partial_match``\n        argument a true value. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        If the pattern is empty, it matches only empty lines by default.\n        When partial matching is enabled, empty pattern matches all lines.\n\n        Notice that to make the match case-insensitive, you need to prefix\n        the pattern with case-insensitive flag ``(?i)``.\n\n        Lines are returned as one string concatenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example |\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example | partial_match=true |\n        | ${ret} =   | Get Lines Matching Regexp | ${ret}    | (?i)FAIL: .* |\n\n        See `Get Lines Matching Pattern` and `Get Lines Containing\n        String` if you do not need full regular expression powers (and\n        complexity).\n        "));
        pyFrame.setlocal("get_lines_matching_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(380);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _get_matching_lines$21, null);
        pyFrame.setlocal("_get_matching_lines", (PyObject)object);
        object = null;
        pyFrame.setline(386);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_regexp_matches$22, PyString.fromInterned("Returns a list of all non-overlapping matches in the given string.\n\n        ``string`` is the string to find matches from and ``pattern`` is the\n        regular expression. See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general and how\n        to use it in Robot Framework test data in particular.\n\n        If no groups are used, the returned list contains full matches. If one\n        group is used, the list contains only contents of that group. If\n        multiple groups are used, the list contains tuples that contain\n        individual group contents. All groups can be given as indexes (starting\n        from 1) and named groups also as names.\n\n        Examples:\n        | ${no match} =    | Get Regexp Matches | the string | xxx     |\n        | ${matches} =     | Get Regexp Matches | the string | t..     |\n        | ${one group} =   | Get Regexp Matches | the string | t(..)   | 1 |\n        | ${named group} = | Get Regexp Matches | the string | t(?P<name>..) | name |\n        | ${two groups} =  | Get Regexp Matches | the string | t(.)(.) | 1 | 2 |\n        =>\n        | ${no match} = []\n        | ${matches} = ['the', 'tri']\n        | ${one group} = ['he', 'ri']\n        | ${named group} = ['he', 'ri']\n        | ${two groups} = [('h', 'e'), ('r', 'i')]\n        "));
        pyFrame.setlocal("get_regexp_matches", (PyObject)object);
        object = null;
        pyFrame.setline(417);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _parse_group$23, null);
        pyFrame.setlocal("_parse_group", (PyObject)object);
        object = null;
        pyFrame.setline(423);
        object = new PyObject[]{Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, replace_string$24, PyString.fromInterned("Replaces ``search_for`` in the given ``string`` with ``replace_with``.\n\n        ``search_for`` is used as a literal string. See `Replace String\n        Using Regexp` if more powerful pattern matching is needed.\n        If you need to just remove a string see `Remove String`.\n\n        If the optional argument ``count`` is given, only that many\n        occurrences from left are replaced. Negative ``count`` means\n        that all occurrences are replaced (default behaviour) and zero\n        means that nothing is done.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Replace String | Hello, world!  | world | tellus   |\n        | Should Be Equal | ${str}         | Hello, tellus! |       |          |\n        | ${str} =        | Replace String | Hello, world!  | l     | ${EMPTY} | count=1 |\n        | Should Be Equal | ${str}         | Helo, world!   |       |          |\n        "));
        pyFrame.setlocal("replace_string", (PyObject)object);
        object = null;
        pyFrame.setline(447);
        object = new PyObject[]{Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, replace_string_using_regexp$25, PyString.fromInterned("Replaces ``pattern`` in the given ``string`` with ``replace_with``.\n\n        This keyword is otherwise identical to `Replace String`, but\n        the ``pattern`` to search for is considered to be a regular\n        expression.  See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general\n        and how to use it in Robot Framework test data in particular.\n\n        If you need to just remove a string see `Remove String Using Regexp`.\n\n        Examples:\n        | ${str} = | Replace String Using Regexp | ${str} | 20\\\\d\\\\d-\\\\d\\\\d-\\\\d\\\\d | <DATE> |\n        | ${str} = | Replace String Using Regexp | ${str} | (Hello|Hi) | ${EMPTY} | count=1 |\n        "));
        pyFrame.setlocal("replace_string_using_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(468);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, remove_string$26, PyString.fromInterned("Removes all ``removables`` from the given ``string``.\n\n        ``removables`` are used as literal strings. Each removable will be\n        matched to a temporary string from which preceding removables have\n        been already removed. See second example below.\n\n        Use `Remove String Using Regexp` if more powerful pattern matching is\n        needed. If only a certain number of matches should be removed,\n        `Replace String` or `Replace String Using Regexp` can be used.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Remove String | Robot Framework | work   |\n        | Should Be Equal | ${str}        | Robot Frame     |\n        | ${str} =        | Remove String | Robot Framework | o | bt |\n        | Should Be Equal | ${str}        | R Framewrk      |\n        "));
        pyFrame.setlocal("remove_string", (PyObject)object);
        object = null;
        pyFrame.setline(492);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, remove_string_using_regexp$27, PyString.fromInterned("Removes ``patterns`` from the given ``string``.\n\n        This keyword is otherwise identical to `Remove String`, but\n        the ``patterns`` to search for are considered to be a regular\n        expression. See `Replace String Using Regexp` for more information\n        about the regular expression syntax. That keyword can also be\n        used if there is a need to remove only a certain number of\n        occurrences.\n        "));
        pyFrame.setlocal("remove_string_using_regexp", (PyObject)object);
        object = null;
        pyFrame.setline(506);
        object = new PyObject[]{pyFrame.getname("None"), Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string$28, PyString.fromInterned("Splits the ``string`` using ``separator`` as a delimiter string.\n\n        If a ``separator`` is not given, any whitespace string is a\n        separator. In that case also possible consecutive whitespace\n        as well as leading and trailing whitespace is ignored.\n\n        Split words are returned as a list. If the optional\n        ``max_split`` is given, at most ``max_split`` splits are done, and\n        the returned list will have maximum ``max_split + 1`` elements.\n\n        Examples:\n        | @{words} =         | Split String | ${string} |\n        | @{words} =         | Split String | ${string} | ,${SPACE} |\n        | ${pre} | ${post} = | Split String | ${string} | ::    | 1 |\n\n        See `Split String From Right` if you want to start splitting\n        from right, and `Fetch From Left` and `Fetch From Right` if\n        you only want to get first/last part of the string.\n        "));
        pyObjectArray = new PyObject[]{pyFrame.getname("None")};
        stringArray = new String[]{"types"};
        PyObject pyObject2 = pyFrame.getname("keyword").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        object = pyObject2.__call__(threadState, (PyObject)object);
        pyFrame.setlocal("split_string", (PyObject)object);
        object = null;
        pyFrame.setline(532);
        object = new PyObject[]{pyFrame.getname("None"), Py.newInteger(-1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string_from_right$29, PyString.fromInterned("Splits the ``string`` using ``separator`` starting from right.\n\n        Same as `Split String`, but splitting is started from right. This has\n        an effect only when ``max_split`` is given.\n\n        Examples:\n        | ${first} | ${rest} = | Split String            | ${string} | - | 1 |\n        | ${rest}  | ${last} = | Split String From Right | ${string} | - | 1 |\n        "));
        pyObjectArray = new PyObject[]{pyFrame.getname("None")};
        stringArray = new String[]{"types"};
        PyObject pyObject3 = pyFrame.getname("keyword").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        object = pyObject3.__call__(threadState, (PyObject)object);
        pyFrame.setlocal("split_string_from_right", (PyObject)object);
        object = null;
        pyFrame.setline(548);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, split_string_to_characters$30, PyString.fromInterned("Splits the given ``string`` to characters.\n\n        Example:\n        | @{characters} = | Split String To Characters | ${string} |\n        "));
        pyFrame.setlocal("split_string_to_characters", (PyObject)object);
        object = null;
        pyFrame.setline(556);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, fetch_from_left$31, PyString.fromInterned("Returns contents of the ``string`` before the first occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Right`, `Split String` and `Split String\n        From Right`.\n        "));
        pyFrame.setlocal("fetch_from_left", (PyObject)object);
        object = null;
        pyFrame.setline(566);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, fetch_from_right$32, PyString.fromInterned("Returns contents of the ``string`` after the last occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Left`, `Split String` and `Split String\n        From Right`.\n        "));
        pyFrame.setlocal("fetch_from_right", (PyObject)object);
        object = null;
        pyFrame.setline(576);
        object = new PyObject[]{Py.newInteger(8), PyString.fromInterned("[LETTERS][NUMBERS]")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, generate_random_string$33, PyString.fromInterned("Generates a string with a desired ``length`` from the given ``chars``.\n\n        The population sequence ``chars`` contains the characters to use\n        when generating the random string. It can contain any\n        characters, and it is possible to use special markers\n        explained in the table below:\n\n        |  = Marker =   |               = Explanation =                   |\n        | ``[LOWER]``   | Lowercase ASCII characters from ``a`` to ``z``. |\n        | ``[UPPER]``   | Uppercase ASCII characters from ``A`` to ``Z``. |\n        | ``[LETTERS]`` | Lowercase and uppercase ASCII characters.       |\n        | ``[NUMBERS]`` | Numbers from 0 to 9.                            |\n\n        Examples:\n        | ${ret} = | Generate Random String |\n        | ${low} = | Generate Random String | 12 | [LOWER]         |\n        | ${bin} = | Generate Random String | 8  | 01              |\n        | ${hex} = | Generate Random String | 4  | [NUMBERS]abcdef |\n        "));
        pyFrame.setlocal("generate_random_string", (PyObject)object);
        object = null;
        pyFrame.setline(607);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, get_substring$35, PyString.fromInterned("Returns a substring from ``start`` index to ``end`` index.\n\n        The ``start`` index is inclusive and ``end`` is exclusive.\n        Indexing starts from 0, and it is possible to use\n        negative indices to refer to characters from the end.\n\n        Examples:\n        | ${ignore first} = | Get Substring | ${string} | 1  |    |\n        | ${ignore last} =  | Get Substring | ${string} |    | -1 |\n        | ${5th to 10th} =  | Get Substring | ${string} | 4  | 10 |\n        | ${first two} =    | Get Substring | ${string} |    | 1  |\n        | ${last two} =     | Get Substring | ${string} | -2 |    |\n        "));
        pyFrame.setlocal("get_substring", (PyObject)object);
        object = null;
        pyFrame.setline(625);
        object = new PyObject[]{PyString.fromInterned("both"), pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, strip_string$36, PyString.fromInterned("Remove leading and/or trailing whitespaces from the given string.\n\n        ``mode`` is either ``left`` to remove leading characters, ``right`` to\n        remove trailing characters, ``both`` (default) to remove the\n        characters from both sides of the string or ``none`` to return the\n        unmodified string.\n\n        If the optional ``characters`` is given, it must be a string and the\n        characters in the string will be stripped in the string. Please note,\n        that this is not a substring to be removed but a list of characters,\n        see the example below.\n\n        Examples:\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | |\n        | Should Be Equal | ${stripped} | Hello | |\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | mode=left |\n        | Should Be Equal | ${stripped} | Hello${SPACE} | |\n        | ${stripped}=  | Strip String | aabaHelloeee | characters=abe |\n        | Should Be Equal | ${stripped} | Hello | |\n        "));
        pyObjectArray = new PyObject[]{pyFrame.getname("None")};
        stringArray = new String[]{"types"};
        PyObject pyObject4 = pyFrame.getname("keyword").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        object = pyObject4.__call__(threadState, (PyObject)object);
        pyFrame.setlocal("strip_string", (PyObject)object);
        object = null;
        pyFrame.setline(656);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_string$38, PyString.fromInterned("Fails if the given ``item`` is not a string.\n\n        With Python 2, except with IronPython, this keyword passes regardless\n        is the ``item`` a Unicode string or a byte string. Use `Should Be\n        Unicode String` or `Should Be Byte String` if you want to restrict\n        the string type. Notice that with Python 2, except with IronPython,\n        ``'string'`` creates a byte string and ``u'unicode'`` must be used to\n        create a Unicode string.\n\n        With Python 3 and IronPython, this keyword passes if the string is\n        a Unicode string but fails if it is bytes. Notice that with both\n        Python 3 and IronPython, ``'string'`` creates a Unicode string, and\n        ``b'bytes'`` must be used to create a byte string.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_string", (PyObject)object);
        object = null;
        pyFrame.setline(677);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_not_be_string$39, PyString.fromInterned("Fails if the given ``item`` is a string.\n\n        See `Should Be String` for more details about Unicode strings and byte\n        strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_not_be_string", (PyObject)object);
        object = null;
        pyFrame.setline(689);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_unicode_string$40, PyString.fromInterned("Fails if the given ``item`` is not a Unicode string.\n\n        Use `Should Be Byte String` if you want to verify the ``item`` is a\n        byte string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode\n        strings and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_unicode_string", (PyObject)object);
        object = null;
        pyFrame.setline(703);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_byte_string$41, PyString.fromInterned("Fails if the given ``item`` is not a byte string.\n\n        Use `Should Be Unicode String` if you want to verify the ``item`` is a\n        Unicode string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode strings\n        and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        "));
        pyFrame.setlocal("should_be_byte_string", (PyObject)object);
        object = null;
        pyFrame.setline(717);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_lower_case$42, PyString.fromInterned("Fails if the given ``string`` is not in lower case.\n\n        For example, ``'string'`` and ``'with specials!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Upper Case` and `Should Be Title Case`.\n        "));
        pyFrame.setlocal("should_be_lower_case", (PyObject)object);
        object = null;
        pyFrame.setline(731);
        object = new PyObject[]{pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_upper_case$43, PyString.fromInterned("Fails if the given ``string`` is not in upper case.\n\n        For example, ``'STRING'`` and ``'WITH SPECIALS!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Title Case` and `Should Be Lower Case`.\n        "));
        pyFrame.setlocal("should_be_upper_case", (PyObject)object);
        object = null;
        pyFrame.setline(745);
        object = new PyObject[]{pyFrame.getname("None"), pyFrame.getname("None")};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, should_be_title_case$44, PyString.fromInterned("Fails if given ``string`` is not title.\n\n        ``string`` is a title cased string if there is at least one upper case\n        letter in each word.\n\n        For example, ``'This Is Title'`` and ``'OK, Give Me My iPhone'``\n        would pass. ``'all words lower'`` and ``'Word In lower'`` would fail.\n\n        This logic changed in Robot Framework 4.0 to be compatible with\n        `Convert to Title Case`. See `Convert to Title Case` for title case\n        algorithm and reasoning.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        Words can be explicitly excluded with the optional ``exclude`` argument.\n\n        Explicitly excluded words can be given as a list or as a string with\n        words separated by a comma and an optional space. Excluded words are\n        actually considered to be regular expression patterns, so it is\n        possible to use something like \"example[.!?]?\" to match the word\n        \"example\" on it own and also if followed by \".\", \"!\" or \"?\".\n        See `BuiltIn.Should Match Regexp` for more information about Python\n        regular expression syntax in general and how to use it in Robot\n        Framework test data in particular.\n\n        See also `Should Be Upper Case` and `Should Be Lower Case`.\n        "));
        pyObjectArray = new PyObject[]{pyFrame.getname("None")};
        stringArray = new String[]{"types"};
        PyObject pyObject5 = pyFrame.getname("keyword").__call__(threadState, pyObjectArray, stringArray);
        pyObjectArray = null;
        object = pyObject5.__call__(threadState, (PyObject)object);
        pyFrame.setlocal("should_be_title_case", (PyObject)object);
        object = null;
        pyFrame.setline(784);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_index$45, null);
        pyFrame.setlocal("_convert_to_index", (PyObject)object);
        object = null;
        pyFrame.setline(791);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _convert_to_integer$46, null);
        pyFrame.setlocal("_convert_to_integer", (PyObject)object);
        object = null;
        pyFrame.setline(798);
        object = Py.EmptyObjects;
        object = new PyFunction(pyFrame.f_globals, (PyObject[])object, _fail$47, null);
        pyFrame.setlocal("_fail", (PyObject)object);
        object = null;
        return pyFrame.getf_locals();
    }

    public PyObject convert_to_lower_case$2(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(68);
        PyString.fromInterned("Converts string to lower case.\n\n        Uses Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.lower|lower()]\n        method.\n\n        Examples:\n        | ${str1} = | Convert To Lower Case | ABC |\n        | ${str2} = | Convert To Lower Case | 1A2c3D |\n        | Should Be Equal | ${str1} | abc |\n        | Should Be Equal | ${str2} | 1a2c3d |\n        ");
        pyFrame.setline(71);
        PyObject pyObject = pyFrame.getglobal("lower").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject convert_to_upper_case$3(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(85);
        PyString.fromInterned("Converts string to upper case.\n\n        Uses Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.upper|upper()]\n        method.\n\n        Examples:\n        | ${str1} = | Convert To Upper Case | abc |\n        | ${str2} = | Convert To Upper Case | 1a2C3d |\n        | Should Be Equal | ${str1} | ABC |\n        | Should Be Equal | ${str2} | 1A2C3D |\n        ");
        pyFrame.setline(86);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("upper").__call__(threadState);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject convert_to_title_case$4(PyFrame pyFrame, ThreadState threadState) {
        PyList pyList;
        Object object;
        block11: {
            PyObject pyObject;
            block10: {
                block9: {
                    PyList pyList2;
                    block8: {
                        PyObject pyObject2;
                        block7: {
                            block6: {
                                pyFrame.to_cell(2, 0);
                                pyFrame.setline(128);
                                PyString.fromInterned("Converts string to title case.\n\n        Uses the following algorithm:\n\n        - Split the string to words from whitespace characters (spaces,\n          newlines, etc.).\n        - Exclude words that are not all lower case. This preserves,\n          for example, \"OK\" and \"iPhone\".\n        - Exclude also words listed in the optional ``exclude`` argument.\n        - Title case the first alphabetical character of each word that has\n          not been excluded.\n        - Join all words together so that original whitespace is preserved.\n\n        Explicitly excluded words can be given as a list or as a string with\n        words separated by a comma and an optional space. Excluded words are\n        actually considered to be regular expression patterns, so it is\n        possible to use something like \"example[.!?]?\" to match the word\n        \"example\" on it own and also if followed by \".\", \"!\" or \"?\".\n        See `BuiltIn.Should Match Regexp` for more information about Python\n        regular expression syntax in general and how to use it in Robot\n        Framework test data in particular.\n\n        Examples:\n        | ${str1} = | Convert To Title Case | hello, world!     |\n        | ${str2} = | Convert To Title Case | it's an OK iPhone | exclude=a, an, the |\n        | ${str3} = | Convert To Title Case | distance is 1 km. | exclude=is, km.? |\n        | Should Be Equal | ${str1} | Hello, World! |\n        | Should Be Equal | ${str2} | It's an OK iPhone |\n        | Should Be Equal | ${str3} | Distance is 1 km. |\n\n        The reason this keyword does not use Python's standard\n        [https://docs.python.org/library/stdtypes.html#str.title|title()]\n        method is that it can yield undesired results, for example, if\n        strings contain upper case letters or special characters like\n        apostrophes. It would, for example, convert \"it's an OK iPhone\"\n        to \"It'S An Ok Iphone\".\n\n        New in Robot Framework 3.2.\n        ");
                                pyFrame.setline(129);
                                if (pyFrame.getglobal("is_unicode").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
                                    pyFrame.setline(130);
                                    throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, (PyObject)PyString.fromInterned("This keyword works only with Unicode strings.")));
                                }
                                pyFrame.setline(131);
                                if (!pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getderef(0)).__nonzero__()) break block6;
                                pyFrame.setline(132);
                                pyList2 = new PyList();
                                PyObject pyObject3 = pyList2.__getattr__("append");
                                pyFrame.setlocal(3, pyObject3);
                                Object var3_4 = null;
                                pyFrame.setline(132);
                                pyObject2 = pyFrame.getderef(0).__getattr__("split").__call__(threadState, (PyObject)PyString.fromInterned(",")).__iter__();
                                if (!true) break block7;
                                pyFrame.setline(132);
                                if ((object = pyObject2.__iternext__()) == null) break block8;
                            }
                            pyFrame.setline(133);
                            if (pyFrame.getderef(0).__not__().__nonzero__()) {
                                pyFrame.setline(134);
                                PyList pyList3 = new PyList(Py.EmptyObjects);
                                pyFrame.setderef(0, pyList3);
                                Object var3_9 = null;
                            }
                            break block9;
                        }
                        do {
                            pyFrame.setlocal(4, (PyObject)object);
                            pyFrame.setline(132);
                            pyFrame.getlocal(3).__call__(threadState, pyFrame.getlocal(4).__getattr__("strip").__call__(threadState));
                            pyFrame.setline(132);
                        } while ((object = pyObject2.__iternext__()) != null);
                    }
                    pyFrame.setline(132);
                    pyFrame.dellocal(3);
                    PyList pyList4 = pyList2;
                    pyFrame.setderef(0, pyList4);
                    Object var3_7 = null;
                }
                pyFrame.setline(135);
                pyList = new PyList();
                PyObject pyObject4 = pyList.__getattr__("append");
                pyFrame.setlocal(5, pyObject4);
                Object var3_12 = null;
                pyFrame.setline(135);
                pyObject = pyFrame.getderef(0).__iter__();
                if (!true) break block10;
                pyFrame.setline(135);
                if ((object = pyObject.__iternext__()) == null) break block11;
            }
            do {
                pyFrame.setlocal(4, (PyObject)object);
                pyFrame.setline(135);
                pyFrame.getlocal(5).__call__(threadState, pyFrame.getglobal("re").__getattr__("compile").__call__(threadState, PyString.fromInterned("^%s$")._mod(pyFrame.getlocal(4))));
                pyFrame.setline(135);
            } while ((object = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(135);
        pyFrame.dellocal(5);
        PyList pyList5 = pyList;
        pyFrame.setderef(0, pyList5);
        Object var3_15 = null;
        pyFrame.setline(137);
        PyObject[] pyObjectArray2 = Py.EmptyObjects;
        pyObjectArray2 = new PyObject[]{pyFrame.getclosure(0)};
        PyFunction pyFunction = new PyFunction(pyFrame.f_globals, pyObjectArray, title$5, null, pyObjectArray2);
        pyFrame.setderef(1, pyFunction);
        Object var3_19 = null;
        pyFrame.setline(145);
        PyObject[] pyObjectArray3 = new PyObject[]{PyString.fromInterned("(\\s+)"), pyFrame.getlocal(1), pyFrame.getglobal("re").__getattr__("UNICODE")};
        object = new String[]{"flags"};
        Object var3_21 = null;
        PyObject pyObject = pyFrame.getglobal("re").__getattr__("split").__call__(threadState, pyObjectArray3, (String[])object);
        pyFrame.setlocal(6, pyObject);
        Object var3_23 = null;
        pyFrame.setline(146);
        PyObject pyObject5 = PyString.fromInterned("").__getattr__("join");
        pyFrame.setline(146);
        Object[] objectArray = Py.EmptyObjects;
        object = new PyObject[]{pyFrame.getclosure(1)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, f$7, null, (PyObject[])object);
        PyObject pyObject6 = ((PyObject)object).__call__(threadState, pyFrame.getlocal(6).__iter__());
        Arrays.fill(objectArray, null);
        PyObject pyObject7 = pyObject5.__call__(threadState, pyObject6);
        pyFrame.f_lasti = -1;
        return pyObject7;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject title$5(PyFrame pyFrame, ThreadState threadState) {
        block6: {
            PyObject pyObject;
            Object object;
            block5: {
                pyFrame.to_cell(0, 0);
                pyFrame.setline(138);
                PyObject pyObject2 = pyFrame.getglobal("any");
                pyFrame.setline(138);
                Object[] objectArray = Py.EmptyObjects;
                object = new PyObject[]{pyFrame.getclosure(0)};
                object = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, f$6, null, (PyObject[])object);
                PyObject pyObject3 = ((PyObject)object).__call__(threadState, pyFrame.getderef(1).__iter__());
                Arrays.fill(objectArray, null);
                PyObject pyObject4 = pyObject2.__call__(threadState, pyObject3);
                if (!pyObject4.__nonzero__()) {
                    pyObject4 = pyFrame.getderef(0).__getattr__("islower").__call__(threadState).__not__();
                }
                if (pyObject4.__nonzero__()) {
                    pyFrame.setline(139);
                    PyObject pyObject5 = pyFrame.getderef(0);
                    pyFrame.f_lasti = -1;
                    return pyObject5;
                }
                pyFrame.setline(140);
                object = pyFrame.getglobal("enumerate").__call__(threadState, pyFrame.getderef(0)).__iter__();
                if (!true) break block5;
                pyFrame.setline(140);
                if ((pyObject = ((PyObject)object).__iternext__()) == null) break block6;
            }
            do {
                PyObject[] pyObjectArray = Py.unpackSequence(pyObject, 2);
                PyObject pyObject6 = pyObjectArray[0];
                pyFrame.setlocal(2, pyObject6);
                pyObject6 = null;
                pyObject6 = pyObjectArray[1];
                pyFrame.setlocal(3, pyObject6);
                pyObject6 = null;
                pyFrame.setline(141);
                if (pyFrame.getlocal(3).__getattr__("isalpha").__call__(threadState).__nonzero__()) {
                    pyFrame.setline(142);
                    PyObject pyObject7 = pyFrame.getderef(0).__getslice__(null, pyFrame.getlocal(2), null)._add(pyFrame.getderef(0).__getitem__(pyFrame.getlocal(2)).__getattr__("title").__call__(threadState))._add(pyFrame.getderef(0).__getslice__(pyFrame.getlocal(2)._add(Py.newInteger(1)), null, null));
                    pyFrame.f_lasti = -1;
                    return pyObject7;
                }
                pyFrame.setline(140);
            } while ((pyObject = ((PyObject)object).__iternext__()) != null);
        }
        pyFrame.setline(143);
        PyObject pyObject = pyFrame.getderef(0);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$6(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(138);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(138);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(138);
            pyFrame.setline(138);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getlocal(1).__getattr__("match").__call__(threadState, pyFrame.getderef(0));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$7(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(146);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(146);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(146);
            pyFrame.setline(146);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getderef(0).__call__(threadState, pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject encode_string_to_bytes$8(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(168);
        PyString.fromInterned("Encodes the given Unicode ``string`` to bytes using the given ``encoding``.\n\n        ``errors`` argument controls what to do if encoding some characters fails.\n        All values accepted by ``encode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be encoded (default)\n        - ``ignore``: ignore characters that cannot be encoded\n        - ``replace``: replace characters that cannot be encoded with\n          a replacement character\n\n        Examples:\n        | ${bytes} = | Encode String To Bytes | ${string} | UTF-8 |\n        | ${bytes} = | Encode String To Bytes | ${string} | ASCII | errors=ignore |\n\n        Use `Convert To Bytes` in ``BuiltIn`` if you want to create bytes based\n        on character or integer sequences. Use `Decode Bytes To String` if you\n        need to convert byte strings to Unicode strings and `Convert To String`\n        in ``BuiltIn`` if you need to convert arbitrary objects to Unicode.\n        ");
        pyFrame.setline(169);
        PyObject pyObject = pyFrame.getglobal("bytes").__call__(threadState, pyFrame.getlocal(1).__getattr__("encode").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3)));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject decode_bytes_to_string$9(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(190);
        PyString.fromInterned("Decodes the given ``bytes`` to a Unicode string using the given ``encoding``.\n\n        ``errors`` argument controls what to do if decoding some bytes fails.\n        All values accepted by ``decode`` method in Python are valid, but in\n        practice the following values are most useful:\n\n        - ``strict``: fail if characters cannot be decoded (default)\n        - ``ignore``: ignore characters that cannot be decoded\n        - ``replace``: replace characters that cannot be decoded with\n          a replacement character\n\n        Examples:\n        | ${string} = | Decode Bytes To String | ${bytes} | UTF-8 |\n        | ${string} = | Decode Bytes To String | ${bytes} | ASCII | errors=ignore |\n\n        Use `Encode String To Bytes` if you need to convert Unicode strings to\n        byte strings, and `Convert To String` in ``BuiltIn`` if you need to\n        convert arbitrary objects to Unicode strings.\n        ");
        pyFrame.setline(191);
        PyObject pyObject = pyFrame.getglobal("PY3");
        if (pyObject.__nonzero__()) {
            pyObject = pyFrame.getglobal("is_unicode").__call__(threadState, pyFrame.getlocal(1));
        }
        if (pyObject.__nonzero__()) {
            pyFrame.setline(192);
            throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, (PyObject)PyString.fromInterned("Can not decode strings on Python 3.")));
        }
        pyFrame.setline(193);
        PyObject pyObject2 = pyFrame.getlocal(1).__getattr__("decode").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject2;
    }

    public PyObject format_string$10(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        Object object2;
        block4: {
            pyFrame.f_exits = new PyObject[1];
            pyFrame.setline(218);
            PyString.fromInterned("Formats a ``template`` using the given ``positional`` and ``named`` arguments.\n\n        The template can be either be a string or an absolute path to\n        an existing file. In the latter case the file is read and its contents\n        are used as the template. If the template file contains non-ASCII\n        characters, it must be encoded using UTF-8.\n\n        The template is formatted using Python's\n        [https://docs.python.org/library/string.html#format-string-syntax|format\n        string syntax]. Placeholders are marked using ``{}`` with possible\n        field name and format specification inside. Literal curly braces\n        can be inserted by doubling them like `{{` and `}}`.\n\n        Examples:\n        | ${to} = | Format String | To: {} <{}>                    | ${user}      | ${email} |\n        | ${to} = | Format String | To: {name} <{email}>           | name=${name} | email=${email} |\n        | ${to} = | Format String | To: {user.name} <{user.email}> | user=${user} |\n        | ${xx} = | Format String | {:*^30}                        | centered     |\n        | ${yy} = | Format String | {0:{width}{base}}              | ${42}        | base=X | width=10 |\n        | ${zz} = | Format String | ${CURDIR}/template.txt         | positional   | named=value |\n\n        New in Robot Framework 3.1.\n        ");
            pyFrame.setline(219);
            PyObject pyObject = pyFrame.getglobal("os").__getattr__("path").__getattr__("isabs").__call__(threadState, pyFrame.getlocal(1));
            if (pyObject.__nonzero__()) {
                pyObject = pyFrame.getglobal("os").__getattr__("path").__getattr__("isfile").__call__(threadState, pyFrame.getlocal(1));
            }
            if (pyObject.__nonzero__()) {
                pyFrame.setline(220);
                object2 = pyFrame.getlocal(1).__getattr__("replace").__call__(threadState, (PyObject)PyString.fromInterned("/"), pyFrame.getglobal("os").__getattr__("sep"));
                pyFrame.setlocal(1, (PyObject)object2);
                object2 = null;
                pyFrame.setline(221);
                object2 = new PyObject[]{PyString.fromInterned("Reading template from file <a href=\"%s\">%s</a>.")._mod(new PyTuple(pyFrame.getlocal(1), pyFrame.getlocal(1))), pyFrame.getglobal("True")};
                object = new String[]{"html"};
                pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, (PyObject[])object2, (String[])object);
                object2 = null;
                object2 = ContextGuard.getManager(pyFrame.getglobal("FileReader").__call__(threadState, pyFrame.getlocal(1)));
                object = object2.__enter__(threadState);
                try {
                    pyFrame.setlocal(4, (PyObject)object);
                    pyFrame.setline(224);
                    object = pyFrame.getlocal(4).__getattr__("read").__call__(threadState);
                    pyFrame.setlocal(1, (PyObject)object);
                    object = null;
                    object2.__exit__(threadState, null);
                }
                catch (Throwable throwable) {
                    if (object2.__exit__(threadState, Py.setException(throwable, pyFrame))) break block4;
                    throw (Throwable)Py.makeException();
                }
            }
        }
        pyFrame.setline(225);
        object2 = Py.EmptyObjects;
        object = new String[]{};
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("format")._callextra((PyObject[])object2, (String[])object, pyFrame.getlocal(2), pyFrame.getlocal(3));
        object2 = null;
        object2 = pyObject;
        pyFrame.f_lasti = -1;
        return object2;
    }

    public PyObject get_line_count$11(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(228);
        PyString.fromInterned("Returns and logs the number of lines in the given string.");
        pyFrame.setline(229);
        PyObject pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(230);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d lines")._mod(pyFrame.getlocal(2)));
        pyFrame.setline(231);
        pyObject = pyFrame.getlocal(2);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_to_lines$12(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(253);
        PyString.fromInterned("Splits the given string to lines.\n\n        It is possible to get only a selection of lines from ``start``\n        to ``end`` so that ``start`` index is inclusive and ``end`` is\n        exclusive. Line numbering starts from 0, and it is possible to\n        use negative indices to refer to lines from the end.\n\n        Lines are returned without the newlines. The number of\n        returned lines is automatically logged.\n\n        Examples:\n        | @{lines} =        | Split To Lines | ${manylines} |    |    |\n        | @{ignore first} = | Split To Lines | ${manylines} | 1  |    |\n        | @{ignore last} =  | Split To Lines | ${manylines} |    | -1 |\n        | @{5th to 10th} =  | Split To Lines | ${manylines} | 4  | 10 |\n        | @{first two} =    | Split To Lines | ${manylines} |    | 1  |\n        | @{last two} =     | Split To Lines | ${manylines} | -2 |    |\n\n        Use `Get Line` if you only need to get a single line.\n        ");
        pyFrame.setline(254);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("start"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(255);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("end"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(256);
        pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState).__getslice__(pyFrame.getlocal(2), pyFrame.getlocal(3), null);
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(257);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d lines returned")._mod(pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(4))));
        pyFrame.setline(258);
        pyObject = pyFrame.getlocal(4);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_line$13(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(272);
        PyString.fromInterned("Returns the specified line from the given ``string``.\n\n        Line numbering starts from 0 and it is possible to use\n        negative indices to refer to lines from the end. The line is\n        returned without the newline character.\n\n        Examples:\n        | ${first} =    | Get Line | ${string} | 0  |\n        | ${2nd last} = | Get Line | ${string} | -2 |\n\n        Use `Split To Lines` if all lines are needed.\n        ");
        pyFrame.setline(273);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("line_number"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(274);
        pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState).__getitem__(pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_containing_string$14(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(2, 0);
        pyFrame.setline(299);
        PyString.fromInterned("Returns lines of the given ``string`` that contain the ``pattern``.\n\n        The ``pattern`` is always considered to be a normal string, not a glob\n        or regexp pattern. A line matches if the ``pattern`` is found anywhere\n        on it.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Containing String | ${result} | An example |\n        | ${ret} =   | Get Lines Containing String | ${ret} | FAIL | case-insensitive |\n\n        See `Get Lines Matching Pattern` and `Get Lines Matching Regexp`\n        if you need more complex pattern matching.\n        ");
        pyFrame.setline(300);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__nonzero__()) {
            pyFrame.setline(301);
            object = pyFrame.getderef(0).__getattr__("lower").__call__(threadState);
            pyFrame.setderef(0, (PyObject)object);
            object = null;
            pyFrame.setline(302);
            pyFrame.setline(302);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$15, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        } else {
            pyFrame.setline(304);
            pyFrame.setline(304);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$16, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        pyFrame.setline(305);
        object = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$15(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(302);
        PyObject pyObject = pyFrame.getderef(0);
        PyObject pyObject2 = pyObject._in(pyFrame.getlocal(0).__getattr__("lower").__call__(threadState));
        pyObject = null;
        pyObject = pyObject2;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject f$16(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(304);
        PyObject pyObject = pyFrame.getderef(0);
        PyObject pyObject2 = pyObject._in(pyFrame.getlocal(0));
        pyObject = null;
        pyObject = pyObject2;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_matching_pattern$17(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(2, 0);
        pyFrame.setline(335);
        PyString.fromInterned("Returns lines of the given ``string`` that match the ``pattern``.\n\n        The ``pattern`` is a _glob pattern_ where:\n        | ``*``        | matches everything |\n        | ``?``        | matches any single character |\n        | ``[chars]``  | matches any character inside square brackets (e.g. ``[abc]`` matches either ``a``, ``b`` or ``c``) |\n        | ``[!chars]`` | matches any character not inside square brackets |\n\n        A line matches only if it matches the ``pattern`` fully.\n\n        The match is case-sensitive by default, but giving ``case_insensitive``\n        a true value makes it case-insensitive. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        Lines are returned as one string catenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Pattern | ${result} | Wild???? example |\n        | ${ret} = | Get Lines Matching Pattern | ${ret} | FAIL: * | case_insensitive=true |\n\n        See `Get Lines Matching Regexp` if you need more complex\n        patterns and `Get Lines Containing String` if searching\n        literal strings is enough.\n        ");
        pyFrame.setline(336);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__nonzero__()) {
            pyFrame.setline(337);
            object = pyFrame.getderef(0).__getattr__("lower").__call__(threadState);
            pyFrame.setderef(0, (PyObject)object);
            object = null;
            pyFrame.setline(338);
            pyFrame.setline(338);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$18, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        } else {
            pyFrame.setline(340);
            pyFrame.setline(340);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            object = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$19, (PyObject[])object);
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        pyFrame.setline(341);
        object = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$18(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(338);
        PyObject pyObject = pyFrame.getglobal("fnmatchcase").__call__(threadState, pyFrame.getlocal(0).__getattr__("lower").__call__(threadState), pyFrame.getderef(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject f$19(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(340);
        PyObject pyObject = pyFrame.getglobal("fnmatchcase").__call__(threadState, pyFrame.getlocal(0), pyFrame.getderef(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject get_lines_matching_regexp$20(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(375);
        PyString.fromInterned("Returns lines of the given ``string`` that match the regexp ``pattern``.\n\n        See `BuiltIn.Should Match Regexp` for more information about\n        Python regular expression syntax in general and how to use it\n        in Robot Framework test data in particular.\n\n        By default lines match only if they match the pattern fully, but\n        partial matching can be enabled by giving the ``partial_match``\n        argument a true value. The value is considered true\n        if it is a non-empty string that is not equal to ``false``, ``none`` or\n        ``no``. If the value is not a string, its truth value is got directly\n        in Python.\n\n        If the pattern is empty, it matches only empty lines by default.\n        When partial matching is enabled, empty pattern matches all lines.\n\n        Notice that to make the match case-insensitive, you need to prefix\n        the pattern with case-insensitive flag ``(?i)``.\n\n        Lines are returned as one string concatenated back together with\n        newlines. Possible trailing newline is never returned. The\n        number of matching lines is automatically logged.\n\n        Examples:\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example |\n        | ${lines} = | Get Lines Matching Regexp | ${result} | Reg\\\\w{3} example | partial_match=true |\n        | ${ret} =   | Get Lines Matching Regexp | ${ret}    | (?i)FAIL: .* |\n\n        See `Get Lines Matching Pattern` and `Get Lines Containing\n        String` if you do not need full regular expression powers (and\n        complexity).\n        ");
        pyFrame.setline(376);
        if (pyFrame.getglobal("is_truthy").__call__(threadState, pyFrame.getlocal(3)).__not__().__nonzero__()) {
            pyFrame.setline(377);
            pyObject = PyString.fromInterned("^%s$")._mod(pyFrame.getlocal(2));
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(378);
        pyObject = pyFrame.getlocal(0).__getattr__("_get_matching_lines").__call__(threadState, pyFrame.getlocal(1), pyFrame.getglobal("re").__getattr__("compile").__call__(threadState, pyFrame.getlocal(2)).__getattr__("search"));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject _get_matching_lines$21(PyFrame pyFrame, ThreadState threadState) {
        PyList pyList;
        PyObject pyObject;
        block4: {
            PyObject pyObject2;
            block3: {
                pyFrame.setline(381);
                pyObject = pyFrame.getlocal(1).__getattr__("splitlines").__call__(threadState);
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(382);
                pyList = new PyList();
                pyObject = pyList.__getattr__("append");
                pyFrame.setlocal(5, pyObject);
                pyObject = null;
                pyFrame.setline(382);
                pyObject = pyFrame.getlocal(3).__iter__();
                if (!true) break block3;
                pyFrame.setline(382);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block4;
            }
            do {
                pyFrame.setlocal(6, pyObject2);
                pyFrame.setline(382);
                if (pyFrame.getlocal(2).__call__(threadState, pyFrame.getlocal(6)).__nonzero__()) {
                    pyFrame.setline(382);
                    pyFrame.getlocal(5).__call__(threadState, pyFrame.getlocal(6));
                }
                pyFrame.setline(382);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(382);
        pyFrame.dellocal(5);
        pyObject = pyList;
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(383);
        pyFrame.getglobal("logger").__getattr__("info").__call__(threadState, PyString.fromInterned("%d out of %d lines matched")._mod(new PyTuple(pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(4)), pyFrame.getglobal("len").__call__(threadState, pyFrame.getlocal(3)))));
        pyFrame.setline(384);
        pyObject = PyString.fromInterned("\n").__getattr__("join").__call__(threadState, pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject get_regexp_matches$22(PyFrame pyFrame, ThreadState threadState) {
        PyList pyList;
        PyObject pyObject;
        block7: {
            PyObject pyObject2;
            block6: {
                PyList pyList2;
                block5: {
                    block4: {
                        pyFrame.setline(412);
                        PyString.fromInterned("Returns a list of all non-overlapping matches in the given string.\n\n        ``string`` is the string to find matches from and ``pattern`` is the\n        regular expression. See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general and how\n        to use it in Robot Framework test data in particular.\n\n        If no groups are used, the returned list contains full matches. If one\n        group is used, the list contains only contents of that group. If\n        multiple groups are used, the list contains tuples that contain\n        individual group contents. All groups can be given as indexes (starting\n        from 1) and named groups also as names.\n\n        Examples:\n        | ${no match} =    | Get Regexp Matches | the string | xxx     |\n        | ${matches} =     | Get Regexp Matches | the string | t..     |\n        | ${one group} =   | Get Regexp Matches | the string | t(..)   | 1 |\n        | ${named group} = | Get Regexp Matches | the string | t(?P<name>..) | name |\n        | ${two groups} =  | Get Regexp Matches | the string | t(.)(.) | 1 | 2 |\n        =>\n        | ${no match} = []\n        | ${matches} = ['the', 'tri']\n        | ${one group} = ['he', 'ri']\n        | ${named group} = ['he', 'ri']\n        | ${two groups} = [('h', 'e'), ('r', 'i')]\n        ");
                        pyFrame.setline(413);
                        pyObject = pyFrame.getglobal("re").__getattr__("compile").__call__(threadState, pyFrame.getlocal(2));
                        pyFrame.setlocal(4, pyObject);
                        pyObject = null;
                        pyFrame.setline(414);
                        pyList2 = new PyList();
                        pyObject = pyList2.__getattr__("append");
                        pyFrame.setlocal(5, pyObject);
                        pyObject = null;
                        pyFrame.setline(414);
                        pyObject = pyFrame.getlocal(3).__iter__();
                        if (!true) break block4;
                        pyFrame.setline(414);
                        if ((pyObject2 = pyObject.__iternext__()) == null) break block5;
                    }
                    do {
                        pyFrame.setlocal(6, pyObject2);
                        pyFrame.setline(414);
                        pyFrame.getlocal(5).__call__(threadState, pyFrame.getlocal(0).__getattr__("_parse_group").__call__(threadState, pyFrame.getlocal(6)));
                        pyFrame.setline(414);
                    } while ((pyObject2 = pyObject.__iternext__()) != null);
                }
                pyFrame.setline(414);
                pyFrame.dellocal(5);
                pyObject = pyList2;
                pyFrame.setlocal(3, pyObject);
                pyObject = null;
                pyFrame.setline(415);
                pyList = new PyList();
                pyObject = pyList.__getattr__("append");
                pyFrame.setlocal(7, pyObject);
                pyObject = null;
                pyFrame.setline(415);
                pyObject = pyFrame.getlocal(4).__getattr__("finditer").__call__(threadState, pyFrame.getlocal(1)).__iter__();
                if (!true) break block6;
                pyFrame.setline(415);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block7;
            }
            do {
                pyFrame.setlocal(8, pyObject2);
                pyFrame.setline(415);
                PyObject[] pyObjectArray = Py.EmptyObjects;
                String[] stringArray = new String[]{};
                PyObject pyObject3 = pyFrame.getlocal(8).__getattr__("group")._callextra(pyObjectArray, stringArray, pyFrame.getlocal(3), null);
                pyObjectArray = null;
                pyFrame.getlocal(7).__call__(threadState, pyObject3);
                pyFrame.setline(415);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(415);
        pyFrame.dellocal(7);
        pyObject = pyList;
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _parse_group$23(PyFrame pyFrame, ThreadState threadState) {
        try {
            pyFrame.setline(419);
            PyObject pyObject = pyFrame.getglobal("int").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("ValueError"))) {
                pyFrame.setline(421);
                PyObject pyObject = pyFrame.getlocal(1);
                pyFrame.f_lasti = -1;
                return pyObject;
            }
            throw pyException;
        }
    }

    public PyObject replace_string$24(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(443);
        PyString.fromInterned("Replaces ``search_for`` in the given ``string`` with ``replace_with``.\n\n        ``search_for`` is used as a literal string. See `Replace String\n        Using Regexp` if more powerful pattern matching is needed.\n        If you need to just remove a string see `Remove String`.\n\n        If the optional argument ``count`` is given, only that many\n        occurrences from left are replaced. Negative ``count`` means\n        that all occurrences are replaced (default behaviour) and zero\n        means that nothing is done.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Replace String | Hello, world!  | world | tellus   |\n        | Should Be Equal | ${str}         | Hello, tellus! |       |          |\n        | ${str} =        | Replace String | Hello, world!  | l     | ${EMPTY} | count=1 |\n        | Should Be Equal | ${str}         | Helo, world!   |       |          |\n        ");
        pyFrame.setline(444);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(4), (PyObject)PyString.fromInterned("count"));
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(445);
        pyObject = pyFrame.getlocal(1).__getattr__("replace").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3), pyFrame.getlocal(4));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject replace_string_using_regexp$25(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(461);
        PyString.fromInterned("Replaces ``pattern`` in the given ``string`` with ``replace_with``.\n\n        This keyword is otherwise identical to `Replace String`, but\n        the ``pattern`` to search for is considered to be a regular\n        expression.  See `BuiltIn.Should Match Regexp` for more\n        information about Python regular expression syntax in general\n        and how to use it in Robot Framework test data in particular.\n\n        If you need to just remove a string see `Remove String Using Regexp`.\n\n        Examples:\n        | ${str} = | Replace String Using Regexp | ${str} | 20\\\\d\\\\d-\\\\d\\\\d-\\\\d\\\\d | <DATE> |\n        | ${str} = | Replace String Using Regexp | ${str} | (Hello|Hi) | ${EMPTY} | count=1 |\n        ");
        pyFrame.setline(462);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(4), (PyObject)PyString.fromInterned("count"));
        pyFrame.setlocal(4, pyObject);
        pyObject = null;
        pyFrame.setline(464);
        pyObject = pyFrame.getlocal(4);
        PyObject pyObject2 = pyObject._eq(Py.newInteger(0));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(465);
            pyObject = pyFrame.getlocal(1);
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(466);
        pyObject = pyFrame.getglobal("re").__getattr__("sub").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3), pyFrame.getlocal(1), pyFrame.getglobal("max").__call__(threadState, pyFrame.getlocal(4), (PyObject)Py.newInteger(0)));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject remove_string$26(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(487);
                PyString.fromInterned("Removes all ``removables`` from the given ``string``.\n\n        ``removables`` are used as literal strings. Each removable will be\n        matched to a temporary string from which preceding removables have\n        been already removed. See second example below.\n\n        Use `Remove String Using Regexp` if more powerful pattern matching is\n        needed. If only a certain number of matches should be removed,\n        `Replace String` or `Replace String Using Regexp` can be used.\n\n        A modified version of the string is returned and the original\n        string is not altered.\n\n        Examples:\n        | ${str} =        | Remove String | Robot Framework | work   |\n        | Should Be Equal | ${str}        | Robot Frame     |\n        | ${str} =        | Remove String | Robot Framework | o | bt |\n        | Should Be Equal | ${str}        | R Framewrk      |\n        ");
                pyFrame.setline(488);
                pyObject = pyFrame.getlocal(2).__iter__();
                if (!true) break block2;
                pyFrame.setline(488);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(3, pyObject2);
                pyFrame.setline(489);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("replace_string").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(3), (PyObject)PyString.fromInterned(""));
                pyFrame.setlocal(1, pyObject3);
                pyObject3 = null;
                pyFrame.setline(488);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(490);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject remove_string_using_regexp$27(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        block3: {
            PyObject pyObject2;
            block2: {
                pyFrame.setline(501);
                PyString.fromInterned("Removes ``patterns`` from the given ``string``.\n\n        This keyword is otherwise identical to `Remove String`, but\n        the ``patterns`` to search for are considered to be a regular\n        expression. See `Replace String Using Regexp` for more information\n        about the regular expression syntax. That keyword can also be\n        used if there is a need to remove only a certain number of\n        occurrences.\n        ");
                pyFrame.setline(502);
                pyObject = pyFrame.getlocal(2).__iter__();
                if (!true) break block2;
                pyFrame.setline(502);
                if ((pyObject2 = pyObject.__iternext__()) == null) break block3;
            }
            do {
                pyFrame.setlocal(3, pyObject2);
                pyFrame.setline(503);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("replace_string_using_regexp").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(3), (PyObject)PyString.fromInterned(""));
                pyFrame.setlocal(1, pyObject3);
                pyObject3 = null;
                pyFrame.setline(502);
            } while ((pyObject2 = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(504);
        pyObject = pyFrame.getlocal(1);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string$28(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(526);
        PyString.fromInterned("Splits the ``string`` using ``separator`` as a delimiter string.\n\n        If a ``separator`` is not given, any whitespace string is a\n        separator. In that case also possible consecutive whitespace\n        as well as leading and trailing whitespace is ignored.\n\n        Split words are returned as a list. If the optional\n        ``max_split`` is given, at most ``max_split`` splits are done, and\n        the returned list will have maximum ``max_split + 1`` elements.\n\n        Examples:\n        | @{words} =         | Split String | ${string} |\n        | @{words} =         | Split String | ${string} | ,${SPACE} |\n        | ${pre} | ${post} = | Split String | ${string} | ::    | 1 |\n\n        See `Split String From Right` if you want to start splitting\n        from right, and `Fetch From Left` and `Fetch From Right` if\n        you only want to get first/last part of the string.\n        ");
        pyFrame.setline(527);
        PyObject pyObject = pyFrame.getlocal(2);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(528);
            pyObject = pyFrame.getglobal("None");
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(529);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("max_split"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(530);
        pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string_from_right$29(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(542);
        PyString.fromInterned("Splits the ``string`` using ``separator`` starting from right.\n\n        Same as `Split String`, but splitting is started from right. This has\n        an effect only when ``max_split`` is given.\n\n        Examples:\n        | ${first} | ${rest} = | Split String            | ${string} | - | 1 |\n        | ${rest}  | ${last} = | Split String From Right | ${string} | - | 1 |\n        ");
        pyFrame.setline(543);
        PyObject pyObject = pyFrame.getlocal(2);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(544);
            pyObject = pyFrame.getglobal("None");
            pyFrame.setlocal(2, pyObject);
            pyObject = null;
        }
        pyFrame.setline(545);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("max_split"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(546);
        pyObject = pyFrame.getlocal(1).__getattr__("rsplit").__call__(threadState, pyFrame.getlocal(2), pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject split_string_to_characters$30(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(553);
        PyString.fromInterned("Splits the given ``string`` to characters.\n\n        Example:\n        | @{characters} = | Split String To Characters | ${string} |\n        ");
        pyFrame.setline(554);
        PyObject pyObject = pyFrame.getglobal("list").__call__(threadState, pyFrame.getlocal(1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject fetch_from_left$31(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(563);
        PyString.fromInterned("Returns contents of the ``string`` before the first occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Right`, `Split String` and `Split String\n        From Right`.\n        ");
        pyFrame.setline(564);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2)).__getitem__(Py.newInteger(0));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject fetch_from_right$32(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(573);
        PyString.fromInterned("Returns contents of the ``string`` after the last occurrence of ``marker``.\n\n        If the ``marker`` is not found, whole string is returned.\n\n        See also `Fetch From Left`, `Split String` and `Split String\n        From Right`.\n        ");
        pyFrame.setline(574);
        PyObject pyObject = pyFrame.getlocal(1).__getattr__("split").__call__(threadState, pyFrame.getlocal(2)).__getitem__(Py.newInteger(-1));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public PyObject generate_random_string$33(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        block4: {
            PyObject pyObject;
            block3: {
                pyFrame.to_cell(2, 1);
                pyFrame.setline(595);
                PyString.fromInterned("Generates a string with a desired ``length`` from the given ``chars``.\n\n        The population sequence ``chars`` contains the characters to use\n        when generating the random string. It can contain any\n        characters, and it is possible to use special markers\n        explained in the table below:\n\n        |  = Marker =   |               = Explanation =                   |\n        | ``[LOWER]``   | Lowercase ASCII characters from ``a`` to ``z``. |\n        | ``[UPPER]``   | Uppercase ASCII characters from ``A`` to ``Z``. |\n        | ``[LETTERS]`` | Lowercase and uppercase ASCII characters.       |\n        | ``[NUMBERS]`` | Numbers from 0 to 9.                            |\n\n        Examples:\n        | ${ret} = | Generate Random String |\n        | ${low} = | Generate Random String | 12 | [LOWER]         |\n        | ${bin} = | Generate Random String | 8  | 01              |\n        | ${hex} = | Generate Random String | 4  | [NUMBERS]abcdef |\n        ");
                pyFrame.setline(596);
                PyObject pyObject2 = pyFrame.getlocal(1);
                Object var3_4 = null;
                if (pyObject2._eq(PyString.fromInterned("")).__nonzero__()) {
                    pyFrame.setline(597);
                    PyInteger pyInteger = Py.newInteger(8);
                    pyFrame.setlocal(1, (PyObject)pyInteger);
                    Object var3_6 = null;
                }
                pyFrame.setline(598);
                PyObject pyObject3 = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(1), (PyObject)PyString.fromInterned("length"));
                pyFrame.setlocal(1, pyObject3);
                Object var3_9 = null;
                pyFrame.setline(599);
                pyObject = ((PyObject)new PyList(new PyObject[]{new PyTuple(PyString.fromInterned("[LOWER]"), pyFrame.getglobal("ascii_lowercase")), new PyTuple(PyString.fromInterned("[UPPER]"), pyFrame.getglobal("ascii_uppercase")), new PyTuple(PyString.fromInterned("[LETTERS]"), pyFrame.getglobal("ascii_lowercase")._add(pyFrame.getglobal("ascii_uppercase"))), new PyTuple(PyString.fromInterned("[NUMBERS]"), pyFrame.getglobal("digits"))})).__iter__();
                if (!true) break block3;
                pyFrame.setline(599);
                if ((object = pyObject.__iternext__()) == null) break block4;
            }
            do {
                PyObject[] pyObjectArray = Py.unpackSequence((PyObject)object, 2);
                PyObject pyObject4 = pyObjectArray[0];
                pyFrame.setlocal(3, pyObject4);
                pyObject4 = null;
                pyObject4 = pyObjectArray[1];
                pyFrame.setlocal(4, pyObject4);
                pyObject4 = null;
                pyFrame.setline(603);
                PyObject pyObject5 = pyFrame.getderef(1).__getattr__("replace").__call__(threadState, pyFrame.getlocal(3), pyFrame.getlocal(4));
                pyFrame.setderef(1, pyObject5);
                Object var5_16 = null;
                pyFrame.setline(599);
            } while ((object = pyObject.__iternext__()) != null);
        }
        pyFrame.setline(604);
        PyObject pyObject = pyFrame.getglobal("len").__call__(threadState, pyFrame.getderef(1))._sub(Py.newInteger(1));
        pyFrame.setderef(0, pyObject);
        Object var3_12 = null;
        pyFrame.setline(605);
        PyObject pyObject6 = PyString.fromInterned("").__getattr__("join");
        pyFrame.setline(605);
        Object[] objectArray = Py.EmptyObjects;
        object = new PyObject[]{pyFrame.getclosure(1), pyFrame.getclosure(0)};
        object = new PyFunction(pyFrame.f_globals, (PyObject[])objectArray, f$34, null, (PyObject[])object);
        PyObject pyObject7 = ((PyObject)object).__call__(threadState, pyFrame.getglobal("range").__call__(threadState, pyFrame.getlocal(1)).__iter__());
        Arrays.fill(objectArray, null);
        PyObject pyObject8 = pyObject6.__call__(threadState, pyObject7);
        pyFrame.f_lasti = -1;
        return pyObject8;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$34(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(605);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(605);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(605);
            pyFrame.setline(605);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getderef(0).__getitem__(pyFrame.getglobal("randint").__call__(threadState, (PyObject)Py.newInteger(0), pyFrame.getderef(1)));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject get_substring$35(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(620);
        PyString.fromInterned("Returns a substring from ``start`` index to ``end`` index.\n\n        The ``start`` index is inclusive and ``end`` is exclusive.\n        Indexing starts from 0, and it is possible to use\n        negative indices to refer to characters from the end.\n\n        Examples:\n        | ${ignore first} = | Get Substring | ${string} | 1  |    |\n        | ${ignore last} =  | Get Substring | ${string} |    | -1 |\n        | ${5th to 10th} =  | Get Substring | ${string} | 4  | 10 |\n        | ${first two} =    | Get Substring | ${string} |    | 1  |\n        | ${last two} =     | Get Substring | ${string} | -2 |    |\n        ");
        pyFrame.setline(621);
        PyObject pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("start"));
        pyFrame.setlocal(2, pyObject);
        pyObject = null;
        pyFrame.setline(622);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_index").__call__(threadState, pyFrame.getlocal(3), (PyObject)PyString.fromInterned("end"));
        pyFrame.setlocal(3, pyObject);
        pyObject = null;
        pyFrame.setline(623);
        pyObject = pyFrame.getlocal(1).__getslice__(pyFrame.getlocal(2), pyFrame.getlocal(3), null);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject strip_string$36(PyFrame pyFrame, ThreadState threadState) {
        Object object;
        pyFrame.to_cell(1, 0);
        pyFrame.setline(646);
        PyString.fromInterned("Remove leading and/or trailing whitespaces from the given string.\n\n        ``mode`` is either ``left`` to remove leading characters, ``right`` to\n        remove trailing characters, ``both`` (default) to remove the\n        characters from both sides of the string or ``none`` to return the\n        unmodified string.\n\n        If the optional ``characters`` is given, it must be a string and the\n        characters in the string will be stripped in the string. Please note,\n        that this is not a substring to be removed but a list of characters,\n        see the example below.\n\n        Examples:\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | |\n        | Should Be Equal | ${stripped} | Hello | |\n        | ${stripped}=  | Strip String | ${SPACE}Hello${SPACE} | mode=left |\n        | Should Be Equal | ${stripped} | Hello${SPACE} | |\n        | ${stripped}=  | Strip String | aabaHelloeee | characters=abe |\n        | Should Be Equal | ${stripped} | Hello | |\n        ");
        try {
            pyFrame.setline(648);
            PyObject[] pyObjectArray = new PyObject[8];
            pyObjectArray[0] = PyString.fromInterned("BOTH");
            pyObjectArray[1] = pyFrame.getderef(0).__getattr__("strip");
            pyObjectArray[2] = PyString.fromInterned("LEFT");
            pyObjectArray[3] = pyFrame.getderef(0).__getattr__("lstrip");
            pyObjectArray[4] = PyString.fromInterned("RIGHT");
            pyObjectArray[5] = pyFrame.getderef(0).__getattr__("rstrip");
            pyObjectArray[6] = PyString.fromInterned("NONE");
            pyFrame.setline(651);
            object = Py.EmptyObjects;
            object = new PyObject[]{pyFrame.getclosure(0)};
            pyObjectArray[7] = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$37, (PyObject[])object);
            object = new PyDictionary(pyObjectArray).__getitem__(pyFrame.getlocal(2).__getattr__("upper").__call__(threadState));
            pyFrame.setlocal(4, (PyObject)object);
            object = null;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("KeyError"))) {
                pyFrame.setline(653);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Invalid mode '%s'.")._mod(pyFrame.getlocal(2))));
            }
            throw pyException;
        }
        pyFrame.setline(654);
        object = pyFrame.getlocal(4).__call__(threadState, pyFrame.getlocal(3));
        pyFrame.f_lasti = -1;
        return object;
    }

    public PyObject f$37(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(651);
        PyObject pyObject = pyFrame.getderef(0);
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject should_be_string$38(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(673);
        PyString.fromInterned("Fails if the given ``item`` is not a string.\n\n        With Python 2, except with IronPython, this keyword passes regardless\n        is the ``item`` a Unicode string or a byte string. Use `Should Be\n        Unicode String` or `Should Be Byte String` if you want to restrict\n        the string type. Notice that with Python 2, except with IronPython,\n        ``'string'`` creates a byte string and ``u'unicode'`` must be used to\n        create a Unicode string.\n\n        With Python 3 and IronPython, this keyword passes if the string is\n        a Unicode string but fails if it is bytes. Notice that with both\n        Python 3 and IronPython, ``'string'`` creates a Unicode string, and\n        ``b'bytes'`` must be used to create a byte string.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(674);
        if (pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(675);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_not_be_string$39(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(685);
        PyString.fromInterned("Fails if the given ``item`` is a string.\n\n        See `Should Be String` for more details about Unicode strings and byte\n        strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(686);
        if (pyFrame.getglobal("is_string").__call__(threadState, pyFrame.getlocal(1)).__nonzero__()) {
            pyFrame.setline(687);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is a string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_unicode_string$40(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(699);
        PyString.fromInterned("Fails if the given ``item`` is not a Unicode string.\n\n        Use `Should Be Byte String` if you want to verify the ``item`` is a\n        byte string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode\n        strings and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(700);
        if (pyFrame.getglobal("is_unicode").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(701);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a Unicode string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_byte_string$41(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(713);
        PyString.fromInterned("Fails if the given ``item`` is not a byte string.\n\n        Use `Should Be Unicode String` if you want to verify the ``item`` is a\n        Unicode string, or `Should Be String` if both Unicode and byte strings\n        are fine. See `Should Be String` for more details about Unicode strings\n        and byte strings.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n        ");
        pyFrame.setline(714);
        if (pyFrame.getglobal("is_bytes").__call__(threadState, pyFrame.getlocal(1)).__not__().__nonzero__()) {
            pyFrame.setline(715);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not a byte string."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_lower_case$42(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(727);
        PyString.fromInterned("Fails if the given ``string`` is not in lower case.\n\n        For example, ``'string'`` and ``'with specials!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Upper Case` and `Should Be Title Case`.\n        ");
        pyFrame.setline(728);
        if (pyFrame.getlocal(1).__getattr__("islower").__call__(threadState).__not__().__nonzero__()) {
            pyFrame.setline(729);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not lower case."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_upper_case$43(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(741);
        PyString.fromInterned("Fails if the given ``string`` is not in upper case.\n\n        For example, ``'STRING'`` and ``'WITH SPECIALS!'`` would pass, and\n        ``'String'``, ``''`` and ``' '`` would fail.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        See also `Should Be Title Case` and `Should Be Lower Case`.\n        ");
        pyFrame.setline(742);
        if (pyFrame.getlocal(1).__getattr__("isupper").__call__(threadState).__not__().__nonzero__()) {
            pyFrame.setline(743);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not upper case."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject should_be_title_case$44(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        pyFrame.setline(774);
        PyString.fromInterned("Fails if given ``string`` is not title.\n\n        ``string`` is a title cased string if there is at least one upper case\n        letter in each word.\n\n        For example, ``'This Is Title'`` and ``'OK, Give Me My iPhone'``\n        would pass. ``'all words lower'`` and ``'Word In lower'`` would fail.\n\n        This logic changed in Robot Framework 4.0 to be compatible with\n        `Convert to Title Case`. See `Convert to Title Case` for title case\n        algorithm and reasoning.\n\n        The default error message can be overridden with the optional\n        ``msg`` argument.\n\n        Words can be explicitly excluded with the optional ``exclude`` argument.\n\n        Explicitly excluded words can be given as a list or as a string with\n        words separated by a comma and an optional space. Excluded words are\n        actually considered to be regular expression patterns, so it is\n        possible to use something like \"example[.!?]?\" to match the word\n        \"example\" on it own and also if followed by \".\", \"!\" or \"?\".\n        See `BuiltIn.Should Match Regexp` for more information about Python\n        regular expression syntax in general and how to use it in Robot\n        Framework test data in particular.\n\n        See also `Should Be Upper Case` and `Should Be Lower Case`.\n        ");
        pyFrame.setline(775);
        PyObject pyObject2 = pyFrame.getglobal("PY2");
        if (pyObject2.__nonzero__()) {
            pyObject2 = pyFrame.getglobal("is_bytes").__call__(threadState, pyFrame.getlocal(1));
        }
        if (pyObject2.__nonzero__()) {
            try {
                pyFrame.setline(777);
                pyObject = pyFrame.getlocal(1).__getattr__("decode").__call__(threadState, (PyObject)PyString.fromInterned("ASCII"));
                pyFrame.setlocal(1, pyObject);
                pyObject = null;
            }
            catch (Throwable throwable) {
                PyException pyException = Py.setException(throwable, pyFrame);
                if (pyException.match(pyFrame.getglobal("UnicodeError"))) {
                    pyFrame.setline(779);
                    throw Py.makeException(pyFrame.getglobal("TypeError").__call__(threadState, (PyObject)PyString.fromInterned("This keyword works only with Unicode strings and non-ASCII bytes.")));
                }
                throw pyException;
            }
        }
        pyFrame.setline(781);
        pyObject = pyFrame.getlocal(1);
        PyObject pyObject3 = pyObject._ne(pyFrame.getlocal(0).__getattr__("convert_to_title_case").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(3)));
        pyObject = null;
        if (pyObject3.__nonzero__()) {
            pyFrame.setline(782);
            pyFrame.getlocal(0).__getattr__("_fail").__call__(threadState, pyFrame.getlocal(2), (PyObject)PyString.fromInterned("'%s' is not title case."), pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public PyObject _convert_to_index$45(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(785);
        PyObject pyObject = pyFrame.getlocal(1);
        PyObject pyObject2 = pyObject._eq(PyString.fromInterned(""));
        pyObject = null;
        if (pyObject2.__nonzero__()) {
            pyFrame.setline(786);
            pyObject = Py.newInteger(0);
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(787);
        PyObject pyObject3 = pyFrame.getlocal(1);
        PyObject pyObject4 = pyObject3._is(pyFrame.getglobal("None"));
        pyObject3 = null;
        if (pyObject4.__nonzero__()) {
            pyFrame.setline(788);
            pyObject = pyFrame.getglobal("None");
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        pyFrame.setline(789);
        pyObject = pyFrame.getlocal(0).__getattr__("_convert_to_integer").__call__(threadState, pyFrame.getlocal(1), pyFrame.getlocal(2));
        pyFrame.f_lasti = -1;
        return pyObject;
    }

    public PyObject _convert_to_integer$46(PyFrame pyFrame, ThreadState threadState) {
        try {
            pyFrame.setline(793);
            PyObject pyObject = pyFrame.getglobal("int").__call__(threadState, pyFrame.getlocal(1));
            pyFrame.f_lasti = -1;
            return pyObject;
        }
        catch (Throwable throwable) {
            PyException pyException = Py.setException(throwable, pyFrame);
            if (pyException.match(pyFrame.getglobal("ValueError"))) {
                pyFrame.setline(795);
                throw Py.makeException(pyFrame.getglobal("ValueError").__call__(threadState, PyString.fromInterned("Cannot convert '%s' argument '%s' to an integer.")._mod(new PyTuple(pyFrame.getlocal(2), pyFrame.getlocal(1)))));
            }
            throw pyException;
        }
    }

    public PyObject _fail$47(PyFrame pyFrame, ThreadState threadState) {
        pyFrame.setline(799);
        if (pyFrame.getlocal(1).__not__().__nonzero__()) {
            pyFrame.setline(800);
            PyObject pyObject = pyFrame.getlocal(2);
            PyObject pyObject2 = pyFrame.getglobal("tuple");
            pyFrame.setline(800);
            Object object = Py.EmptyObjects;
            PyFunction pyFunction = new PyFunction(pyFrame.f_globals, (PyObject[])object, f$48, null);
            PyObject pyObject3 = ((PyObject)pyFunction).__call__(threadState, pyFrame.getlocal(3).__iter__());
            Arrays.fill(object, null);
            object = pyObject._mod(pyObject2.__call__(threadState, pyObject3));
            pyFrame.setlocal(1, (PyObject)object);
            object = null;
        }
        pyFrame.setline(801);
        throw Py.makeException(pyFrame.getglobal("AssertionError").__call__(threadState, pyFrame.getlocal(1)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public PyObject f$48(PyFrame pyFrame, ThreadState threadState) {
        PyObject pyObject;
        Object[] objectArray;
        PyObject pyObject2;
        switch (pyFrame.f_lasti) {
            default: {
                pyFrame.setline(800);
                pyObject2 = pyFrame.getlocal(0).__iter__();
                break;
            }
            case 1: {
                objectArray = pyFrame.f_savedlocals;
                pyObject2 = (PyObject)objectArray[3];
                pyObject = (PyObject)objectArray[4];
                Object object = pyFrame.getGeneratorInput();
                if (object instanceof PyException) {
                    throw (Throwable)object;
                }
                PyObject cfr_ignored_0 = (PyObject)object;
            }
        }
        pyFrame.setline(800);
        pyObject = pyObject2.__iternext__();
        if (pyObject != null) {
            pyFrame.setlocal(1, pyObject);
            pyFrame.setline(800);
            pyFrame.setline(800);
            pyFrame.f_lasti = 1;
            objectArray = new Object[5];
            objectArray[3] = pyObject2;
            objectArray[4] = pyObject;
            pyFrame.f_savedlocals = objectArray;
            return pyFrame.getglobal("unic").__call__(threadState, pyFrame.getlocal(1));
        }
        pyFrame.f_lasti = -1;
        return Py.None;
    }

    public String$py(String string2) {
        self = this;
        String[] stringArray = new String[]{};
        f$0 = Py.newCode(0, stringArray, string2, "<module>", 0, false, false, (PyFunctionTable)self, 0, null, null, 0, 4096);
        stringArray = new String[]{};
        String$1 = Py.newCode(0, stringArray, string2, "String", 32, false, false, (PyFunctionTable)self, 1, null, null, 0, 4096);
        stringArray = new String[]{"self", "string"};
        convert_to_lower_case$2 = Py.newCode(2, stringArray, string2, "convert_to_lower_case", 56, false, false, (PyFunctionTable)self, 2, null, null, 0, 4097);
        stringArray = new String[]{"self", "string"};
        convert_to_upper_case$3 = Py.newCode(2, stringArray, string2, "convert_to_upper_case", 73, false, false, (PyFunctionTable)self, 3, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "exclude", "_[132_23]", "e", "_[135_19]", "tokens", "_(146_23)", "title"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{"exclude", "title"};
        convert_to_title_case$4 = Py.newCode(3, stringArray2, string2, "convert_to_title_case", 88, false, false, (PyFunctionTable)self, 4, stringArray, null, 1, 4097);
        stringArray = new String[]{"word", "_(138_19)", "index", "char"};
        String[] stringArray3 = stringArray;
        stringArray = new String[]{"word"};
        String[] stringArray4 = stringArray;
        stringArray = new String[]{"exclude"};
        title$5 = Py.newCode(1, stringArray3, string2, "title", 137, false, false, (PyFunctionTable)self, 5, stringArray4, stringArray, 0, 4097);
        stringArray = new String[]{"_(x)", "e"};
        String[] stringArray5 = stringArray;
        stringArray = new String[]{"word"};
        f$6 = Py.newCode(1, stringArray5, string2, "<genexpr>", 138, false, false, (PyFunctionTable)self, 6, null, stringArray, 0, 4129);
        stringArray = new String[]{"_(x)", "token"};
        String[] stringArray6 = stringArray;
        stringArray = new String[]{"title"};
        f$7 = Py.newCode(1, stringArray6, string2, "<genexpr>", 146, false, false, (PyFunctionTable)self, 7, null, stringArray, 0, 4129);
        stringArray = new String[]{"self", "string", "encoding", "errors"};
        encode_string_to_bytes$8 = Py.newCode(4, stringArray, string2, "encode_string_to_bytes", 148, false, false, (PyFunctionTable)self, 8, null, null, 0, 4097);
        stringArray = new String[]{"self", "bytes", "encoding", "errors"};
        decode_bytes_to_string$9 = Py.newCode(4, stringArray, string2, "decode_bytes_to_string", 171, false, false, (PyFunctionTable)self, 9, null, null, 0, 4097);
        stringArray = new String[]{"self", "template", "positional", "named", "reader"};
        format_string$10 = Py.newCode(4, stringArray, string2, "format_string", 195, true, true, (PyFunctionTable)self, 10, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "count"};
        get_line_count$11 = Py.newCode(2, stringArray, string2, "get_line_count", 227, false, false, (PyFunctionTable)self, 11, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "start", "end", "lines"};
        split_to_lines$12 = Py.newCode(4, stringArray, string2, "split_to_lines", 233, false, false, (PyFunctionTable)self, 12, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "line_number"};
        get_line$13 = Py.newCode(3, stringArray, string2, "get_line", 260, false, false, (PyFunctionTable)self, 13, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "case_insensitive", "contains"};
        String[] stringArray7 = stringArray;
        stringArray = new String[]{"pattern"};
        get_lines_containing_string$14 = Py.newCode(4, stringArray7, string2, "get_lines_containing_string", 276, false, false, (PyFunctionTable)self, 14, stringArray, null, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray8 = stringArray;
        stringArray = new String[]{"pattern"};
        f$15 = Py.newCode(1, stringArray8, string2, "<lambda>", 302, false, false, (PyFunctionTable)self, 15, null, stringArray, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray9 = stringArray;
        stringArray = new String[]{"pattern"};
        f$16 = Py.newCode(1, stringArray9, string2, "<lambda>", 304, false, false, (PyFunctionTable)self, 16, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "case_insensitive", "matches"};
        String[] stringArray10 = stringArray;
        stringArray = new String[]{"pattern"};
        get_lines_matching_pattern$17 = Py.newCode(4, stringArray10, string2, "get_lines_matching_pattern", 307, false, false, (PyFunctionTable)self, 17, stringArray, null, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray11 = stringArray;
        stringArray = new String[]{"pattern"};
        f$18 = Py.newCode(1, stringArray11, string2, "<lambda>", 338, false, false, (PyFunctionTable)self, 18, null, stringArray, 0, 4097);
        stringArray = new String[]{"line"};
        String[] stringArray12 = stringArray;
        stringArray = new String[]{"pattern"};
        f$19 = Py.newCode(1, stringArray12, string2, "<lambda>", 340, false, false, (PyFunctionTable)self, 19, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "partial_match"};
        get_lines_matching_regexp$20 = Py.newCode(4, stringArray, string2, "get_lines_matching_regexp", 343, false, false, (PyFunctionTable)self, 20, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "matches", "lines", "matching", "_[382_20]", "line"};
        _get_matching_lines$21 = Py.newCode(3, stringArray, string2, "_get_matching_lines", 380, false, false, (PyFunctionTable)self, 21, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "groups", "regexp", "_[414_18]", "g", "_[415_16]", "m"};
        get_regexp_matches$22 = Py.newCode(4, stringArray, string2, "get_regexp_matches", 386, true, false, (PyFunctionTable)self, 22, null, null, 0, 4097);
        stringArray = new String[]{"self", "group"};
        _parse_group$23 = Py.newCode(2, stringArray, string2, "_parse_group", 417, false, false, (PyFunctionTable)self, 23, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "search_for", "replace_with", "count"};
        replace_string$24 = Py.newCode(5, stringArray, string2, "replace_string", 423, false, false, (PyFunctionTable)self, 24, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "pattern", "replace_with", "count"};
        replace_string_using_regexp$25 = Py.newCode(5, stringArray, string2, "replace_string_using_regexp", 447, false, false, (PyFunctionTable)self, 25, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "removables", "removable"};
        remove_string$26 = Py.newCode(3, stringArray, string2, "remove_string", 468, true, false, (PyFunctionTable)self, 26, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "patterns", "pattern"};
        remove_string_using_regexp$27 = Py.newCode(3, stringArray, string2, "remove_string_using_regexp", 492, true, false, (PyFunctionTable)self, 27, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "separator", "max_split"};
        split_string$28 = Py.newCode(4, stringArray, string2, "split_string", 506, false, false, (PyFunctionTable)self, 28, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "separator", "max_split"};
        split_string_from_right$29 = Py.newCode(4, stringArray, string2, "split_string_from_right", 532, false, false, (PyFunctionTable)self, 29, null, null, 0, 4097);
        stringArray = new String[]{"self", "string"};
        split_string_to_characters$30 = Py.newCode(2, stringArray, string2, "split_string_to_characters", 548, false, false, (PyFunctionTable)self, 30, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "marker"};
        fetch_from_left$31 = Py.newCode(3, stringArray, string2, "fetch_from_left", 556, false, false, (PyFunctionTable)self, 31, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "marker"};
        fetch_from_right$32 = Py.newCode(3, stringArray, string2, "fetch_from_right", 566, false, false, (PyFunctionTable)self, 32, null, null, 0, 4097);
        stringArray = new String[]{"self", "length", "chars", "name", "value", "_(605_23)", "maxi"};
        String[] stringArray13 = stringArray;
        stringArray = new String[]{"maxi", "chars"};
        generate_random_string$33 = Py.newCode(3, stringArray13, string2, "generate_random_string", 576, false, false, (PyFunctionTable)self, 33, stringArray, null, 1, 4097);
        stringArray = new String[]{"_(x)", "_"};
        String[] stringArray14 = stringArray;
        stringArray = new String[]{"chars", "maxi"};
        f$34 = Py.newCode(1, stringArray14, string2, "<genexpr>", 605, false, false, (PyFunctionTable)self, 34, null, stringArray, 0, 4129);
        stringArray = new String[]{"self", "string", "start", "end"};
        get_substring$35 = Py.newCode(4, stringArray, string2, "get_substring", 607, false, false, (PyFunctionTable)self, 35, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "mode", "characters", "method"};
        String[] stringArray15 = stringArray;
        stringArray = new String[]{"string"};
        strip_string$36 = Py.newCode(4, stringArray15, string2, "strip_string", 625, false, false, (PyFunctionTable)self, 36, stringArray, null, 0, 4097);
        stringArray = new String[]{"characters"};
        String[] stringArray16 = stringArray;
        stringArray = new String[]{"string"};
        f$37 = Py.newCode(1, stringArray16, string2, "<lambda>", 651, false, false, (PyFunctionTable)self, 37, null, stringArray, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_string$38 = Py.newCode(3, stringArray, string2, "should_be_string", 656, false, false, (PyFunctionTable)self, 38, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_not_be_string$39 = Py.newCode(3, stringArray, string2, "should_not_be_string", 677, false, false, (PyFunctionTable)self, 39, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_unicode_string$40 = Py.newCode(3, stringArray, string2, "should_be_unicode_string", 689, false, false, (PyFunctionTable)self, 40, null, null, 0, 4097);
        stringArray = new String[]{"self", "item", "msg"};
        should_be_byte_string$41 = Py.newCode(3, stringArray, string2, "should_be_byte_string", 703, false, false, (PyFunctionTable)self, 41, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg"};
        should_be_lower_case$42 = Py.newCode(3, stringArray, string2, "should_be_lower_case", 717, false, false, (PyFunctionTable)self, 42, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg"};
        should_be_upper_case$43 = Py.newCode(3, stringArray, string2, "should_be_upper_case", 731, false, false, (PyFunctionTable)self, 43, null, null, 0, 4097);
        stringArray = new String[]{"self", "string", "msg", "exclude"};
        should_be_title_case$44 = Py.newCode(4, stringArray, string2, "should_be_title_case", 745, false, false, (PyFunctionTable)self, 44, null, null, 0, 4097);
        stringArray = new String[]{"self", "value", "name"};
        _convert_to_index$45 = Py.newCode(3, stringArray, string2, "_convert_to_index", 784, false, false, (PyFunctionTable)self, 45, null, null, 0, 4097);
        stringArray = new String[]{"self", "value", "name"};
        _convert_to_integer$46 = Py.newCode(3, stringArray, string2, "_convert_to_integer", 791, false, false, (PyFunctionTable)self, 46, null, null, 0, 4097);
        stringArray = new String[]{"self", "message", "default_template", "items", "_(800_47)"};
        _fail$47 = Py.newCode(4, stringArray, string2, "_fail", 798, true, false, (PyFunctionTable)self, 47, null, null, 0, 4097);
        stringArray = new String[]{"_(x)", "item"};
        f$48 = Py.newCode(1, stringArray, string2, "<genexpr>", 800, false, false, (PyFunctionTable)self, 48, null, null, 0, 4129);
    }

    @Override
    public PyCode getMain() {
        return f$0;
    }

    public static void main(String[] stringArray) {
        Py.runMain(CodeLoader.createSimpleBootstrap(new String$py("robot/libraries/String$py").getMain()), stringArray);
    }

    public static CodeBootstrap getCodeBootstrap() {
        return PyRunnableBootstrap.getFilenameConstructorReflectionBootstrap(String$py.class);
    }

    @Override
    public PyObject call_function(int n, PyFrame pyFrame, ThreadState threadState) {
        String$py string$py = this;
        PyFrame pyFrame2 = pyFrame;
        ThreadState threadState2 = threadState;
        switch (n) {
            case 0: {
                return string$py.f$0(pyFrame2, threadState2);
            }
            case 1: {
                return string$py.String$1(pyFrame2, threadState2);
            }
            case 2: {
                return string$py.convert_to_lower_case$2(pyFrame2, threadState2);
            }
            case 3: {
                return string$py.convert_to_upper_case$3(pyFrame2, threadState2);
            }
            case 4: {
                return string$py.convert_to_title_case$4(pyFrame2, threadState2);
            }
            case 5: {
                return string$py.title$5(pyFrame2, threadState2);
            }
            case 6: {
                return string$py.f$6(pyFrame2, threadState2);
            }
            case 7: {
                return string$py.f$7(pyFrame2, threadState2);
            }
            case 8: {
                return string$py.encode_string_to_bytes$8(pyFrame2, threadState2);
            }
            case 9: {
                return string$py.decode_bytes_to_string$9(pyFrame2, threadState2);
            }
            case 10: {
                return string$py.format_string$10(pyFrame2, threadState2);
            }
            case 11: {
                return string$py.get_line_count$11(pyFrame2, threadState2);
            }
            case 12: {
                return string$py.split_to_lines$12(pyFrame2, threadState2);
            }
            case 13: {
                return string$py.get_line$13(pyFrame2, threadState2);
            }
            case 14: {
                return string$py.get_lines_containing_string$14(pyFrame2, threadState2);
            }
            case 15: {
                return string$py.f$15(pyFrame2, threadState2);
            }
            case 16: {
                return string$py.f$16(pyFrame2, threadState2);
            }
            case 17: {
                return string$py.get_lines_matching_pattern$17(pyFrame2, threadState2);
            }
            case 18: {
                return string$py.f$18(pyFrame2, threadState2);
            }
            case 19: {
                return string$py.f$19(pyFrame2, threadState2);
            }
            case 20: {
                return string$py.get_lines_matching_regexp$20(pyFrame2, threadState2);
            }
            case 21: {
                return string$py._get_matching_lines$21(pyFrame2, threadState2);
            }
            case 22: {
                return string$py.get_regexp_matches$22(pyFrame2, threadState2);
            }
            case 23: {
                return string$py._parse_group$23(pyFrame2, threadState2);
            }
            case 24: {
                return string$py.replace_string$24(pyFrame2, threadState2);
            }
            case 25: {
                return string$py.replace_string_using_regexp$25(pyFrame2, threadState2);
            }
            case 26: {
                return string$py.remove_string$26(pyFrame2, threadState2);
            }
            case 27: {
                return string$py.remove_string_using_regexp$27(pyFrame2, threadState2);
            }
            case 28: {
                return string$py.split_string$28(pyFrame2, threadState2);
            }
            case 29: {
                return string$py.split_string_from_right$29(pyFrame2, threadState2);
            }
            case 30: {
                return string$py.split_string_to_characters$30(pyFrame2, threadState2);
            }
            case 31: {
                return string$py.fetch_from_left$31(pyFrame2, threadState2);
            }
            case 32: {
                return string$py.fetch_from_right$32(pyFrame2, threadState2);
            }
            case 33: {
                return string$py.generate_random_string$33(pyFrame2, threadState2);
            }
            case 34: {
                return string$py.f$34(pyFrame2, threadState2);
            }
            case 35: {
                return string$py.get_substring$35(pyFrame2, threadState2);
            }
            case 36: {
                return string$py.strip_string$36(pyFrame2, threadState2);
            }
            case 37: {
                return string$py.f$37(pyFrame2, threadState2);
            }
            case 38: {
                return string$py.should_be_string$38(pyFrame2, threadState2);
            }
            case 39: {
                return string$py.should_not_be_string$39(pyFrame2, threadState2);
            }
            case 40: {
                return string$py.should_be_unicode_string$40(pyFrame2, threadState2);
            }
            case 41: {
                return string$py.should_be_byte_string$41(pyFrame2, threadState2);
            }
            case 42: {
                return string$py.should_be_lower_case$42(pyFrame2, threadState2);
            }
            case 43: {
                return string$py.should_be_upper_case$43(pyFrame2, threadState2);
            }
            case 44: {
                return string$py.should_be_title_case$44(pyFrame2, threadState2);
            }
            case 45: {
                return string$py._convert_to_index$45(pyFrame2, threadState2);
            }
            case 46: {
                return string$py._convert_to_integer$46(pyFrame2, threadState2);
            }
            case 47: {
                return string$py._fail$47(pyFrame2, threadState2);
            }
            case 48: {
                return string$py.f$48(pyFrame2, threadState2);
            }
        }
        return null;
    }
}

