/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.connect;

import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.util.PyArgParser;
import com.ziclix.python.sql.zxJDBC;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.Untraversable;

@Untraversable
public class Lookup
extends PyObject {
    private static final PyString _doc = new PyString("establish a connection through a JNDI lookup");

    @Override
    public PyObject __findattr_ex__(String name) {
        if ("__doc__".equals(name)) {
            return _doc;
        }
        return super.__findattr_ex__(name);
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        Object ref = null;
        Connection connection = null;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        PyArgParser parser2 = new PyArgParser(args, keywords);
        Object jndiName = parser2.arg(0).__tojava__(String.class);
        if (jndiName == null || jndiName == Py.NoConversion) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, "lookup name is null");
        }
        String[] kws = parser2.kws();
        for (int i = 0; i < kws.length; ++i) {
            String keyword2 = kws[i];
            String fieldname = null;
            Object value = parser2.kw(keyword2).__tojava__(Object.class);
            try {
                Field field = Context.class.getField(keyword2);
                fieldname = (String)field.get(Context.class);
            }
            catch (IllegalAccessException e) {
                throw zxJDBC.makeException(zxJDBC.ProgrammingError, e);
            }
            catch (NoSuchFieldException e) {
                fieldname = keyword2;
            }
            env.put(fieldname, value);
        }
        InitialContext context2 = null;
        try {
            context2 = new InitialContext(env);
            ref = context2.lookup((String)jndiName);
        }
        catch (NamingException e) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
        }
        finally {
            if (context2 != null) {
                try {
                    context2.close();
                }
                catch (NamingException namingException) {}
            }
        }
        if (ref == null) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "object [" + jndiName + "] not found in JNDI");
        }
        try {
            if (ref instanceof String) {
                connection = DriverManager.getConnection((String)ref);
            } else if (ref instanceof Connection) {
                connection = (Connection)ref;
            } else if (ref instanceof DataSource) {
                connection = ((DataSource)ref).getConnection();
            } else if (ref instanceof ConnectionPoolDataSource) {
                connection = ((ConnectionPoolDataSource)ref).getPooledConnection().getConnection();
            }
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
        }
        try {
            if (connection == null || connection.isClosed()) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, "unable to establish connection");
            }
            return new PyConnection(connection);
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
        }
    }

    @Override
    public String toString() {
        return String.format("<lookup object at %s>", Py.idstr(this));
    }
}

