/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IANAProtocolsDB
implements ProtocolsDB {
    private final Map<String, Protocol> nameToProto;
    private final Map<Integer, Protocol> numberToProto;

    public static final IANAProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private IANAProtocolsDB(Map<String, Protocol> nameToProto, Map<Integer, Protocol> numberToProto) {
        this.nameToProto = nameToProto;
        this.numberToProto = numberToProto;
    }

    @Override
    public Protocol getProtocolByName(String name) {
        return this.nameToProto.get(name);
    }

    @Override
    public Protocol getProtocolByNumber(Integer number) {
        return this.numberToProto.get(number);
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        return Collections.unmodifiableCollection(this.nameToProto.values());
    }

    private static final ProtocolDBBuilder initProtocolDB() {
        ProtocolDBBuilder builder2 = new ProtocolDBBuilder();
        builder2.add("ip", 0, "IP");
        builder2.add("icmp", 1, "ICMP");
        builder2.add("igmp", 2, "IGMP");
        builder2.add("ggp", 3, "GGP");
        builder2.add("ipencap", 4, "IP-ENCAP");
        builder2.add("st2", 5, "ST2");
        builder2.add("tcp", 6, "TCP");
        builder2.add("cbt", 7, "CBT");
        builder2.add("egp", 8, "EGP");
        builder2.add("igp", 9, "IGP");
        builder2.add("bbn-rcc", 10, "BBN-RCC-MON");
        builder2.add("nvp", 11, "NVP-II");
        builder2.add("pup", 12, "PUP");
        builder2.add("argus", 13, "ARGUS");
        builder2.add("emcon", 14, "EMCON");
        builder2.add("xnet", 15, "XNET");
        builder2.add("chaos", 16, "CHAOS");
        builder2.add("udp", 17, "UDP");
        builder2.add("mux", 18, "MUX");
        builder2.add("dcn", 19, "DCN-MEAS");
        builder2.add("hmp", 20, "HMP");
        builder2.add("prm", 21, "PRM");
        builder2.add("xns-idp", 22, "XNS-IDP");
        builder2.add("trunk-1", 23, "TRUNK-1");
        builder2.add("trunk-2", 24, "TRUNK-2");
        builder2.add("leaf-1", 25, "LEAF-1");
        builder2.add("leaf-2", 26, "LEAF-2");
        builder2.add("rdp", 27, "RDP");
        builder2.add("irtp", 28, "IRTP");
        builder2.add("iso-tp4", 29, "ISO-TP4");
        builder2.add("netblt", 30, "NETBLT");
        builder2.add("mfe-nsp", 31, "MFE-NSP");
        builder2.add("merit-inp", 32, "MERIT-INP");
        builder2.add("sep", 33, "SEP");
        builder2.add("3pc", 34, "3PC");
        builder2.add("idpr", 35, "IDPR");
        builder2.add("xtp", 36, "XTP");
        builder2.add("ddp", 37, "DDP");
        builder2.add("idpr-cmtp", 38, "IDPR-CMTP");
        builder2.add("tp++", 39, "TP++");
        builder2.add("il", 40, "IL");
        builder2.add("ipv6", 41, "IPV6");
        builder2.add("sdrp", 42, "SDRP");
        builder2.add("ipv6-route", 43, "IPV6-ROUTE");
        builder2.add("ipv6-frag", 44, "IPV6-FRAG");
        builder2.add("idrp", 45, "IDRP");
        builder2.add("rsvp", 46, "RSVP");
        builder2.add("gre", 47, "GRE");
        builder2.add("mhrp", 48, "MHRP");
        builder2.add("bna", 49, "BNA");
        builder2.add("esp", 50, "ESP");
        builder2.add("ah", 51, "AH");
        builder2.add("i-nlsp", 52, "I-NLSP");
        builder2.add("swipe", 53, "SWIPE");
        builder2.add("narp", 54, "NARP");
        builder2.add("mobile", 55, "MOBILE");
        builder2.add("tlsp", 56, "TLSP");
        builder2.add("skip", 57, "SKIP");
        builder2.add("ipv6-icmp", 58, "IPV6-ICMP");
        builder2.add("ipv6-nonxt", 59, "IPV6-NONXT");
        builder2.add("ipv6-opts", 60, "IPV6-OPTS");
        builder2.add("cftp", 62, "CFTP");
        builder2.add("sat-expak", 64, "SAT-EXPAK");
        builder2.add("kryptolan", 65, "KRYPTOLAN");
        builder2.add("rvd", 66, "RVD");
        builder2.add("ippc", 67, "IPPC");
        builder2.add("sat-mon", 69, "SAT-MON");
        builder2.add("visa", 70, "VISA");
        builder2.add("ipcv", 71, "IPCV");
        builder2.add("cpnx", 72, "CPNX");
        builder2.add("cphb", 73, "CPHB");
        builder2.add("wsn", 74, "WSN");
        builder2.add("pvp", 75, "PVP");
        builder2.add("br-sat-mon", 76, "BR-SAT-MON");
        builder2.add("sun-nd", 77, "SUN-ND");
        builder2.add("wb-mon", 78, "WB-MON");
        builder2.add("wb-expak", 79, "WB-EXPAK");
        builder2.add("iso-ip", 80, "ISO-IP");
        builder2.add("vmtp", 81, "VMTP");
        builder2.add("secure-vmtp", 82, "SECURE-VMTP");
        builder2.add("vines", 83, "VINES");
        builder2.add("ttp", 84, "TTP");
        builder2.add("nsfnet-igp", 85, "NSFNET-IGP");
        builder2.add("dgp", 86, "DGP");
        builder2.add("tcf", 87, "TCF");
        builder2.add("eigrp", 88, "EIGRP");
        builder2.add("ospf", 89, "OSPFIGP");
        builder2.add("sprite-rpc", 90, "Sprite-RPC");
        builder2.add("larp", 91, "LARP");
        builder2.add("mtp", 92, "MTP");
        builder2.add("ax.25", 93, "AX.25");
        builder2.add("ipip", 94, "IPIP");
        builder2.add("micp", 95, "MICP");
        builder2.add("scc-sp", 96, "SCC-SP");
        builder2.add("etherip", 97, "ETHERIP");
        builder2.add("encap", 98, "ENCAP");
        builder2.add("gmtp", 100, "GMTP");
        builder2.add("ifmp", 101, "IFMP");
        builder2.add("pnni", 102, "PNNI");
        builder2.add("pim", 103, "PIM");
        builder2.add("aris", 104, "ARIS");
        builder2.add("scps", 105, "SCPS");
        builder2.add("qnx", 106, "QNX");
        builder2.add("a/n", 107, "A/N");
        builder2.add("ipcomp", 108, "IPComp");
        builder2.add("snp", 109, "SNP");
        builder2.add("compaq-peer", 110, "Compaq-Peer");
        builder2.add("ipx-in-ip", 111, "IPX-in-IP");
        builder2.add("vrrp", 112, "VRRP");
        builder2.add("pgm", 113, "PGM");
        builder2.add("l2tp", 115, "L2TP");
        builder2.add("ddx", 116, "DDX");
        builder2.add("iatp", 117, "IATP");
        builder2.add("st", 118, "ST");
        builder2.add("srp", 119, "SRP");
        builder2.add("uti", 120, "UTI");
        builder2.add("smp", 121, "SMP");
        builder2.add("sm", 122, "SM");
        builder2.add("ptp", 123, "PTP");
        builder2.add("isis", 124, "ISIS");
        builder2.add("fire", 125, "FIRE");
        builder2.add("crtp", 126, "CRTP");
        builder2.add("crdup", 127, "CRUDP");
        builder2.add("sscopmce", 128, "SSCOPMCE");
        builder2.add("iplt", 129, "IPLT");
        builder2.add("sps", 130, "SPS");
        builder2.add("pipe", 131, "PIPE");
        builder2.add("sctp", 132, "SCTP");
        builder2.add("fc", 133, "FC");
        builder2.add("divert", 254, "DIVERT");
        return builder2;
    }

    static /* synthetic */ ProtocolDBBuilder access$000() {
        return IANAProtocolsDB.initProtocolDB();
    }

    private static final class ProtocolDBBuilder {
        private static final List<String> emptyAliases = Collections.emptyList();
        private final Map<String, Protocol> nameToProto = new HashMap<String, Protocol>();
        private final Map<Integer, Protocol> numberToProto = new HashMap<Integer, Protocol>();

        private ProtocolDBBuilder() {
        }

        public void add(String name, int proto, String ... aliases2) {
            ArrayList<String> aliasesList = aliases2.length > 0 ? new ArrayList<String>(Arrays.asList(aliases2)) : emptyAliases;
            Protocol p = new Protocol(name, proto, aliasesList);
            this.nameToProto.put(name, p);
            for (String alias2 : aliases2) {
                this.nameToProto.put(alias2, p);
            }
            this.numberToProto.put(proto, p);
        }

        public IANAProtocolsDB build() {
            return new IANAProtocolsDB(this.nameToProto, this.numberToProto);
        }
    }

    private static final class SingletonHolder {
        public static final IANAProtocolsDB INSTANCE = IANAProtocolsDB.access$000().build();

        private SingletonHolder() {
        }
    }
}

