/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.robotframework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public final class RobotFrameworkCamelUtils {
    private static final String ROBOT_CAMEL_EXCHANGE_NAME = "exchange";
    private static final String ROBOT_VAR_CAMEL_BODY = "body";
    private static final String ROBOT_VAR_CAMEL_HEADERS = "headers";
    private static final String ROBOT_VAR_CAMEL_PROPERTIES = "properties";
    private static final String ROBOT_VAR_FIELD_SEPERATOR = ":";
    private static final String ROBOT_VAR_NESTING_SEPERATOR = ".";

    private RobotFrameworkCamelUtils() {
    }

    public static List<String> createRobotVariablesFromCamelExchange(Exchange exchange, boolean allowContextMapAll) throws TypeConversionException, NoTypeConversionAvailableException {
        Map<String, Object> variablesMap = ExchangeHelper.createVariableMap(exchange, allowContextMapAll);
        ArrayList<String> variableKeyValuePairList = new ArrayList<String>();
        for (Map.Entry<String, Object> variableEntry : variablesMap.entrySet()) {
            if (ROBOT_VAR_CAMEL_BODY.equals(variableEntry.getKey())) {
                String bodyVariable = variableEntry.getKey() + ROBOT_VAR_FIELD_SEPERATOR + exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, variableEntry.getValue());
                variableKeyValuePairList.add(bodyVariable);
                continue;
            }
            if (ROBOT_VAR_CAMEL_HEADERS.equals(variableEntry.getKey())) {
                RobotFrameworkCamelUtils.createStringValueOfVariablesFromMap(variableKeyValuePairList, ObjectHelper.cast(Map.class, variableEntry.getValue()), exchange, new StringBuilder(), ROBOT_VAR_CAMEL_HEADERS, true);
                continue;
            }
            if (!ROBOT_CAMEL_EXCHANGE_NAME.equals(variableEntry.getKey())) continue;
            RobotFrameworkCamelUtils.createStringValueOfVariablesFromMap(variableKeyValuePairList, exchange.getProperties(), ObjectHelper.cast(Exchange.class, variableEntry.getValue()), new StringBuilder(), ROBOT_VAR_CAMEL_PROPERTIES, true);
        }
        return variableKeyValuePairList;
    }

    private static void createStringValueOfVariablesFromMap(List<String> list, Map<String, Object> headersMap, Exchange exchange, StringBuilder headerVariableName, String baseName, boolean includeBaseName) throws TypeConversionException, NoTypeConversionAvailableException {
        for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
            if (includeBaseName) {
                headerVariableName.append(baseName);
            }
            headerVariableName.append(ROBOT_VAR_NESTING_SEPERATOR).append(entry.getKey());
            if (entry.getValue() instanceof Map) {
                RobotFrameworkCamelUtils.createStringValueOfVariablesFromMap(list, ObjectHelper.cast(Map.class, entry.getValue()), exchange, headerVariableName, headerVariableName.toString(), false);
            } else {
                headerVariableName.append(ROBOT_VAR_FIELD_SEPERATOR).append(exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, entry.getValue()));
            }
            list.add(headerVariableName.toString());
            if (includeBaseName) {
                headerVariableName = new StringBuilder();
                continue;
            }
            headerVariableName = new StringBuilder(baseName);
        }
    }
}

