/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.saga;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.saga.InMemorySagaCoordinator;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class InMemorySagaService
extends ServiceSupport
implements CamelSagaService {
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 5;
    public static final long DEFAULT_RETRY_DELAY_IN_MILLISECONDS = 5000L;
    private CamelContext camelContext;
    private Map<String, CamelSagaCoordinator> coordinators = new ConcurrentHashMap<String, CamelSagaCoordinator>();
    private ScheduledExecutorService executorService;
    private int maxRetryAttempts = 5;
    private long retryDelayInMilliseconds = 5000L;

    @Override
    public CompletableFuture<CamelSagaCoordinator> newSaga() {
        ObjectHelper.notNull(this.camelContext, "camelContext");
        String uuid2 = this.camelContext.getUuidGenerator().generateUuid();
        InMemorySagaCoordinator coordinator = new InMemorySagaCoordinator(this.camelContext, this, uuid2);
        this.coordinators.put(uuid2, coordinator);
        return CompletableFuture.completedFuture(coordinator);
    }

    @Override
    public CompletableFuture<CamelSagaCoordinator> getSaga(String id) {
        return CompletableFuture.completedFuture(this.coordinators.get(id));
    }

    @Override
    public void registerStep(CamelSagaStep step) {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newDefaultScheduledThreadPool(this, "saga");
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public long getRetryDelayInMilliseconds() {
        return this.retryDelayInMilliseconds;
    }

    public void setRetryDelayInMilliseconds(long retryDelayInMilliseconds) {
        this.retryDelayInMilliseconds = retryDelayInMilliseconds;
    }
}

