/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.LoggingLevel;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CamelLogger {
    private Logger log;
    private LoggingLevel level;
    private Marker marker;

    public CamelLogger() {
        this(LoggerFactory.getLogger(CamelLogger.class));
    }

    public CamelLogger(Logger log2) {
        this(log2, LoggingLevel.INFO);
    }

    public CamelLogger(Logger log2, LoggingLevel level) {
        this(log2, level, null);
    }

    public CamelLogger(Logger log2, LoggingLevel level, String marker) {
        this.log = log2;
        this.setLevel(level);
        this.setMarker(marker);
    }

    public CamelLogger(String logName) {
        this(LoggerFactory.getLogger((String)logName));
    }

    public CamelLogger(String logName, LoggingLevel level) {
        this(logName, level, null);
    }

    public CamelLogger(String logName, LoggingLevel level, String marker) {
        this(LoggerFactory.getLogger((String)logName), level, marker);
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    public void log(String message2, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message2);
        this.setLevel(oldLogLevel);
    }

    public void log(String message2) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            if (this.marker != null) {
                CamelLogger.log(this.log, this.level, this.marker, message2);
            } else {
                CamelLogger.log(this.log, this.level, message2);
            }
        }
    }

    public void doLog(String message2) {
        if (this.marker != null) {
            CamelLogger.log(this.log, this.level, this.marker, message2);
        } else {
            CamelLogger.log(this.log, this.level, message2);
        }
    }

    public void log(String message2, Throwable exception, LoggingLevel loggingLevel) {
        CamelLogger.log(this.log, loggingLevel, this.marker, message2, exception);
    }

    public void log(String message2, Throwable exception) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            CamelLogger.log(this.log, this.level, this.marker, message2, exception);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log2) {
        this.log = log2;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Log level may not be null");
        }
        this.level = level;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger((String)logName);
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public void setMarker(String marker) {
        this.marker = ObjectHelper.isNotEmpty(marker) ? MarkerFactory.getMarker((String)marker) : null;
    }

    public static void log(Logger log2, LoggingLevel level, String message2) {
        switch (level) {
            case DEBUG: {
                log2.debug(message2);
                break;
            }
            case ERROR: {
                log2.error(message2);
                break;
            }
            case INFO: {
                log2.info(message2);
                break;
            }
            case TRACE: {
                log2.trace(message2);
                break;
            }
            case WARN: {
                log2.warn(message2);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, Marker marker, String message2) {
        switch (level) {
            case DEBUG: {
                log2.debug(marker, message2);
                break;
            }
            case ERROR: {
                log2.error(marker, message2);
                break;
            }
            case INFO: {
                log2.info(marker, message2);
                break;
            }
            case TRACE: {
                log2.trace(marker, message2);
                break;
            }
            case WARN: {
                log2.warn(marker, message2);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, String message2, Throwable th) {
        switch (level) {
            case DEBUG: {
                log2.debug(message2, th);
                break;
            }
            case ERROR: {
                log2.error(message2, th);
                break;
            }
            case INFO: {
                log2.info(message2, th);
                break;
            }
            case TRACE: {
                log2.trace(message2, th);
                break;
            }
            case WARN: {
                log2.warn(message2, th);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, Marker marker, String message2, Throwable th) {
        if (marker == null) {
            CamelLogger.log(log2, level, message2, th);
            return;
        }
        switch (level) {
            case DEBUG: {
                log2.debug(marker, message2, th);
                break;
            }
            case ERROR: {
                log2.error(marker, message2, th);
                break;
            }
            case INFO: {
                log2.info(marker, message2, th);
                break;
            }
            case TRACE: {
                log2.trace(marker, message2, th);
                break;
            }
            case WARN: {
                log2.warn(marker, message2, th);
                break;
            }
        }
    }

    public boolean shouldLog() {
        return CamelLogger.shouldLog(this.log, this.level);
    }

    public static boolean shouldLog(Logger log2, LoggingLevel level) {
        switch (level) {
            case DEBUG: {
                return log2.isDebugEnabled();
            }
            case ERROR: {
                return log2.isErrorEnabled();
            }
            case INFO: {
                return log2.isInfoEnabled();
            }
            case TRACE: {
                return log2.isTraceEnabled();
            }
            case WARN: {
                return log2.isWarnEnabled();
            }
        }
        return false;
    }
}

