/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface Resource {
    public String getScheme();

    public String getLocation();

    public boolean exists();

    default public URI getURI() {
        return URI.create(this.getLocation());
    }

    default public URL getURL() throws MalformedURLException {
        URI uri = this.getURI();
        return uri != null ? uri.toURL() : null;
    }

    public InputStream getInputStream() throws IOException;

    default public Reader getReader() throws Exception {
        return this.getReader(StandardCharsets.UTF_8);
    }

    default public Reader getReader(Charset charset2) throws Exception {
        return new InputStreamReader(this.getInputStream(), charset2);
    }
}

