/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesBuilderLoader;

public interface RoutesLoader
extends CamelContextAware {
    public static final String FACTORY = "routes-loader";

    public RoutesBuilderLoader getRoutesLoader(String var1) throws Exception;

    default public void loadRoutes(Collection<Resource> resources) throws Exception {
        Collection<RoutesBuilder> builders2 = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder2 : builders2) {
            if (!(builder2 instanceof RouteConfigurationsBuilder)) continue;
            this.getCamelContext().addRoutesConfigurations((RouteConfigurationsBuilder)((Object)builder2));
        }
        for (RoutesBuilder builder2 : builders2) {
            this.getCamelContext().addRoutes(builder2);
        }
        for (RoutesBuilder builder2 : builders2) {
            this.getCamelContext().addTemplatedRoutes(builder2);
        }
    }

    default public void loadRoutes(Resource ... resources) throws Exception {
        Collection<RoutesBuilder> builders2 = this.findRoutesBuilders(resources);
        for (RoutesBuilder builder2 : builders2) {
            if (!(builder2 instanceof RouteConfigurationsBuilder)) continue;
            this.getCamelContext().addRoutesConfigurations((RouteConfigurationsBuilder)((Object)builder2));
        }
        for (RoutesBuilder builder2 : builders2) {
            this.getCamelContext().addRoutes(builder2);
        }
        for (RoutesBuilder builder2 : builders2) {
            this.getCamelContext().addTemplatedRoutes(builder2);
        }
    }

    default public Set<String> updateRoutes(Resource ... resources) throws Exception {
        return this.updateRoutes(Arrays.asList(resources));
    }

    public Set<String> updateRoutes(Collection<Resource> var1) throws Exception;

    default public Collection<RoutesBuilder> findRoutesBuilders(Resource ... resources) throws Exception {
        return this.findRoutesBuilders(Arrays.asList(resources));
    }

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> var1) throws Exception;

    public Collection<RoutesBuilder> findRoutesBuilders(Collection<Resource> var1, boolean var2) throws Exception;

    default public void preParseRoute(Resource resource, boolean optional) throws Exception {
    }

    default public void initRoutesBuilderLoader(RoutesBuilderLoader loader2) {
    }
}

