/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventHelper.class);

    private EventHelper() {
    }

    public static boolean eventsApplicable(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean exchange = false;
        for (EventNotifier en : notifiers) {
            exchange |= !en.isIgnoreExchangeEvents();
        }
        return exchange;
    }

    public static boolean notifyCamelContextInitializing(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextInitializingEvent, true);
    }

    public static boolean notifyCamelContextInitialized(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextInitializedEvent, true);
    }

    public static boolean notifyCamelContextStarting(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextStartingEvent, false);
    }

    public static boolean notifyCamelContextStarted(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextStartedEvent, false);
    }

    public static boolean notifyCamelContextStartupFailed(CamelContext context2, Throwable cause) {
        return EventHelper.notifyCamelContext(context2, (ef, ctx) -> ef.createCamelContextStartupFailureEvent((CamelContext)ctx, cause), false);
    }

    public static boolean notifyCamelContextStopping(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextStoppingEvent, false);
    }

    public static boolean notifyCamelContextStopped(CamelContext context2) {
        return EventHelper.notifyCamelContext(context2, EventFactory::createCamelContextStoppedEvent, false);
    }

    public static boolean notifyCamelContextStopFailed(CamelContext context2, Throwable cause) {
        return EventHelper.notifyCamelContext(context2, (ef, ctx) -> ef.createCamelContextStopFailureEvent((CamelContext)ctx, cause), false);
    }

    private static boolean notifyCamelContext(CamelContext context2, BiFunction<EventFactory, CamelContext, CamelEvent> eventSupplier, boolean init) {
        List<EventNotifier> notifiers;
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> list = notifiers = init ? management.getEventNotifiers() : management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents() || init && notifier.isIgnoreCamelContextInitEvents()) continue;
            if (event == null && (event = eventSupplier.apply(factory, context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStopFailure(CamelContext context2, Object service, Throwable cause) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory.createServiceStopFailureEvent(context2, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStartupFailure(CamelContext context2, Object service, Throwable cause) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory.createServiceStartupFailureEvent(context2, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStarting(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStartingEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStarted(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStartedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStopping(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStoppingEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStopped(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStoppedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteAdded(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteAddedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteRemoved(CamelContext context2, Route route) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteRemovedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteReloaded(CamelContext context2, Route route, int index, int total) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteReloaded(route, index, total)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyContextReloading(CamelContext context2, Object source) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createCamelContextReloading(context2, source)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyContextReloaded(CamelContext context2, Object source) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createCamelContextReloaded(context2, source)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyContextReloadFailure(CamelContext context2, Object source, Throwable cause) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createCamelContextReloadFailure(context2, source, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeCreated(CamelContext context2, Exchange exchange) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCreatedEvent()) continue;
            if (event == null && (event = factory.createExchangeCreatedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeDone(CamelContext context2, Exchange exchange) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCompletedEvent()) continue;
            if (event == null && (event = factory.createExchangeCompletedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailed(CamelContext context2, Exchange exchange) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandling(CamelContext context2, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailureHandlingEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandled(CamelContext context2, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailureHandledEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeRedelivery(CamelContext context2, Exchange exchange, int attempt) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeRedeliveryEvent(exchange, attempt)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSending(CamelContext context2, Exchange exchange, Endpoint endpoint) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSendingEvents()) continue;
            if (event == null && (event = factory.createExchangeSendingEvent(exchange, endpoint)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSent(CamelContext context2, Exchange exchange, Endpoint endpoint, long timeTaken) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSentEvents()) continue;
            if (event == null && (event = factory.createExchangeSentEvent(exchange, endpoint, timeTaken)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspending(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextSuspendingEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspended(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextSuspendedEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResuming(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumingEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumed(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumedEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumeFailed(CamelContext context2, Throwable cause) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumeFailureEvent(context2, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStarting(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextRoutesStartingEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStarted(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextRoutesStartedEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStopping(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextRoutesStoppingEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextRoutesStopped(CamelContext context2) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextRoutesStoppedEvent(context2)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepStarted(CamelContext context2, Exchange exchange, String stepId) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory.createStepStartedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepDone(CamelContext context2, Exchange exchange, String stepId) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory.createStepCompletedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyStepFailed(CamelContext context2, Exchange exchange, String stepId) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreStepEvents()) continue;
            if (event == null && (event = factory.createStepFailedEvent(exchange, stepId)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeAsyncProcessingStartedEvent(CamelContext context2, Exchange exchange) {
        ManagementStrategy management = context2.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getStartedEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        if (((ExtendedExchange)exchange).isNotifyEvent()) {
            return false;
        }
        boolean answer = false;
        CamelEvent event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeAsyncProcessingStartedEvents()) continue;
            if (event == null && (event = factory.createCamelExchangeAsyncProcessingStartedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    private static boolean doNotifyEvent(EventNotifier notifier, CamelEvent event) {
        if (!notifier.isEnabled(event)) {
            LOG.trace("Notifier: {} is not enabled for the event: {}", (Object)notifier, (Object)event);
            return false;
        }
        try {
            notifier.notify(event);
        }
        catch (Throwable e) {
            LOG.warn("Error notifying event " + event + ". This exception will be ignored.", e);
        }
        return true;
    }
}

