/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.util.ObjectHelper;

public final class PredicateAssertHelper {
    private PredicateAssertHelper() {
    }

    public static void assertMatches(Predicate predicate, String text2, Exchange exchange) {
        ObjectHelper.notNull(predicate, "predicate");
        ObjectHelper.notNull(exchange, "exchange");
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate eval = (BinaryPredicate)predicate;
            String evalText = eval.matchesReturningFailureMessage(exchange);
            if (evalText != null) {
                throw new AssertionError((Object)(text2 + predicate + " evaluated as: " + evalText + " on " + exchange));
            }
        } else {
            PredicateAssertHelper.doAssertMatches(predicate, text2, exchange);
        }
    }

    private static void doAssertMatches(Predicate predicate, String text2, Exchange exchange) {
        if (!predicate.matches(exchange)) {
            if (text2 == null) {
                throw new AssertionError((Object)(predicate + " on " + exchange));
            }
            throw new AssertionError((Object)(text2 + predicate + " on " + exchange));
        }
    }
}

