/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public final class PropertyConfigurerHelper {
    private PropertyConfigurerHelper() {
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context2, Object target) {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(context2, "context");
        PropertyConfigurer configurer2 = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            configurer2 = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer2 == null) {
            String name = target.getClass().getName();
            configurer2 = context2.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context2);
        }
        return configurer2;
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context2, Class<?> targetType) {
        ObjectHelper.notNull(targetType, "targetType");
        ObjectHelper.notNull(context2, "context");
        String name = targetType.getName();
        return context2.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context2);
    }

    public static <T> T resolvePropertyConfigurer(CamelContext context2, Object target, Class<T> type) {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(context2, "context");
        PropertyConfigurer configurer2 = PropertyConfigurerHelper.resolvePropertyConfigurer(context2, target);
        if (type.isInstance(configurer2)) {
            return type.cast(configurer2);
        }
        return null;
    }
}

