/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceResolverSupport
extends ServiceSupport
implements ResourceResolver {
    private final String scheme;
    private final Logger logger;
    private CamelContext camelContext;

    protected ResourceResolverSupport(String scheme) {
        this.scheme = scheme;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public String getSupportedScheme() {
        return this.scheme;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Resource resolve(String location) {
        if (!location.startsWith(this.getSupportedScheme() + ":")) {
            throw new IllegalArgumentException("Unsupported scheme: " + location);
        }
        String context2 = StringHelper.after(location, ":");
        if (context2 == null) {
            throw new IllegalArgumentException("No context path provided: " + location);
        }
        if (context2.contains("{{") && context2.contains("}}")) {
            context2 = this.camelContext.getPropertiesComponent().parseUri(context2);
        }
        return this.createResource(location, context2);
    }

    protected abstract Resource createResource(String var1, String var2);

    protected String getRemaining(String location) {
        return StringHelper.after(location, this.getSupportedScheme() + ":");
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

