/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cluster;

import java.util.Optional;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.apache.camel.util.ObjectHelper;

public final class ClusterServiceHelper {
    private ClusterServiceHelper() {
    }

    public static Optional<CamelClusterService> lookupService(CamelContext context2) {
        return ClusterServiceHelper.lookupService(context2, ClusterServiceSelectors.DEFAULT_SELECTOR);
    }

    public static Optional<CamelClusterService> lookupService(CamelContext context2, CamelClusterService.Selector selector) {
        ObjectHelper.notNull(context2, "Camel Context");
        ObjectHelper.notNull(selector, "ClusterService selector");
        Set<CamelClusterService> services = context2.hasServices(CamelClusterService.class);
        if (ObjectHelper.isNotEmpty(services)) {
            return selector.select(services);
        }
        return Optional.empty();
    }

    public static CamelClusterService mandatoryLookupService(CamelContext context2) {
        return ClusterServiceHelper.lookupService(context2).orElseThrow(() -> new IllegalStateException("CamelCluster service not found"));
    }

    public static CamelClusterService mandatoryLookupService(CamelContext context2, CamelClusterService.Selector selector) {
        return ClusterServiceHelper.lookupService(context2, selector).orElseThrow(() -> new IllegalStateException("CamelCluster service not found"));
    }
}

