/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.support.component.PropertyNamesInterceptor;
import org.apache.camel.support.component.ResultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiConsumerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ApiConsumerHelper.class);

    private ApiConsumerHelper() {
    }

    public static <E extends Enum<E>, T> ApiMethod findMethod(AbstractApiEndpoint<E, T> endpoint, PropertyNamesInterceptor propertyNamesInterceptor) {
        ApiMethod result2;
        Set<String> names = endpoint.getEndpointPropertyNames();
        HashSet<String> argNames = new HashSet<String>(names);
        propertyNamesInterceptor.interceptPropertyNames(argNames);
        List<ApiMethod> filteredMethods = endpoint.methodHelper.filterMethods(endpoint.getCandidates(), ApiMethodHelper.MatchType.SUPER_SET, argNames);
        if (filteredMethods.isEmpty()) {
            ApiMethodHelper<ApiMethod> methodHelper = endpoint.getMethodHelper();
            throw new IllegalArgumentException(String.format("Missing properties for %s/%s, need one or more from %s", ((ApiName)((Object)((Enum)endpoint.getApiName()))).getName(), endpoint.getMethodName(), methodHelper.getMissingProperties(endpoint.getMethodName(), argNames)));
        }
        if (filteredMethods.size() == 1) {
            result2 = filteredMethods.get(0);
        } else {
            result2 = ApiMethodHelper.getHighestPriorityMethod(filteredMethods);
            LOG.warn(String.format("Using highest priority operation %s from operations %s for endpoint %s", result2, filteredMethods, endpoint.getEndpointUri()));
        }
        return result2;
    }

    public static <T extends DefaultConsumer> int getResultsProcessed(T consumer, Object result2, boolean splitResult) throws Exception {
        Object results;
        if (result2 != null && splitResult && (results = ((ResultInterceptor)((Object)consumer)).splitResult(result2)) != null) {
            if (results instanceof List) {
                List list = (List)results;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ApiConsumerHelper.processResult(consumer, result2, list.get(i));
                }
                return size;
            }
            if (results instanceof Iterable) {
                int size = 0;
                for (Object singleResult : (Iterable)results) {
                    ApiConsumerHelper.processResult(consumer, result2, singleResult);
                    ++size;
                }
                return size;
            }
            if (results.getClass().isArray()) {
                int size = Array.getLength(results);
                for (int i = 0; i < size; ++i) {
                    ApiConsumerHelper.processResult(consumer, result2, Array.get(results, i));
                }
                return size;
            }
        }
        ApiConsumerHelper.processResult(consumer, result2, result2);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends DefaultConsumer> void processResult(T consumer, Object methodResult, Object result2) throws Exception {
        Exchange exchange = consumer.createExchange(false);
        try {
            exchange.getIn().setBody(result2);
            ((ResultInterceptor)((Object)consumer)).interceptResult(methodResult, exchange);
            consumer.getProcessor().process(exchange);
        }
        finally {
            Exception exception = exchange.getException();
            if (exception != null) {
                consumer.getExceptionHandler().handleException("Error processing exchange", exchange, exception);
            }
            consumer.releaseExchange(exchange, false);
        }
    }
}

