/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jndi;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.BeanRepository;

public class JndiBeanRepository
implements BeanRepository {
    private Context context;
    private Map environment;
    private final boolean standalone;

    public JndiBeanRepository() {
        this.standalone = false;
    }

    public JndiBeanRepository(Map environment) {
        this.environment = environment;
        this.standalone = false;
    }

    public JndiBeanRepository(Context context2) {
        this.context = context2;
        this.standalone = false;
    }

    public JndiBeanRepository(boolean standalone) {
        this.standalone = true;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object answer = this.lookupByName(name);
        if (answer == null) {
            return null;
        }
        try {
            answer = this.unwrap(answer);
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg2 = "Found bean: " + name + " in JNDI Context: " + this.context + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg2, e);
        }
    }

    @Override
    public Object lookupByName(String name) {
        try {
            return this.unwrap(this.getContext().lookup(name));
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap<String, T> answer = new LinkedHashMap<String, T>();
        try {
            NamingEnumeration<NameClassPair> list = this.getContext().list("");
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                Object instance = this.context.lookup(pair.getName());
                if (!type.isInstance(instance = this.unwrap(instance))) continue;
                answer.put(pair.getName(), type.cast(instance));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> answer = new LinkedHashSet<T>();
        try {
            NamingEnumeration<NameClassPair> list = this.getContext().list("");
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                Object instance = this.context.lookup(pair.getName());
                if (!type.isInstance(instance = this.unwrap(instance))) continue;
                answer.add(type.cast(instance));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return answer;
    }

    public void close() throws NamingException {
        if (this.context != null) {
            this.context.close();
        }
    }

    public Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(Context context2) {
        this.context = context2;
    }

    protected Context createContext() throws NamingException {
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>(System.getProperties());
        if (this.environment != null) {
            properties.putAll(this.environment);
        }
        if (this.standalone && !properties.containsKey("java.naming.factory.initial")) {
            properties.put("java.naming.factory.initial", "org.apache.camel.support.jndi.CamelInitialContextFactory");
        }
        return new InitialContext(properties);
    }
}

