/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.support.jsse.JsseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreParameters
extends JsseParameters {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreParameters.class);
    protected String type;
    protected String password;
    protected String provider;
    protected KeyStore keyStore;
    protected String resource;

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        if (this.keyStore != null) {
            if (LOG.isDebugEnabled()) {
                List<String> aliases2 = this.extractAliases(this.keyStore);
                LOG.debug("KeyStore [{}], initialized from [{}], is using provider [{}], has type [{}], and contains aliases {}.", new Object[]{this.keyStore, this, this.keyStore.getProvider(), this.keyStore.getType(), aliases2});
            }
            return this.keyStore;
        }
        LOG.trace("Creating KeyStore instance from KeyStoreParameters [{}].", (Object)this);
        String ksType = this.parsePropertyValue(this.type);
        if (ksType == null) {
            ksType = KeyStore.getDefaultType();
        }
        char[] ksPassword = null;
        if (this.password != null) {
            ksPassword = this.parsePropertyValue(this.password).toCharArray();
        }
        KeyStore ks = this.provider == null ? KeyStore.getInstance(ksType) : KeyStore.getInstance(ksType, this.parsePropertyValue(this.provider));
        if (this.resource == null) {
            ks.load(null, ksPassword);
        } else {
            InputStream is = this.resolveResource(this.parsePropertyValue(this.resource));
            ks.load(is, ksPassword);
        }
        if (LOG.isDebugEnabled()) {
            List<String> aliases3 = this.extractAliases(ks);
            LOG.debug("KeyStore [{}], initialized from [{}], is using provider [{}], has type [{}], and contains aliases {}.", new Object[]{ks, this, ks.getProvider(), ks.getType(), aliases3});
        }
        return ks;
    }

    private List<String> extractAliases(KeyStore ks) {
        LinkedList<String> aliases2 = new LinkedList<String>();
        Enumeration<String> aliasEnum = null;
        try {
            aliasEnum = ks.aliases();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        while (aliasEnum.hasMoreElements()) {
            aliases2.add(aliasEnum.nextElement());
        }
        return aliases2;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("KeyStoreParameters[type=");
        builder2.append(this.type);
        builder2.append(", password=");
        builder2.append("********");
        builder2.append(", provider=");
        builder2.append(this.provider);
        builder2.append(", resource=");
        builder2.append(this.resource);
        builder2.append("]");
        return builder2.toString();
    }
}

