/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelLogProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelLogProcessor.class);
    private String id;
    private String routeId;
    private CamelLogger logger;
    private ExchangeFormatter formatter = new ToStringExchangeFormatter();
    private MaskingFormatter maskingFormatter;
    private final Set<LogListener> listeners;

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger logger2) {
        this.logger = logger2;
        this.listeners = null;
    }

    public CamelLogProcessor(CamelLogger logger2, ExchangeFormatter formatter2, MaskingFormatter maskingFormatter, Set<LogListener> listeners2) {
        this.logger = logger2;
        this.formatter = formatter2;
        this.maskingFormatter = maskingFormatter;
        this.listeners = listeners2;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.logger.shouldLog()) {
            String output2 = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output2 = this.maskingFormatter.format(output2);
            }
            output2 = this.fireListeners(exchange, output2);
            this.logger.log(output2);
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange, Throwable exception) {
        if (this.logger.shouldLog()) {
            String output2 = this.formatter.format(exchange);
            if (this.maskingFormatter != null) {
                output2 = this.maskingFormatter.format(output2);
            }
            output2 = this.fireListeners(exchange, output2);
            this.logger.log(output2, exception);
        }
    }

    public void process(Exchange exchange, String message2) {
        if (this.logger.shouldLog()) {
            Object output2 = this.formatter.format(exchange) + message2;
            if (this.maskingFormatter != null) {
                output2 = this.maskingFormatter.format((String)output2);
            }
            output2 = this.fireListeners(exchange, (String)output2);
            this.logger.log((String)output2);
        }
    }

    private String fireListeners(Exchange exchange, String message2) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return message2;
        }
        for (LogListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                String output2 = listener.onLog(exchange, this.logger, message2);
                message2 = output2 != null ? output2 : message2;
            }
            catch (Throwable t) {
                LOG.warn("Ignoring an exception thrown by {}: {}", (Object)listener.getClass().getName(), (Object)t.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("", t);
            }
        }
        return message2;
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    public void setLogName(String logName) {
        this.logger.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.logger.setLevel(level);
    }

    public void setMarker(String marker) {
        this.logger.setMarker(marker);
    }

    public void setMaskingFormatter(MaskingFormatter maskingFormatter) {
        this.maskingFormatter = maskingFormatter;
    }

    static class ToStringExchangeFormatter
    implements ExchangeFormatter {
        ToStringExchangeFormatter() {
        }

        @Override
        public String format(Exchange exchange) {
            return exchange.toString();
        }
    }
}

