/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdapterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterHelper.class);

    private AdapterHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ResumeAdapter eval(CamelContext context2, ResumeAware resumeAware, ResumeStrategy resumeStrategy) {
        assert (context2 != null);
        assert (resumeAware != null);
        assert (resumeStrategy != null);
        LOG.debug("Using the factory finder to search for the resume adapter");
        FactoryFinder factoryFinder = context2.adapt(ExtendedCamelContext.class).getFactoryFinder("META-INF/services/org/apache/camel/");
        LOG.debug("Creating a new resume adapter");
        Optional<ResumeAdapter> adapterOptional = factoryFinder.newInstance(resumeAware.adapterFactoryService(), ResumeAdapter.class);
        if (!adapterOptional.isPresent()) {
            throw new RuntimeCamelException("Cannot find a resume adapter class in the consumer classpath or in the registry");
        }
        ResumeAdapter resumeAdapter = adapterOptional.get();
        LOG.debug("Using the acquired resume adapter: {}", (Object)resumeAdapter.getClass().getName());
        if (!(resumeAdapter instanceof Cacheable)) {
            LOG.debug("The resume adapter {} is not cacheable", (Object)resumeAdapter.getClass().getName());
            return resumeAdapter;
        }
        Cacheable cacheableAdapter = (Cacheable)((Object)resumeAdapter);
        ResumeStrategyConfiguration resumeStrategyConfiguration = resumeStrategy.getResumeStrategyConfiguration();
        ResumeCache<?> resumeCache = resumeStrategyConfiguration.getResumeCache();
        if (resumeStrategyConfiguration != null && resumeCache != null) {
            cacheableAdapter.setCache(resumeCache);
            return resumeAdapter;
        }
        LOG.error("No cache was provided in the configuration for the cacheable resume adapter {}", (Object)resumeAdapter.getClass().getName());
        throw new RuntimeCamelException(String.format("No cache was provided in the configuration for the cacheable resume adapter %s", resumeAdapter.getClass().getName()));
    }
}

