/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class StringHelper {
    private StringHelper() {
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static String removeCRLF(String s) {
        return s.replace("\r", "").replace("\n", "");
    }

    public static int countChar(String s, char ch) {
        return StringHelper.countChar(s, ch, -1);
    }

    public static int countChar(String s, char ch, int end) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int matches = 0;
        int len = end < 0 ? s.length() : end;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String limitLength(String s, int maxLength) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        return s.length() <= maxLength ? s : s.substring(0, maxLength);
    }

    public static String removeQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        s = s.replace("'", "");
        s = s.replace("\"", "");
        return s;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        String copy2 = s.trim();
        if (copy2.length() < 2) {
            return s;
        }
        if (copy2.startsWith("'") && copy2.endsWith("'")) {
            return copy2.substring(1, copy2.length() - 1);
        }
        if (copy2.startsWith("\"") && copy2.endsWith("\"")) {
            return copy2.substring(1, copy2.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text2) {
        if (text2 == null) {
            return "";
        }
        text2 = text2.replace("&", "&amp;");
        text2 = text2.replace("\"", "&quot;");
        text2 = text2.replace("<", "&lt;");
        text2 = text2.replace(">", "&gt;");
        return text2;
    }

    public static boolean hasUpperCase(String text2) {
        if (text2 == null) {
            return false;
        }
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassName(String text2) {
        String lastToken;
        String[] split;
        boolean result2 = false;
        if (text2 != null && (split = text2.split("\\.")).length > 0 && (lastToken = split[split.length - 1]).length() > 0) {
            result2 = Character.isUpperCase(lastToken.charAt(0));
        }
        return result2;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if ("simple".equalsIgnoreCase(language) && expression.contains("${")) {
            return true;
        }
        return language != null && expression.contains("$" + language + "{");
    }

    public static String replaceFirst(String input, String from, String to) {
        int pos = input.indexOf(from);
        if (pos != -1) {
            int len = from.length();
            return input.substring(0, pos) + to + input.substring(pos + len);
        }
        return input;
    }

    public static String toJson(String name, String value, boolean isMap) {
        if (isMap) {
            return "{ " + StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value) + " }";
        }
        return StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value);
    }

    public static String notEmpty(String value, String name) {
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
        return value;
    }

    public static String notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + on);
        }
        return value;
    }

    public static String[] splitOnCharacter(String value, String needle, int count2) {
        String[] rc = new String[count2];
        rc[0] = value;
        for (int i = 1; i < count2; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static Iterator<String> splitOnCharacterAsIterator(String value, final char needle, int count2) {
        boolean skipEnd;
        int end = value.length() - 1;
        boolean skipStart = value.charAt(0) == needle;
        boolean bl = skipEnd = value.charAt(end) == needle;
        if (skipStart && skipEnd) {
            value = value.substring(1, end);
            count2 -= 2;
        } else if (skipStart) {
            value = value.substring(1);
            --count2;
        } else if (skipEnd) {
            value = value.substring(0, end);
            --count2;
        }
        final int size = count2;
        final String text2 = value;
        return new Iterator<String>(){
            int i;
            int pos;

            @Override
            public boolean hasNext() {
                return this.i < size;
            }

            @Override
            public String next() {
                String answer;
                if (this.i == size) {
                    throw new NoSuchElementException();
                }
                int end = text2.indexOf(needle, this.pos);
                if (end != -1) {
                    answer = text2.substring(this.pos, end);
                    this.pos = end + 1;
                } else {
                    answer = text2.substring(this.pos);
                    this.i = size;
                }
                return answer;
            }
        };
    }

    public static List<String> splitOnCharacterAsList(String value, char needle, int count2) {
        boolean skipEnd;
        int end = value.length() - 1;
        boolean skipStart = value.charAt(0) == needle;
        boolean bl = skipEnd = value.charAt(end) == needle;
        if (skipStart && skipEnd) {
            value = value.substring(1, end);
            count2 -= 2;
        } else if (skipStart) {
            value = value.substring(1);
            --count2;
        } else if (skipEnd) {
            value = value.substring(0, end);
            --count2;
        }
        ArrayList<String> rc = new ArrayList<String>(count2);
        int pos = 0;
        for (int i = 0; i < count2; ++i) {
            end = value.indexOf(needle, pos);
            if (end == -1) {
                rc.add(value.substring(pos));
                break;
            }
            String part = value.substring(pos, end);
            pos = end + 1;
            rc.add(part);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text2, char ch) {
        int idx = 0;
        while (text2.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text2.substring(idx);
        }
        return text2;
    }

    public static String capitalize(String text2) {
        return StringHelper.capitalize(text2, false);
    }

    public static String capitalize(String text2, boolean dashToCamelCase) {
        if (dashToCamelCase) {
            text2 = StringHelper.dashToCamelCase(text2);
        }
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        if (length == 0) {
            return text2;
        }
        Object answer = text2.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (length > 1) {
            answer = (String)answer + text2.substring(1, length);
        }
        return answer;
    }

    public static String dashToCamelCase(String text2) {
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        if (length == 0) {
            return text2;
        }
        if (text2.indexOf(45) == -1) {
            return text2;
        }
        StringBuilder sb = new StringBuilder(length - 1);
        boolean upper = false;
        for (int i = 0; i < length; ++i) {
            char c = text2.charAt(i);
            if (c == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            upper = false;
        }
        return sb.toString();
    }

    public static String after(String text2, String after) {
        int pos = text2.indexOf(after);
        if (pos == -1) {
            return null;
        }
        return text2.substring(pos + after.length());
    }

    public static String after(String text2, String after, String defaultValue) {
        String answer = StringHelper.after(text2, after);
        return answer != null ? answer : defaultValue;
    }

    public static <T> Optional<T> after(String text2, String after, Function<String, T> mapper) {
        String result2 = StringHelper.after(text2, after);
        if (result2 == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result2));
    }

    public static String afterLast(String text2, String after) {
        int pos = text2.lastIndexOf(after);
        if (pos == -1) {
            return null;
        }
        return text2.substring(pos + after.length());
    }

    public static String afterLast(String text2, String after, String defaultValue) {
        String answer = StringHelper.afterLast(text2, after);
        return answer != null ? answer : defaultValue;
    }

    public static String before(String text2, String before) {
        int pos = text2.indexOf(before);
        return pos == -1 ? null : text2.substring(0, pos);
    }

    public static String before(String text2, String before, String defaultValue) {
        String answer = StringHelper.before(text2, before);
        return answer != null ? answer : defaultValue;
    }

    public static <T> Optional<T> before(String text2, String before, Function<String, T> mapper) {
        String result2 = StringHelper.before(text2, before);
        if (result2 == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result2));
    }

    public static String beforeLast(String text2, String before) {
        int pos = text2.lastIndexOf(before);
        return pos == -1 ? null : text2.substring(0, pos);
    }

    public static String beforeLast(String text2, String before, String defaultValue) {
        String answer = StringHelper.beforeLast(text2, before);
        return answer != null ? answer : defaultValue;
    }

    public static String between(String text2, String after, String before) {
        if ((text2 = StringHelper.after(text2, after)) == null) {
            return null;
        }
        return StringHelper.before(text2, before);
    }

    public static <T> Optional<T> between(String text2, String after, String before, Function<String, T> mapper) {
        String result2 = StringHelper.between(text2, after, before);
        if (result2 == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result2));
    }

    public static String betweenOuterPair(String text2, char before, char after) {
        if (text2 == null) {
            return null;
        }
        int pos = -1;
        int pos2 = -1;
        int count2 = 0;
        int count22 = 0;
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            if (!doubleQuoted && ch == '\'') {
                singleQuoted = !singleQuoted;
            } else if (!singleQuoted && ch == '\"') {
                boolean bl = doubleQuoted = !doubleQuoted;
            }
            if (singleQuoted || doubleQuoted) continue;
            if (ch == before) {
                ++count2;
            } else if (ch == after) {
                ++count22;
            }
            if (ch == before && pos == -1) {
                pos = i;
                continue;
            }
            if (ch != after) continue;
            pos2 = i;
        }
        if (pos == -1 || pos2 == -1) {
            return null;
        }
        if (count2 != count22) {
            return null;
        }
        return text2.substring(pos + 1, pos2);
    }

    public static <T> Optional<T> betweenOuterPair(String text2, char before, char after, Function<String, T> mapper) {
        String result2 = StringHelper.betweenOuterPair(text2, before, after);
        if (result2 == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result2));
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < size; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizeClassName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && ch != '-' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<Integer> changedLines(String oldText, String newText) {
        if (oldText == null || oldText.equals(newText)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changed = new ArrayList<Integer>();
        String[] oldLines = oldText.split("\n");
        String[] newLines = newText.split("\n");
        for (int i = 0; i < newLines.length; ++i) {
            String oldLine;
            String newLine = newLines[i];
            String string2 = oldLine = i < oldLines.length ? oldLines[i] : null;
            if (oldLine == null) {
                changed.add(i);
                continue;
            }
            if (newLine.equals(oldLine)) continue;
            changed.add(i);
        }
        return changed;
    }

    public static String trimToNull(String given) {
        if (given == null) {
            return null;
        }
        String trimmed = given.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed;
    }

    public static boolean containsIgnoreCase(String src, String what) {
        if (src == null || what == null) {
            return false;
        }
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String humanReadableBytes(Locale locale2, long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format(locale2, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBytes(long bytes) {
        return StringHelper.humanReadableBytes(Locale.getDefault(), bytes);
    }

    public static boolean matches(String pattern, String target) {
        if (Objects.equals(pattern, target)) {
            return true;
        }
        if (Objects.isNull(pattern)) {
            return true;
        }
        if (Objects.equals("*", pattern)) {
            return true;
        }
        if (AntPathMatcher.INSTANCE.match(pattern, target)) {
            return true;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(target);
        return m.matches();
    }

    public static String camelCaseToDash(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return text2;
        }
        StringBuilder answer = new StringBuilder();
        Character prev = null;
        Character next = null;
        char[] arr = text2.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            next = i < arr.length - 1 ? Character.valueOf(arr[i + 1]) : null;
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != null && !Character.isUpperCase(prev.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else if (Character.isUpperCase(ch) && prev != null && next != null && Character.isLowerCase(next.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else {
                answer.append(ch);
            }
            prev = Character.valueOf(ch);
        }
        return answer.toString().toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String text2, String prefix) {
        if (text2 != null && prefix != null) {
            return prefix.length() > text2.length() ? false : text2.regionMatches(true, 0, prefix, 0, prefix.length());
        }
        return text2 == null && prefix == null;
    }

    public static String asEnumConstantValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        value = StringHelper.camelCaseToDash(value);
        value = value.replaceAll("-+", "-");
        value = value.replace('-', '_').toUpperCase(Locale.ENGLISH);
        return value;
    }

    public static String[] splitWords(String text2) {
        return text2.split("[\\W]+");
    }

    public static Stream<String> splitAsStream(CharSequence text2, String regex) {
        if (text2 == null || regex == null) {
            return Stream.empty();
        }
        return Pattern.compile(regex).splitAsStream(text2);
    }

    public static int countOccurrence(String text2, String search2) {
        int lastIndex = 0;
        int count2 = 0;
        while (lastIndex != -1) {
            if ((lastIndex = text2.indexOf(search2, lastIndex)) == -1) continue;
            ++count2;
            lastIndex += search2.length();
        }
        return count2;
    }

    public static String replaceFromSecondOccurrence(String text2, String search2, String replacement) {
        int index = ((String)text2).indexOf(search2);
        boolean replace = false;
        while (index != -1) {
            String tempString = ((String)text2).substring(index);
            if (replace) {
                tempString = tempString.replaceFirst(search2, replacement);
                text2 = ((String)text2).substring(0, index) + tempString;
                replace = false;
            } else {
                replace = true;
            }
            index = ((String)text2).indexOf(search2, index + 1);
        }
        return text2;
    }

    public static String padString(int level) {
        return StringHelper.padString(level, 2);
    }

    public static String padString(int level, int blanks) {
        if (level == 0) {
            return "";
        }
        byte[] arr = new byte[level * blanks];
        byte space = 32;
        Arrays.fill(arr, space);
        return new String(arr);
    }

    public static String fillChars(char ch, int count2) {
        if (count2 <= 0) {
            return "";
        }
        byte[] arr = new byte[count2];
        byte b = (byte)ch;
        Arrays.fill(arr, b);
        return new String(arr);
    }

    public static boolean isDigit(String s) {
        for (char ch : s.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }
}

