/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Pair;
import org.apache.camel.util.URISupport;

class URIScanner {
    private static final String CHARSET = "UTF-8";
    private static final char END = '\u0000';
    private final StringBuilder key = new StringBuilder();
    private final StringBuilder value = new StringBuilder();
    private boolean keyMode = true;
    private boolean isRaw;
    private char rawTokenEnd;

    URIScanner() {
    }

    private void initState() {
        this.keyMode = true;
        this.key.setLength(0);
        this.value.setLength(0);
        this.isRaw = false;
    }

    public Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        try {
            LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
            int len = uri.length();
            for (int i = 0; i < len; ++i) {
                char ch = uri.charAt(i);
                char next = i <= len - 2 ? uri.charAt(i + 1) : (char)'\u0000';
                if (this.keyMode) {
                    if (ch == '=') {
                        this.keyMode = false;
                        continue;
                    }
                    if (ch != '&') {
                        this.key.append(ch);
                    }
                } else {
                    this.isRaw = this.checkRaw();
                    if (this.isRaw) {
                        this.value.append(ch);
                        if (!this.isAtEnd(ch, next)) continue;
                        this.addParameter(answer, useRaw || this.isRaw);
                        this.initState();
                        ++i;
                        continue;
                    }
                    if (ch != '&') {
                        this.value.append(ch);
                    }
                }
                if (ch != '&') continue;
                this.addParameter(answer, useRaw || this.isRaw);
                this.initState();
            }
            if (this.key.length() > 0) {
                this.addParameter(answer, useRaw || this.isRaw);
            }
            return answer;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private boolean checkRaw() {
        this.rawTokenEnd = '\u0000';
        if (this.value.length() < 4) {
            return false;
        }
        char char1 = this.value.charAt(0);
        char char2 = this.value.charAt(1);
        char char3 = this.value.charAt(2);
        char char4 = this.value.charAt(3);
        if (char1 == 'R' && char2 == 'A' && char3 == 'W') {
            if (char4 == '(') {
                this.rawTokenEnd = URISupport.RAW_TOKEN_END[0];
                return true;
            }
            if (char4 == '{') {
                this.rawTokenEnd = URISupport.RAW_TOKEN_END[1];
                return true;
            }
        }
        return false;
    }

    private boolean isAtEnd(char ch, char next) {
        return ch == this.rawTokenEnd && (next == '&' || next == '\u0000');
    }

    private void addParameter(Map<String, Object> answer, boolean isRaw) throws UnsupportedEncodingException {
        String text2;
        String name = URLDecoder.decode(this.key.toString(), CHARSET);
        if (isRaw) {
            text2 = this.value.toString();
        } else {
            String s = this.value.toString().replace("%", "%25");
            text2 = URLDecoder.decode(s, CHARSET);
        }
        if (answer.containsKey(name)) {
            List list;
            Object existing = answer.get(name);
            if (existing instanceof List) {
                list = CastUtils.cast((List)existing);
            } else {
                String s;
                list = new ArrayList();
                String string2 = s = existing != null ? existing.toString() : null;
                if (s != null) {
                    list.add(s);
                }
            }
            list.add(text2);
            answer.put(name, list);
        } else {
            answer.put(name, text2);
        }
    }

    public static List<Pair<Integer>> scanRaw(String str) {
        if (str == null || ObjectHelper.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Integer>> answer = new ArrayList<Pair<Integer>>();
        int offset = 0;
        int start = str.indexOf("RAW");
        while (start >= 0 && offset < str.length()) {
            offset = start + "RAW".length();
            for (int i = 0; i < URISupport.RAW_TOKEN_START.length; ++i) {
                String tokenStart = "RAW" + URISupport.RAW_TOKEN_START[i];
                char tokenEnd = URISupport.RAW_TOKEN_END[i];
                if (!str.startsWith(tokenStart, start)) continue;
                offset = URIScanner.scanRawToEnd(str, start, tokenStart, tokenEnd, answer);
            }
            start = str.indexOf("RAW", offset);
        }
        return answer;
    }

    private static int scanRawToEnd(String str, int start, String tokenStart, char tokenEnd, List<Pair<Integer>> answer) {
        int end = str.indexOf(tokenEnd, start + tokenStart.length());
        if (end < 0) {
            answer.add(new Pair<Integer>(start, str.length()));
            return str.length();
        }
        answer.add(new Pair<Integer>(start, end));
        return end + 1;
    }

    public static String resolveRaw(String str) {
        int len = str.length();
        if (len <= 4) {
            return null;
        }
        int endPos = len - 1;
        char last = str.charAt(endPos);
        if (last == ')') {
            char char1 = str.charAt(0);
            char char2 = str.charAt(1);
            char char3 = str.charAt(2);
            char char4 = str.charAt(3);
            if (char1 == 'R' && char2 == 'A' && char3 == 'W' && char4 == '(') {
                return str.substring(4, endPos);
            }
        } else if (last == '}') {
            char char1 = str.charAt(0);
            char char2 = str.charAt(1);
            char char3 = str.charAt(2);
            char char4 = str.charAt(3);
            if (char1 == 'R' && char2 == 'A' && char3 == 'W' && char4 == '{') {
                return str.substring(4, endPos);
            }
        }
        return null;
    }
}

