/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.python.apache.xml.serialize.HTMLSerializer;
import org.python.apache.xml.serialize.OutputFormat;
import org.python.apache.xml.serialize.Serializer;
import org.python.apache.xml.serialize.SerializerFactory;
import org.python.apache.xml.serialize.TextSerializer;
import org.python.apache.xml.serialize.XHTMLSerializer;
import org.python.apache.xml.serialize.XMLSerializer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string2) {
        this._method = string2;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string2});
            throw new IllegalArgumentException(string3);
        }
    }

    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer2 = this.getSerializer(outputFormat);
        serializer2.setOutputFormat(outputFormat);
        return serializer2;
    }

    public Serializer makeSerializer(Writer writer2, OutputFormat outputFormat) {
        Serializer serializer2 = this.getSerializer(outputFormat);
        serializer2.setOutputCharStream(writer2);
        return serializer2;
    }

    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer2 = this.getSerializer(outputFormat);
        serializer2.setOutputByteStream(outputStream);
        return serializer2;
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(string2);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

