/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeAlgorithmSpec
implements AlgorithmParameterSpec {
    private final List<String> algorithmNames;
    private final List<AlgorithmParameterSpec> parameterSpecs;

    public CompositeAlgorithmSpec(Builder builder2) {
        this.algorithmNames = Collections.unmodifiableList(new ArrayList(builder2.algorithmNames));
        this.parameterSpecs = Collections.unmodifiableList(new ArrayList(builder2.parameterSpecs));
    }

    public List<String> getAlgorithmNames() {
        return this.algorithmNames;
    }

    public List<AlgorithmParameterSpec> getParameterSpecs() {
        return this.parameterSpecs;
    }

    public static class Builder {
        private List<String> algorithmNames = new ArrayList<String>();
        private List<AlgorithmParameterSpec> parameterSpecs = new ArrayList<AlgorithmParameterSpec>();

        public Builder add(String string2) {
            this.algorithmNames.add(string2);
            this.parameterSpecs.add(null);
            return this;
        }

        public Builder add(String string2, AlgorithmParameterSpec algorithmParameterSpec) {
            this.algorithmNames.add(string2);
            this.parameterSpecs.add(algorithmParameterSpec);
            return this;
        }

        public CompositeAlgorithmSpec build() {
            if (this.algorithmNames.isEmpty()) {
                throw new IllegalStateException("cannot call build with no algorithm names added");
            }
            return new CompositeAlgorithmSpec(this);
        }
    }
}

