/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.mime.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.python.bouncycastle.cms.CMSAttributeTableGenerator;
import org.python.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.python.bouncycastle.cms.CMSException;
import org.python.bouncycastle.cms.OriginatorInformation;
import org.python.bouncycastle.cms.RecipientInfoGenerator;
import org.python.bouncycastle.mime.Headers;
import org.python.bouncycastle.mime.MimeIOException;
import org.python.bouncycastle.mime.MimeWriter;
import org.python.bouncycastle.mime.encoding.Base64OutputStream;
import org.python.bouncycastle.mime.smime.SMimeUtils;
import org.python.bouncycastle.operator.OutputEncryptor;
import org.python.bouncycastle.util.Strings;

public class SMIMEEnvelopedWriter
extends MimeWriter {
    private final CMSEnvelopedDataStreamGenerator envGen;
    private final OutputEncryptor outEnc;
    private final OutputStream mimeOut;
    private final String contentTransferEncoding;

    private SMIMEEnvelopedWriter(Builder builder2, OutputEncryptor outputEncryptor, OutputStream outputStream) {
        super(new Headers(SMIMEEnvelopedWriter.mapToLines(builder2.headers), builder2.contentTransferEncoding));
        this.envGen = builder2.envGen;
        this.contentTransferEncoding = builder2.contentTransferEncoding;
        this.outEnc = outputEncryptor;
        this.mimeOut = outputStream;
    }

    public OutputStream getContentStream() throws IOException {
        this.headers.dumpHeaders(this.mimeOut);
        this.mimeOut.write(Strings.toByteArray("\r\n"));
        try {
            if ("base64".equals(this.contentTransferEncoding)) {
                Base64OutputStream base64OutputStream = new Base64OutputStream(this.mimeOut);
                return new ContentOutputStream(this.envGen.open(SMimeUtils.createUnclosable(base64OutputStream), this.outEnc), base64OutputStream);
            }
            return new ContentOutputStream(this.envGen.open(SMimeUtils.createUnclosable(this.mimeOut), this.outEnc), null);
        }
        catch (CMSException cMSException) {
            throw new MimeIOException(cMSException.getMessage(), cMSException);
        }
    }

    public static class Builder {
        private static final String[] stdHeaders = new String[]{"Content-Type", "Content-Disposition", "Content-Transfer-Encoding", "Content-Description"};
        private static final String[] stdValues = new String[]{"application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data", "attachment; filename=\"smime.p7m\"", "base64", "S/MIME Encrypted Message"};
        private final CMSEnvelopedDataStreamGenerator envGen = new CMSEnvelopedDataStreamGenerator();
        private final Map<String, String> headers = new LinkedHashMap<String, String>();
        String contentTransferEncoding = "base64";

        public Builder() {
            for (int i = 0; i != stdHeaders.length; ++i) {
                this.headers.put(stdHeaders[i], stdValues[i]);
            }
        }

        public Builder setBufferSize(int n) {
            this.envGen.setBufferSize(n);
            return this;
        }

        public Builder setUnprotectedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
            this.envGen.setUnprotectedAttributeGenerator(cMSAttributeTableGenerator);
            return this;
        }

        public Builder setOriginatorInfo(OriginatorInformation originatorInformation) {
            this.envGen.setOriginatorInfo(originatorInformation);
            return this;
        }

        public Builder withHeader(String string2, String string3) {
            this.headers.put(string2, string3);
            return this;
        }

        public Builder addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) {
            this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
            return this;
        }

        public SMIMEEnvelopedWriter build(OutputStream outputStream, OutputEncryptor outputEncryptor) {
            return new SMIMEEnvelopedWriter(this, outputEncryptor, outputStream);
        }
    }

    private class ContentOutputStream
    extends OutputStream {
        private final OutputStream main;
        private final OutputStream backing;

        ContentOutputStream(OutputStream outputStream, OutputStream outputStream2) {
            this.main = outputStream;
            this.backing = outputStream2;
        }

        public void write(int n) throws IOException {
            this.main.write(n);
        }

        public void close() throws IOException {
            this.main.close();
            if (this.backing != null) {
                this.backing.close();
            }
        }
    }
}

