/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.text.Format;
import org.python.icu.impl.FormattedStringBuilder;
import org.python.icu.impl.number.Modifier;

public class ConstantAffixModifier
implements Modifier {
    public static final ConstantAffixModifier EMPTY = new ConstantAffixModifier();
    private final String prefix;
    private final String suffix;
    private final Format.Field field;
    private final boolean strong;

    public ConstantAffixModifier(String prefix, String suffix, Format.Field field, boolean strong) {
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
        this.field = field;
        this.strong = strong;
    }

    public ConstantAffixModifier() {
        this.prefix = "";
        this.suffix = "";
        this.field = null;
        this.strong = false;
    }

    public int apply(FormattedStringBuilder output2, int leftIndex, int rightIndex) {
        int length = output2.insert(rightIndex, this.suffix, this.field);
        return length += output2.insert(leftIndex, this.prefix, this.field);
    }

    public int getPrefixLength() {
        return this.prefix.length();
    }

    public int getCodePointCount() {
        return this.prefix.codePointCount(0, this.prefix.length()) + this.suffix.codePointCount(0, this.suffix.length());
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    public boolean containsField(Format.Field field) {
        assert (false);
        return false;
    }

    public Modifier.Parameters getParameters() {
        return null;
    }

    public boolean semanticallyEquivalent(Modifier other) {
        if (!(other instanceof ConstantAffixModifier)) {
            return false;
        }
        ConstantAffixModifier _other = (ConstantAffixModifier)other;
        return this.prefix.equals(_other.prefix) && this.suffix.equals(_other.suffix) && this.field == _other.field && this.strong == _other.strong;
    }

    public String toString() {
        return String.format("<ConstantAffixModifier prefix:'%s' suffix:'%s'>", this.prefix, this.suffix);
    }
}

