/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.util.ArrayList;
import java.util.List;
import org.python.icu.impl.FormattedStringBuilder;
import org.python.icu.impl.SimpleFormatterImpl;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.DecimalQuantity_DualStorageBCD;
import org.python.icu.impl.number.LongNameHandler;
import org.python.icu.impl.number.LongNameMultiplexer;
import org.python.icu.impl.number.MicroProps;
import org.python.icu.impl.number.MicroPropsGenerator;
import org.python.icu.impl.number.Modifier;
import org.python.icu.impl.number.ModifierStore;
import org.python.icu.impl.number.RoundingUtils;
import org.python.icu.impl.number.SimpleModifier;
import org.python.icu.number.LocalizedNumberFormatter;
import org.python.icu.number.NumberFormatter;
import org.python.icu.number.Precision;
import org.python.icu.text.ListFormatter;
import org.python.icu.text.PluralRules;
import org.python.icu.text.SimpleFormatter;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;

public class MixedUnitLongNameHandler
implements MicroPropsGenerator,
ModifierStore,
LongNameMultiplexer.ParentlessMicroPropsGenerator {
    private final PluralRules rules;
    private final MicroPropsGenerator parent;
    private List<String[]> fMixedUnitData;
    private LocalizedNumberFormatter fIntegerFormatter;
    private ListFormatter fListFormatter;

    private MixedUnitLongNameHandler(PluralRules rules, MicroPropsGenerator parent) {
        this.rules = rules;
        this.parent = parent;
    }

    public static MixedUnitLongNameHandler forMeasureUnit(ULocale locale2, MeasureUnit mixedUnit, NumberFormatter.UnitWidth width, String unitDisplayCase, PluralRules rules, MicroPropsGenerator parent) {
        assert (mixedUnit.getComplexity() == MeasureUnit.Complexity.MIXED) : "MixedUnitLongNameHandler only supports MIXED units";
        MixedUnitLongNameHandler result2 = new MixedUnitLongNameHandler(rules, parent);
        List individualUnits = mixedUnit.splitToSingleUnits();
        result2.fMixedUnitData = new ArrayList<String[]>();
        for (int i = 0; i < individualUnits.size(); ++i) {
            String[] unitData = new String[LongNameHandler.ARRAY_LENGTH];
            LongNameHandler.getMeasureData(locale2, (MeasureUnit)individualUnits.get(i), width, unitDisplayCase, unitData);
            result2.fMixedUnitData.add(unitData);
        }
        ListFormatter.Width listWidth = ListFormatter.Width.SHORT;
        if (width == NumberFormatter.UnitWidth.NARROW) {
            listWidth = ListFormatter.Width.NARROW;
        } else if (width == NumberFormatter.UnitWidth.FULL_NAME) {
            listWidth = ListFormatter.Width.WIDE;
        }
        result2.fListFormatter = ListFormatter.getInstance((ULocale)locale2, (ListFormatter.Type)ListFormatter.Type.UNITS, (ListFormatter.Width)listWidth);
        result2.fIntegerFormatter = NumberFormatter.withLocale(locale2);
        return result2;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        assert (this.fMixedUnitData.size() > 1);
        MicroProps micros = this.parent.processQuantity(quantity);
        micros.modOuter = this.getMixedUnitModifier(quantity, micros);
        return micros;
    }

    @Override
    public MicroProps processQuantityWithMicros(DecimalQuantity quantity, MicroProps micros) {
        assert (this.fMixedUnitData.size() > 1);
        micros.modOuter = this.getMixedUnitModifier(quantity, micros);
        return micros;
    }

    @Override
    public Modifier getModifier(Modifier.Signum signum, StandardPlural plural) {
        assert (false) : "should be unreachable";
        return null;
    }

    private Modifier getMixedUnitModifier(DecimalQuantity quantity, MicroProps micros) {
        if (micros.mixedMeasures.size() == 0) {
            assert (false) : "Mixed unit: we must have more than one unit value";
            throw new UnsupportedOperationException();
        }
        ArrayList<String> outputMeasuresList = new ArrayList<String>();
        StandardPlural quantityPlural = StandardPlural.OTHER;
        for (int i = 0; i < micros.mixedMeasures.size(); ++i) {
            if (i == micros.indexOfQuantity) {
                if (i > 0 && quantity.isNegative()) {
                    quantity.negate();
                }
                quantityPlural = RoundingUtils.getPluralSafe((Precision)micros.rounder, (PluralRules)this.rules, (DecimalQuantity)quantity);
                String quantitySimpleFormat = LongNameHandler.getWithPlural(this.fMixedUnitData.get(i), quantityPlural);
                SimpleFormatter finalFormatter = SimpleFormatter.compileMinMaxArguments(quantitySimpleFormat, 0, 1);
                outputMeasuresList.add(finalFormatter.format("{0}"));
                continue;
            }
            DecimalQuantity_DualStorageBCD fdec = new DecimalQuantity_DualStorageBCD(micros.mixedMeasures.get(i).getNumber());
            if (i > 0 && fdec.isNegative()) {
                fdec.negate();
            }
            StandardPlural pluralForm = RoundingUtils.getPluralSafe((Precision)micros.rounder, (PluralRules)this.rules, (DecimalQuantity)fdec);
            String simpleFormat = LongNameHandler.getWithPlural(this.fMixedUnitData.get(i), pluralForm);
            SimpleFormatter compiledFormatter = SimpleFormatter.compileMinMaxArguments(simpleFormat, 0, 1);
            FormattedStringBuilder appendable = new FormattedStringBuilder();
            this.fIntegerFormatter.formatImpl(fdec, appendable);
            outputMeasuresList.add(compiledFormatter.format(appendable.toString()));
        }
        String premixedFormatPattern = this.fListFormatter.format(outputMeasuresList);
        StringBuilder sb = new StringBuilder();
        String premixedCompiled = SimpleFormatterImpl.compileToStringMinMaxArguments(premixedFormatPattern, sb, 0, 1);
        Modifier.Parameters params = new Modifier.Parameters();
        params.obj = this;
        params.signum = Modifier.Signum.POS_ZERO;
        params.plural = quantityPlural;
        return new SimpleModifier(premixedCompiled, null, false, params);
    }
}

