/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.util.ArrayDeque;
import org.python.icu.impl.number.Modifier;
import org.python.icu.impl.number.NumberStringBuilder;

public class ModifierHolder {
    private ArrayDeque<Modifier> mods = new ArrayDeque();

    public ModifierHolder clear() {
        this.mods.clear();
        return this;
    }

    public void add(Modifier modifier2) {
        if (modifier2 != null) {
            this.mods.addFirst(modifier2);
        }
    }

    public Modifier peekLast() {
        return this.mods.peekLast();
    }

    public Modifier removeLast() {
        return this.mods.removeLast();
    }

    public int applyAll(NumberStringBuilder string2, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty()) {
            Modifier mod2 = this.mods.removeFirst();
            addedLength += mod2.apply(string2, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int applyStrong(NumberStringBuilder string2, int leftIndex, int rightIndex) {
        int addedLength = 0;
        while (!this.mods.isEmpty() && this.mods.peekFirst().isStrong()) {
            Modifier mod2 = this.mods.removeFirst();
            addedLength += mod2.apply(string2, leftIndex, rightIndex + addedLength);
        }
        return addedLength;
    }

    public int totalLength() {
        int length = 0;
        for (Modifier mod2 : this.mods) {
            if (mod2 == null) continue;
            length += mod2.length();
        }
        return length;
    }
}

