/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._json;

import org.python.core.AbstractDict;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyDataDescr;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._json.Encoder$__module___descriptor;
import org.python.modules._json.Encoder$exposed___new__;
import org.python.modules._json.EncoderDerived;

@ExposedType(name="_json.encoder", base=PyObject.class)
public class Encoder
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    public final String __module__ = "_json";
    final AbstractDict markers;
    final PyObject defaultfn;
    final PyObject encoder;
    final PyObject indent;
    final PyObject key_separator;
    final PyObject item_separator;
    final PyObject sort_keys;
    final boolean skipkeys;
    final boolean allow_nan;

    public Encoder(PyObject[] args, String[] kwds) {
        this(TYPE, args, kwds);
    }

    public Encoder(PyType subtype, PyObject[] args, String[] kwds) {
        super(subtype);
        ArgParser ap = new ArgParser("encoder", args, kwds, new String[]{"markers", "default", "encoder", "indent", "key_separator", "item_separator", "sort_keys", "skipkeys", "allow_nan"});
        ap.noKeywords();
        PyObject m = ap.getPyObject(0);
        this.markers = m == Py.None ? null : (AbstractDict)m;
        this.defaultfn = ap.getPyObject(1);
        this.encoder = ap.getPyObject(2);
        this.indent = ap.getPyObject(3);
        this.key_separator = ap.getPyObject(4);
        this.item_separator = ap.getPyObject(5);
        this.sort_keys = ap.getPyObject(6);
        this.skipkeys = ap.getPyObject(7).__nonzero__();
        this.allow_nan = ap.getPyObject(8).__nonzero__();
    }

    @ExposedNew
    static PyObject Encoder___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (subtype == TYPE) {
            return new Encoder(args, keywords);
        }
        return new EncoderDerived(subtype, args, keywords);
    }

    @Override
    public PyObject __call__(PyObject obj) {
        return this.__call__(obj, (PyObject)Py.Zero);
    }

    @Override
    public PyObject __call__(PyObject obj, PyObject indent_level) {
        PyList rval = new PyList();
        this.encode_obj(rval, obj, 0);
        return rval;
    }

    private PyString encode_float(PyObject obj) {
        double i = obj.asDouble();
        if (Double.isInfinite(i) || Double.isNaN(i)) {
            if (!this.allow_nan) {
                throw Py.ValueError("Out of range float values are not JSON compliant");
            }
            if (i == Double.POSITIVE_INFINITY) {
                return new PyString("Infinity");
            }
            if (i == Double.NEGATIVE_INFINITY) {
                return new PyString("-Infinity");
            }
            return new PyString("NaN");
        }
        return obj.__repr__();
    }

    private PyString encode_string(PyObject obj) {
        return (PyString)this.encoder.__call__(obj);
    }

    private PyObject checkCircularReference(PyObject obj) {
        PyObject ident = null;
        if (this.markers != null) {
            ident = Py.newInteger(Py.id(obj));
            if (this.markers.__contains__(ident)) {
                throw Py.ValueError("Circular reference detected");
            }
            this.markers.__setitem__(ident, obj);
        }
        return ident;
    }

    private void encode_obj(PyList rval, PyObject obj, int indent_level) {
        if (obj == Py.None) {
            rval.append(new PyString("null"));
        } else if (obj == Py.True) {
            rval.append(new PyString("true"));
        } else if (obj == Py.False) {
            rval.append(new PyString("false"));
        } else if (obj instanceof PyString) {
            rval.append(this.encode_string(obj));
        } else if (obj instanceof PyInteger || obj instanceof PyLong) {
            rval.append(obj.__str__());
        } else if (obj instanceof PyFloat) {
            rval.append(this.encode_float(obj));
        } else if (obj instanceof PyList || obj instanceof PyTuple) {
            this.encode_list(rval, obj, indent_level);
        } else if (obj instanceof AbstractDict) {
            this.encode_dict(rval, (AbstractDict)obj, indent_level);
        } else {
            PyObject ident = this.checkCircularReference(obj);
            if (this.defaultfn == Py.None) {
                throw Py.TypeError(String.format(".80s is not JSON serializable", obj.__repr__()));
            }
            PyObject newobj = this.defaultfn.__call__(obj);
            this.encode_obj(rval, newobj, indent_level);
            if (ident != null) {
                this.markers.__delitem__(ident);
            }
        }
    }

    private void encode_dict(PyList rval, AbstractDict dct, int indent_level) {
        if (dct.__len__() == 0) {
            rval.append(new PyString("{}"));
            return;
        }
        PyObject ident = this.checkCircularReference(dct);
        rval.append(new PyString("{"));
        int idx = 0;
        for (PyObject key : dct.asIterable()) {
            PyString kstr;
            if (key instanceof PyString || key instanceof PyUnicode) {
                kstr = (PyString)key;
            } else if (key instanceof PyFloat) {
                kstr = this.encode_float(key);
            } else if (key instanceof PyInteger || key instanceof PyLong) {
                kstr = key.__str__();
            } else if (key == Py.True) {
                kstr = new PyString("true");
            } else if (key == Py.False) {
                kstr = new PyString("false");
            } else if (key == Py.None) {
                kstr = new PyString("null");
            } else {
                if (this.skipkeys) continue;
                throw Py.TypeError(String.format("keys must be a string: %.80s", key.__repr__()));
            }
            if (idx > 0) {
                rval.append(this.item_separator);
            }
            PyObject value = dct.__getitem__(key);
            PyString encoded = this.encode_string(kstr);
            rval.append(encoded);
            rval.append(this.key_separator);
            this.encode_obj(rval, value, indent_level);
            ++idx;
        }
        if (ident != null) {
            this.markers.__delitem__(ident);
        }
        rval.append(new PyString("}"));
    }

    private void encode_list(PyList rval, PyObject seq, int indent_level) {
        PyObject ident = this.checkCircularReference(seq);
        rval.append(new PyString("["));
        int i = 0;
        for (PyObject obj : seq.asIterable()) {
            if (i > 0) {
                rval.append(this.item_separator);
            }
            this.encode_obj(rval, obj, indent_level);
            ++i;
        }
        if (ident != null) {
            this.markers.__delitem__(ident);
        }
        rval.append(new PyString("]"));
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.markers != null && (retVal = visit.visit(this.markers, arg)) != 0) {
            return retVal;
        }
        if (this.defaultfn != null && (retVal = visit.visit(this.defaultfn, arg)) != 0) {
            return retVal;
        }
        if (this.encoder != null && (retVal = visit.visit(this.encoder, arg)) != 0) {
            return retVal;
        }
        if (this.indent != null && (retVal = visit.visit(this.indent, arg)) != 0) {
            return retVal;
        }
        if (this.key_separator != null && (retVal = visit.visit(this.key_separator, arg)) != 0) {
            return retVal;
        }
        if (this.item_separator != null && (retVal = visit.visit(this.item_separator, arg)) != 0) {
            return retVal;
        }
        return this.sort_keys != null ? visit.visit(this.sort_keys, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.markers || ob == this.defaultfn || ob == this.encoder || ob == this.indent || ob == this.key_separator || ob == this.item_separator || ob == this.sort_keys);
    }

    static {
        PyType.addBuilder(Encoder.class, new Encoder$PyExposer());
        TYPE = PyType.fromClass(Encoder.class);
    }

    public class Encoder$PyExposer
    extends BaseTypeBuilder {
        public Encoder$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new Encoder$__module___descriptor()};
            super("_json.encoder", Encoder.class, PyObject.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new Encoder$exposed___new__());
        }
    }
}

