/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.python.netty.util.internal.Cleaner;
import org.python.netty.util.internal.PlatformDependent0;
import org.python.netty.util.internal.logging.InternalLogger;
import org.python.netty.util.internal.logging.InternalLoggerFactory;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, buffer);
            }
            catch (Throwable cause) {
                PlatformDependent0.throwException(cause);
            }
        } else {
            CleanerJava9.freeDirectBufferPrivileged(buffer);
        }
    }

    private static void freeDirectBufferPrivileged(final ByteBuffer buffer) {
        Exception error2 = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

            @Override
            public Exception run() {
                try {
                    INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, buffer);
                }
                catch (InvocationTargetException e) {
                    return e;
                }
                catch (IllegalAccessException e) {
                    return e;
                }
                return null;
            }
        });
        if (error2 != null) {
            PlatformDependent0.throwException(error2);
        }
    }

    static {
        Throwable error2;
        Method method;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            final ByteBuffer buffer = ByteBuffer.allocateDirect(1);
            Object maybeInvokeMethod = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Method m = PlatformDependent0.UNSAFE.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        m.invoke((Object)PlatformDependent0.UNSAFE, buffer);
                        return m;
                    }
                    catch (NoSuchMethodException e) {
                        return e;
                    }
                    catch (InvocationTargetException e) {
                        return e;
                    }
                    catch (IllegalAccessException e) {
                        return e;
                    }
                }
            });
            if (maybeInvokeMethod instanceof Throwable) {
                method = null;
                error2 = (Throwable)maybeInvokeMethod;
            } else {
                method = (Method)maybeInvokeMethod;
                error2 = null;
            }
        } else {
            method = null;
            error2 = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (error2 == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", error2);
        }
        INVOKE_CLEANER = method;
    }
}

