/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal.logging;

import org.python.netty.util.internal.logging.AbstractInternalLogger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

final class LocationAwareSlf4JLogger
extends AbstractInternalLogger {
    static final String FQCN = LocationAwareSlf4JLogger.class.getName();
    private static final long serialVersionUID = -8292030083201538180L;
    private final transient LocationAwareLogger logger;

    LocationAwareSlf4JLogger(LocationAwareLogger logger2) {
        super(logger2.getName());
        this.logger = logger2;
    }

    private void log(int level, String message2) {
        this.logger.log(null, FQCN, level, message2, null, null);
    }

    private void log(int level, String message2, Throwable cause) {
        this.logger.log(null, FQCN, level, message2, null, cause);
    }

    private void log(int level, FormattingTuple tuple) {
        this.logger.log(null, FQCN, level, tuple.getMessage(), tuple.getArgArray(), tuple.getThrowable());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg2) {
        if (this.isTraceEnabled()) {
            this.log(0, msg2);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    @Override
    public void trace(String format, Object argA, Object argB) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
        }
    }

    @Override
    public void trace(String format, Object ... argArray) {
        if (this.isTraceEnabled()) {
            this.log(0, MessageFormatter.arrayFormat((String)format, (Object[])argArray));
        }
    }

    @Override
    public void trace(String msg2, Throwable t) {
        if (this.isTraceEnabled()) {
            this.log(0, msg2, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg2) {
        if (this.isDebugEnabled()) {
            this.log(10, msg2);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    @Override
    public void debug(String format, Object argA, Object argB) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
        }
    }

    @Override
    public void debug(String format, Object ... argArray) {
        if (this.isDebugEnabled()) {
            this.log(10, MessageFormatter.arrayFormat((String)format, (Object[])argArray));
        }
    }

    @Override
    public void debug(String msg2, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(10, msg2, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg2) {
        if (this.isInfoEnabled()) {
            this.log(20, msg2);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    @Override
    public void info(String format, Object argA, Object argB) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
        }
    }

    @Override
    public void info(String format, Object ... argArray) {
        if (this.isInfoEnabled()) {
            this.log(20, MessageFormatter.arrayFormat((String)format, (Object[])argArray));
        }
    }

    @Override
    public void info(String msg2, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(20, msg2, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg2) {
        if (this.isWarnEnabled()) {
            this.log(30, msg2);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    @Override
    public void warn(String format, Object ... argArray) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.arrayFormat((String)format, (Object[])argArray));
        }
    }

    @Override
    public void warn(String format, Object argA, Object argB) {
        if (this.isWarnEnabled()) {
            this.log(30, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
        }
    }

    @Override
    public void warn(String msg2, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(30, msg2, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg2) {
        if (this.isErrorEnabled()) {
            this.log(40, msg2);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.format((String)format, (Object)arg));
        }
    }

    @Override
    public void error(String format, Object argA, Object argB) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
        }
    }

    @Override
    public void error(String format, Object ... argArray) {
        if (this.isErrorEnabled()) {
            this.log(40, MessageFormatter.arrayFormat((String)format, (Object[])argArray));
        }
    }

    @Override
    public void error(String msg2, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(40, msg2, t);
        }
    }
}

