/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.routebox.RouteboxEndpoint;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteboxServiceSupport
extends ServiceSupport {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ExceptionHandler exceptionHandler;
    private RouteboxEndpoint endpoint;
    private ExecutorService executor;
    private volatile boolean startedInnerContext;

    public RouteboxServiceSupport(RouteboxEndpoint endpoint) {
        this.endpoint = endpoint;
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(((Object)((Object)this)).getClass());
        }
    }

    protected void doStopInnerContext() throws Exception {
        CamelContext context = this.endpoint.getConfig().getInnerContext();
        context.stop();
        this.setStartedInnerContext(false);
    }

    protected void doStartInnerContext() throws Exception {
        CamelContext context = this.endpoint.getConfig().getInnerContext();
        List<RouteBuilder> routeBuildersList = this.endpoint.getConfig().getRouteBuilders();
        if (!routeBuildersList.isEmpty()) {
            for (RouteBuilder routeBuilder : routeBuildersList) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding RouteBuilder {} to {}", (Object)routeBuilder, (Object)context.getName());
                }
                context.addRoutes((RoutesBuilder)routeBuilder);
            }
        }
        context.start();
        this.setStartedInnerContext(true);
    }

    public RouteboxEndpoint getRouteboxEndpoint() {
        return this.endpoint;
    }

    public void setRouteboxEndpoint(RouteboxEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setStartedInnerContext(boolean startedInnerContext) {
        this.startedInnerContext = startedInnerContext;
    }

    public boolean isStartedInnerContext() {
        return this.startedInnerContext;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

