/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.routebox.RouteboxServiceSupport;
import org.apache.camel.component.routebox.direct.RouteboxDirectEndpoint;
import org.apache.camel.component.routebox.strategy.RouteboxDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteboxDirectProducer
extends RouteboxServiceSupport
implements Producer,
AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RouteboxDirectProducer.class);
    protected ProducerTemplate producer;

    public RouteboxDirectProducer(RouteboxDirectEndpoint endpoint) {
        super(endpoint);
        this.producer = endpoint.getConfig().getInnerProducerTemplate();
    }

    public void process(Exchange exchange) throws Exception {
        if (((RouteboxDirectEndpoint)this.getRouteboxEndpoint()).getConsumer() == null && this.getRouteboxEndpoint().getConfig().isSendToConsumer()) {
            throw new CamelExchangeException("No consumers available on endpoint: " + (Object)((Object)this.getRouteboxEndpoint()), exchange);
        }
        LOG.debug("Dispatching to Inner Route {}", (Object)exchange);
        RouteboxDispatcher dispatcher = new RouteboxDispatcher(this.producer);
        Exchange result = dispatcher.dispatchSync(this.getRouteboxEndpoint(), exchange);
        if (this.getRouteboxEndpoint().getConfig().isSendToConsumer()) {
            ((RouteboxDirectEndpoint)this.getRouteboxEndpoint()).getConsumer().getProcessor().process(result);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean flag = true;
        if (((RouteboxDirectEndpoint)this.getRouteboxEndpoint()).getConsumer() == null && this.getRouteboxEndpoint().getConfig().isSendToConsumer()) {
            exchange.setException((Throwable)new CamelExchangeException("No consumers available on endpoint: " + (Object)((Object)this.getRouteboxEndpoint()), exchange));
            callback.done(true);
            flag = true;
        } else {
            try {
                LOG.debug("Dispatching to Inner Route {}", (Object)exchange);
                RouteboxDispatcher dispatcher = new RouteboxDispatcher(this.producer);
                exchange = dispatcher.dispatchAsync(this.getRouteboxEndpoint(), exchange);
                if (this.getRouteboxEndpoint().getConfig().isSendToConsumer()) {
                    AsyncProcessor processor = ((RouteboxDirectEndpoint)this.getRouteboxEndpoint()).getConsumer().getAsyncProcessor();
                    flag = processor.process(exchange, callback);
                }
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }
        return flag;
    }

    protected void doStart() throws Exception {
        if (!this.getRouteboxEndpoint().getConfig().isSendToConsumer() && !this.isStartedInnerContext()) {
            this.doStartInnerContext();
        }
    }

    protected void doStop() throws Exception {
        if (!this.getRouteboxEndpoint().getConfig().isSendToConsumer() && this.isStartedInnerContext()) {
            this.doStopInnerContext();
        }
    }

    public Endpoint getEndpoint() {
        return this.getRouteboxEndpoint();
    }

    public Exchange createExchange() {
        return this.getRouteboxEndpoint().createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.getRouteboxEndpoint().createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.getRouteboxEndpoint().createExchange(exchange);
    }

    public boolean isSingleton() {
        return true;
    }

    public String toString() {
        return "Producer[" + this.getRouteboxEndpoint().getEndpointUri() + "]";
    }
}

