/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.IOException;
import java.util.Date;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.camel.Processor;
import org.apache.camel.component.atom.AtomEndpoint;
import org.apache.camel.component.atom.AtomUtils;
import org.apache.camel.component.atom.UpdatedDateFilter;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEntryPollingConsumer;
import org.apache.camel.util.ObjectHelper;

public class AtomEntryPollingConsumer
extends FeedEntryPollingConsumer {
    private Document<Feed> document;

    public AtomEntryPollingConsumer(AtomEndpoint endpoint, Processor processor, boolean filter, Date lastUpdate, boolean throttleEntries) {
        super(endpoint, processor, filter, lastUpdate, throttleEntries);
    }

    private Document<Feed> getDocument() throws IOException, ParseException {
        if (this.document == null) {
            this.document = ObjectHelper.isEmpty((Object)this.endpoint.getUsername()) || ObjectHelper.isEmpty((Object)this.endpoint.getPassword()) ? AtomUtils.parseDocument(this.endpoint.getFeedUri()) : AtomUtils.parseDocument(this.endpoint.getFeedUri(), this.endpoint.getUsername(), this.endpoint.getPassword());
            Feed root = this.document.getRoot();
            if (this.endpoint.isSortEntries()) {
                this.sortEntries(root);
            }
            this.list = root.getEntries();
            this.entryIndex = this.list.size() - 1;
        }
        return this.document;
    }

    protected void sortEntries(Feed feed) {
        feed.sortEntriesByUpdated(true);
    }

    @Override
    protected void populateList(Object feed) throws ParseException, IOException {
    }

    @Override
    protected Object createFeed() throws IOException {
        return this.getDocument().getRoot();
    }

    @Override
    protected void resetList() {
        this.document = null;
    }

    @Override
    protected EntryFilter createEntryFilter(Date lastUpdate) {
        return new UpdatedDateFilter(lastUpdate);
    }
}

