/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.rss.RssEndpoint;
import org.apache.camel.util.URISupport;

public class RssComponent
extends FeedComponent {
    public RssComponent() {
        super(RssEndpoint.class);
    }

    @Override
    protected FeedEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new RssEndpoint(uri, this, null);
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        String feedUri;
        RssEndpoint rss = (RssEndpoint)endpoint;
        if (rss.getFeedUri() != null) {
            return;
        }
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>(parameters);
            String query = URISupport.createQueryString(options);
            feedUri = remaining + "?" + query;
        } else {
            feedUri = remaining;
        }
        rss.setFeedUri(feedUri);
    }
}

