/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRssFeedStrategy
implements AggregationStrategy {
    protected final Logger log = LoggerFactory.getLogger(AggregateRssFeedStrategy.class);

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        SyndFeed oldFeed = oldExchange.getIn().getBody(SyndFeed.class);
        SyndFeed newFeed = newExchange.getIn().getBody(SyndFeed.class);
        if (oldFeed != null && newFeed != null) {
            List oldEntries = CastUtils.cast(oldFeed.getEntries());
            List newEntries = CastUtils.cast(newFeed.getEntries());
            ArrayList<SyndEntry> mergedList = new ArrayList<SyndEntry>(oldEntries.size() + newEntries.size());
            mergedList.addAll(oldEntries);
            mergedList.addAll(newEntries);
            oldFeed.setEntries(mergedList);
        } else {
            this.log.debug("Could not merge exchanges. One body was null.");
        }
        return oldExchange;
    }
}

