/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;

public final class RssUtils {
    private RssUtils() {
    }

    public static SyndFeed createFeed(String feedUri) throws Exception {
        return RssUtils.createFeed(feedUri, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            SyndFeed syndFeed = RssUtils.createSyndFeed(feedUri);
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private static SyndFeed createSyndFeed(String feedUri) throws IOException, FeedException {
        try (XmlReader reader = new XmlReader(new URL(feedUri));){
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build(reader);
            return syndFeed;
        }
    }

    public static SyndFeed createFeed(String feedUri, String username, String password) throws Exception {
        return RssUtils.createFeed(feedUri, username, password, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, String username, String password, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            URL feedUrl = new URL(feedUri);
            HttpURLConnection httpcon = (HttpURLConnection)feedUrl.openConnection();
            String encoding = Base64.encodeBase64String((byte[])username.concat(":").concat(password).getBytes());
            httpcon.setRequestProperty("Authorization", "Basic " + encoding);
            SyndFeed syndFeed = RssUtils.createSyndFeed(httpcon);
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private static SyndFeed createSyndFeed(HttpURLConnection connection) throws IOException, FeedException {
        try (XmlReader reader = new XmlReader(connection);){
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build(reader);
            return syndFeed;
        }
    }
}

