/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.commons.codec.binary.Base64;

public final class AtomUtils {
    private AtomUtils() {
    }

    public static Parser getAtomParser() {
        return Abdera.getInstance().getParser();
    }

    public static Document<Feed> parseDocument(String uri) throws IOException, ParseException {
        URL feedUrl = new URL(uri);
        URLConnection urlConn = feedUrl.openConnection();
        urlConn.setConnectTimeout(60000);
        urlConn.setReadTimeout(60000);
        InputStream in = urlConn.getInputStream();
        return AtomUtils.parseInputStream(in);
    }

    public static Document<Feed> parseDocument(String uri, String username, String password) throws IOException {
        URL feedUrl = new URL(uri);
        HttpURLConnection httpcon = (HttpURLConnection)feedUrl.openConnection();
        httpcon.setConnectTimeout(60000);
        httpcon.setReadTimeout(60000);
        String encoding = Base64.encodeBase64String((byte[])username.concat(":").concat(password).getBytes());
        httpcon.setRequestProperty("Authorization", "Basic " + encoding);
        InputStream in = httpcon.getInputStream();
        return AtomUtils.parseInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document<Feed> parseInputStream(InputStream in) throws ParseException {
        Parser parser = AtomUtils.getAtomParser();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(parser.getClass().getClassLoader());
            Document<Feed> document = parser.parse(in);
            return document;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

