/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.rometools.rome.feed.synd.SyndFeed;
import java.util.Collections;
import org.apache.camel.Processor;
import org.apache.camel.component.feed.FeedEntryPollingConsumer;
import org.apache.camel.component.rss.RssDateComparator;
import org.apache.camel.component.rss.RssEndpoint;
import org.apache.camel.component.rss.RssUtils;
import org.apache.camel.util.ObjectHelper;

public class RssEntryPollingConsumer
extends FeedEntryPollingConsumer {
    public RssEntryPollingConsumer(RssEndpoint endpoint, Processor processor, boolean throttleEntries) {
        super(endpoint, processor, throttleEntries);
    }

    @Override
    protected void populateList(Object feed) {
        if (this.list == null) {
            this.list = ((SyndFeed)feed).getEntries();
            if (this.endpoint.isSortEntries()) {
                this.sortEntries();
            }
            this.entryIndex = this.list.size() - 1;
        }
    }

    protected void sortEntries() {
        Collections.sort(this.list, new RssDateComparator());
    }

    @Override
    protected Object createFeed() throws Exception {
        if (ObjectHelper.isEmpty(this.endpoint.getUsername()) || ObjectHelper.isEmpty(this.endpoint.getPassword())) {
            return RssUtils.createFeed(this.endpoint.getFeedUri(), RssEntryPollingConsumer.class.getClassLoader());
        }
        return RssUtils.createFeed(this.endpoint.getFeedUri(), this.endpoint.getUsername(), this.endpoint.getPassword(), RssEntryPollingConsumer.class.getClassLoader());
    }

    @Override
    protected void resetList() {
        this.list = null;
    }
}

