/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.rss;

import com.rometools.rome.feed.synd.SyndFeed;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.rss.RssConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="rss")
public class RssDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    @Override
    public String getDataFormatName() {
        return "rss";
    }

    @Override
    public void marshal(Exchange exchange, Object body, OutputStream out) throws Exception {
        SyndFeed feed = ExchangeHelper.convertToMandatoryType(exchange, SyndFeed.class, body);
        String xml = RssConverter.feedToXml(feed);
        out.write(xml.getBytes());
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream in) throws Exception {
        String xml = ExchangeHelper.convertToMandatoryType(exchange, String.class, in);
        return RssConverter.xmlToFeed(xml);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

