/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;

public class ObserverSender<T>
implements Observer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverSender.class);
    private Producer producer;

    public ObserverSender(Endpoint endpoint) throws Exception {
        this.producer = new UnitOfWorkProducer(endpoint.createProducer());
        ServiceHelper.startService((Service)this.producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.producer != null) {
            try {
                ServiceHelper.stopService((Object)this.producer);
            }
            catch (Exception e) {
                LOG.warn("Error stopping producer: " + this.producer + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
            finally {
                this.producer = null;
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Exchange exchange = this.producer.createExchange();
        exchange.setException(e);
        this.send(exchange);
    }

    @Override
    public void onNext(T o) {
        Exchange exchange = this.producer.createExchange();
        exchange.getIn().setBody(o);
        this.send(exchange);
    }

    protected void send(Exchange exchange) {
        try {
            this.producer.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }
}

