/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import rx.Observer;
import rx.functions.Func1;

public class ProcessorToObserver<T>
implements Processor {
    private final Func1<Exchange, T> func;
    private final Observer<? super T> observer;

    public ProcessorToObserver(Func1<Exchange, T> func, Observer<? super T> observer) {
        this.func = func;
        this.observer = observer;
    }

    public void process(Exchange exchange) throws Exception {
        Exception exception = null;
        if (exchange.isFailed()) {
            exception = exchange.getException();
        }
        if (exception != null) {
            this.observer.onError(exception);
        } else {
            T value = this.func.call(exchange);
            this.observer.onNext(value);
        }
    }
}

