/*
 * Decompiled with CFR 0.152.
 */
package rx.plugins;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import rx.plugins.RxJavaErrorHandler;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaObservableExecutionHookDefault;
import rx.plugins.RxJavaSchedulersHook;
import rx.plugins.RxJavaSingleExecutionHook;
import rx.plugins.RxJavaSingleExecutionHookDefault;

public class RxJavaPlugins {
    private static final RxJavaPlugins INSTANCE = new RxJavaPlugins();
    private final AtomicReference<RxJavaErrorHandler> errorHandler = new AtomicReference();
    private final AtomicReference<RxJavaObservableExecutionHook> observableExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSingleExecutionHook> singleExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSchedulersHook> schedulersHook = new AtomicReference();
    static final RxJavaErrorHandler DEFAULT_ERROR_HANDLER = new RxJavaErrorHandler(){};

    public static RxJavaPlugins getInstance() {
        return INSTANCE;
    }

    RxJavaPlugins() {
    }

    void reset() {
        RxJavaPlugins.INSTANCE.errorHandler.set(null);
        RxJavaPlugins.INSTANCE.observableExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.singleExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.schedulersHook.set(null);
    }

    public RxJavaErrorHandler getErrorHandler() {
        if (this.errorHandler.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaErrorHandler.class, System.getProperties());
            if (impl == null) {
                this.errorHandler.compareAndSet(null, DEFAULT_ERROR_HANDLER);
            } else {
                this.errorHandler.compareAndSet(null, (RxJavaErrorHandler)impl);
            }
        }
        return this.errorHandler.get();
    }

    public void registerErrorHandler(RxJavaErrorHandler impl) {
        if (!this.errorHandler.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.errorHandler.get());
        }
    }

    public RxJavaObservableExecutionHook getObservableExecutionHook() {
        if (this.observableExecutionHook.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaObservableExecutionHook.class, System.getProperties());
            if (impl == null) {
                this.observableExecutionHook.compareAndSet(null, RxJavaObservableExecutionHookDefault.getInstance());
            } else {
                this.observableExecutionHook.compareAndSet(null, (RxJavaObservableExecutionHook)impl);
            }
        }
        return this.observableExecutionHook.get();
    }

    public void registerObservableExecutionHook(RxJavaObservableExecutionHook impl) {
        if (!this.observableExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.observableExecutionHook.get());
        }
    }

    public RxJavaSingleExecutionHook getSingleExecutionHook() {
        if (this.singleExecutionHook.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSingleExecutionHook.class, System.getProperties());
            if (impl == null) {
                this.singleExecutionHook.compareAndSet(null, RxJavaSingleExecutionHookDefault.getInstance());
            } else {
                this.singleExecutionHook.compareAndSet(null, (RxJavaSingleExecutionHook)impl);
            }
        }
        return this.singleExecutionHook.get();
    }

    public void registerSingleExecutionHook(RxJavaSingleExecutionHook impl) {
        if (!this.singleExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.singleExecutionHook.get());
        }
    }

    static Object getPluginImplementationViaProperty(Class<?> pluginClass, Properties props) {
        String classSimpleName = pluginClass.getSimpleName();
        String pluginPrefix = "rxjava.plugin.";
        String defaultKey = "rxjava.plugin." + classSimpleName + ".implementation";
        String implementingClass = props.getProperty(defaultKey);
        if (implementingClass == null) {
            String classSuffix = ".class";
            String implSuffix = ".impl";
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String value;
                String key = e.getKey().toString();
                if (!key.startsWith("rxjava.plugin.") || !key.endsWith(".class") || !classSimpleName.equals(value = e.getValue().toString())) continue;
                String index = key.substring(0, key.length() - ".class".length()).substring("rxjava.plugin.".length());
                String implKey = "rxjava.plugin." + index + ".impl";
                implementingClass = props.getProperty(implKey);
                if (implementingClass != null) break;
                throw new RuntimeException("Implementing class declaration for " + classSimpleName + " missing: " + implKey);
            }
        }
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(classSimpleName + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }

    public RxJavaSchedulersHook getSchedulersHook() {
        if (this.schedulersHook.get() == null) {
            Object impl = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSchedulersHook.class, System.getProperties());
            if (impl == null) {
                this.schedulersHook.compareAndSet(null, RxJavaSchedulersHook.getDefaultInstance());
            } else {
                this.schedulersHook.compareAndSet(null, (RxJavaSchedulersHook)impl);
            }
        }
        return this.schedulersHook.get();
    }

    public void registerSchedulersHook(RxJavaSchedulersHook impl) {
        if (!this.schedulersHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.schedulersHook.get());
        }
    }
}

