/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.StringHelper;

public class EnvPropertiesFunction
implements PropertiesFunction {
    @Override
    public String getName() {
        return "env";
    }

    @Override
    public String apply(String remainder) {
        String value;
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = StringHelper.before(remainder, ":");
            defaultValue = StringHelper.after(remainder, ":");
        }
        if ((value = System.getenv(key = key.toUpperCase())) == null) {
            String noDashKey = key.replace('-', '_');
            value = System.getenv(noDashKey);
        }
        return value != null ? value : defaultValue;
    }
}

