/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStreamsConsumer.class);
    private final ReactiveStreamsEndpoint endpoint;
    private final CamelReactiveStreamsService service;
    private ExecutorService executor;

    public ReactiveStreamsConsumer(ReactiveStreamsEndpoint endpoint, Processor processor, CamelReactiveStreamsService service) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.service = ObjectHelper.notNull(service, "service");
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        int poolSize = this.endpoint.getConcurrentConsumers();
        if (this.executor == null) {
            this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, this.getEndpoint().getEndpointUri(), poolSize);
        }
        this.service.attachCamelConsumer(this.endpoint.getStream(), this);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.service.detachCamelConsumer(this.endpoint.getStream());
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.getIn().setHeader("CamelReactiveStreamsEventType", "onNext");
        return this.doSend(exchange, callback);
    }

    public void onComplete() {
        if (this.endpoint.isForwardOnComplete()) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelReactiveStreamsEventType", "onComplete");
            this.doSend(exchange, done -> {});
        }
    }

    public void onError(Throwable error) {
        if (this.endpoint.isForwardOnError()) {
            Exchange exchange = this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelReactiveStreamsEventType", "onError");
            exchange.getIn().setBody(error);
            this.doSend(exchange, done -> {});
        }
    }

    private boolean doSend(Exchange exchange, AsyncCallback callback) {
        ExecutorService executorService = this.executor;
        if (executorService != null && this.isRunAllowed()) {
            executorService.execute(() -> this.getAsyncProcessor().process(exchange, doneSync -> {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                }
                callback.done(doneSync);
            }));
            return false;
        }
        LOG.warn("Consumer not ready to process exchanges. The exchange {} will be discarded", (Object)exchange);
        callback.done(true);
        return true;
    }

    @Override
    public ReactiveStreamsEndpoint getEndpoint() {
        return this.endpoint;
    }
}

