/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsServiceFactory;
import org.apache.camel.component.reactive.streams.api.DispatchCallback;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.ObjectHelper;

public final class ReactiveStreamsHelper {
    private ReactiveStreamsHelper() {
    }

    public static DispatchCallback<Exchange> getCallback(Exchange exchange) {
        return exchange.getIn().getHeader("CamelReactiveStreamsCallback", DispatchCallback.class);
    }

    public static DispatchCallback<Exchange> attachCallback(Exchange exchange, DispatchCallback<Exchange> callback) {
        exchange.getIn().setHeader("CamelReactiveStreamsCallback", callback);
        return callback;
    }

    public static DispatchCallback<Exchange> detachCallback(Exchange exchange) {
        DispatchCallback<Exchange> callback = ReactiveStreamsHelper.getCallback(exchange);
        if (callback != null) {
            exchange.getIn().removeHeader("CamelReactiveStreamsCallback");
        }
        return callback;
    }

    public static boolean invokeDispatchCallback(Exchange exchange) {
        return ReactiveStreamsHelper.invokeDispatchCallback(exchange, null);
    }

    public static boolean invokeDispatchCallback(Exchange exchange, Throwable error) {
        DispatchCallback<Exchange> callback = ReactiveStreamsHelper.getCallback(exchange);
        if (callback != null) {
            callback.processed(exchange, error);
            return true;
        }
        return false;
    }

    public static Exchange convertToExchange(CamelContext context, Object data) {
        Exchange exchange;
        if (data instanceof Exchange) {
            exchange = (Exchange)data;
        } else {
            exchange = new DefaultExchange(context);
            exchange.setPattern(ExchangePattern.InOut);
            exchange.getIn().setBody(data);
        }
        return exchange;
    }

    public static <T> T findInstance(CamelContext context, String name, Class<T> type) {
        return ObjectHelper.isEmpty(name) ? CamelContextHelper.findByType(context, type) : CamelContextHelper.lookup(context, name, type);
    }

    public static CamelReactiveStreamsService resolveReactiveStreamsService(CamelContext context, String serviceType, ReactiveStreamsEngineConfiguration configuration) {
        CamelReactiveStreamsService service = ReactiveStreamsHelper.findInstance(context, serviceType, CamelReactiveStreamsService.class);
        if (service != null) {
            return service;
        }
        CamelReactiveStreamsServiceFactory factory = ReactiveStreamsHelper.findInstance(context, serviceType, CamelReactiveStreamsServiceFactory.class);
        if (factory == null) {
            factory = ReactiveStreamsHelper.resolveServiceFactory(context, serviceType != null ? serviceType : "default-service");
        }
        return factory.newInstance(context, configuration);
    }

    public static CamelReactiveStreamsServiceFactory resolveServiceFactory(CamelContext context, String serviceType) {
        try {
            FactoryFinder finder = context.adapt(ExtendedCamelContext.class).getFactoryFinder("META-INF/services/org/apache/camel/reactive-streams/");
            Class serviceClass = finder.findClass(serviceType).orElse(null);
            if (serviceClass != null) {
                return (CamelReactiveStreamsServiceFactory)context.getInjector().newInstance(serviceClass);
            }
            throw new IllegalStateException("Class referenced in 'META-INF/services/org/apache/camel/reactive-streams/" + serviceType + "' not found");
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create the reactive stream service defined in 'META-INF/services/org/apache/camel/reactive-streams/" + serviceType + "'", e);
        }
    }
}

