/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedMonoPublisher<T>
implements Publisher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedMonoPublisher.class);
    private final ExecutorService workerPool;
    private final List<MonoSubscription> subscriptions = new CopyOnWriteArrayList<MonoSubscription>();
    private final AtomicBoolean flushing = new AtomicBoolean();
    private volatile T data;
    private volatile Throwable exception;

    public DelayedMonoPublisher(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        MonoSubscription sub = new MonoSubscription(subscriber);
        this.subscriptions.add(sub);
        subscriber.onSubscribe(sub);
        this.flushCycle();
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        Objects.requireNonNull(data, "data must be not null");
        if (this.data != null) {
            throw new IllegalStateException("data has already been set");
        }
        if (this.exception != null) {
            throw new IllegalStateException("an exception has already been set");
        }
        this.data = data;
        this.flushCycle();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        Objects.requireNonNull(exception, "exception must be not null");
        if (this.data != null) {
            throw new IllegalStateException("data has already been set");
        }
        if (this.exception != null) {
            throw new IllegalStateException("an exception has already been set");
        }
        this.exception = exception;
        this.flushCycle();
    }

    private void flushCycle() {
        boolean notRunning = this.flushing.compareAndSet(false, true);
        if (notRunning) {
            this.workerPool.execute(() -> {
                try {
                    LinkedList<MonoSubscription> completed = new LinkedList<MonoSubscription>();
                    for (MonoSubscription sub : this.subscriptions) {
                        sub.flush();
                        if (!sub.isTerminated()) continue;
                        completed.add(sub);
                    }
                    this.subscriptions.removeAll(completed);
                }
                finally {
                    this.flushing.set(false);
                }
                boolean runAgain = false;
                for (MonoSubscription sub : this.subscriptions) {
                    if (!sub.isReady()) continue;
                    runAgain = true;
                    break;
                }
                if (runAgain) {
                    this.flushCycle();
                }
            });
        }
    }

    private final class MonoSubscription
    implements Subscription {
        private volatile boolean terminated;
        private volatile boolean requested;
        private final Subscriber<? super T> subscriber;

        private MonoSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long l) {
            MonoSubscription monoSubscription = this;
            synchronized (monoSubscription) {
                if (this.terminated) {
                    return;
                }
            }
            if (l <= 0L) {
                this.subscriber.onError(new IllegalArgumentException("3.9"));
                monoSubscription = this;
                synchronized (monoSubscription) {
                    this.terminated = true;
                }
            }
            monoSubscription = this;
            synchronized (monoSubscription) {
                this.requested = true;
            }
            DelayedMonoPublisher.this.flushCycle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            MonoSubscription monoSubscription = this;
            synchronized (monoSubscription) {
                if (!this.isReady()) {
                    return;
                }
                this.terminated = true;
            }
            if (DelayedMonoPublisher.this.data != null) {
                this.subscriber.onNext(DelayedMonoPublisher.this.data);
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(DelayedMonoPublisher.this.exception);
            }
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public boolean isReady() {
            return !this.terminated && this.requested && (DelayedMonoPublisher.this.data != null || DelayedMonoPublisher.this.exception != null);
        }

        @Override
        public synchronized void cancel() {
            this.terminated = true;
        }
    }
}

