/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MonoPublisher<T>
implements Publisher<T> {
    private final T item;

    public MonoPublisher(T item) {
        this.item = item;
    }

    @Override
    public void subscribe(final Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        subscriber.onSubscribe(new Subscription(){
            private boolean terminated;

            @Override
            public void request(long l) {
                if (this.terminated) {
                    return;
                }
                this.terminated = true;
                if (l <= 0L) {
                    subscriber.onError(new IllegalArgumentException("3.9"));
                } else {
                    subscriber.onNext(MonoPublisher.this.item);
                    subscriber.onComplete();
                }
            }

            @Override
            public void cancel() {
                this.terminated = true;
            }
        });
    }
}

