/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"expression", "correlationExpression"})
public class ThrottleDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<ThrottleDefinition> {
    @XmlElement(name="correlationExpression")
    private ExpressionSubElementDefinition correlationExpression;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String timePeriodMillis;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String asyncDelayed;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String callerRunsWhenRejected;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String rejectExecution;

    public ThrottleDefinition() {
    }

    public ThrottleDefinition(Expression maximumRequestsPerPeriod) {
        super(maximumRequestsPerPeriod);
    }

    public ThrottleDefinition(Expression maximumRequestsPerPeriod, Expression correlationExpression) {
        this(ExpressionNodeHelper.toExpressionDefinition(maximumRequestsPerPeriod), correlationExpression);
    }

    private ThrottleDefinition(ExpressionDefinition maximumRequestsPerPeriod, Expression correlationExpression) {
        super(maximumRequestsPerPeriod);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
    }

    public String toString() {
        return "Throttle[" + this.description() + "]";
    }

    protected String description() {
        return this.getExpression() + " request per " + this.getTimePeriodMillis() + " millis";
    }

    @Override
    public String getShortName() {
        return "throttle";
    }

    @Override
    public String getLabel() {
        return "throttle[" + this.description() + "]";
    }

    public ThrottleDefinition timePeriodMillis(long timePeriodMillis) {
        return this.timePeriodMillis(Long.toString(timePeriodMillis));
    }

    public ThrottleDefinition timePeriodMillis(String timePeriodMillis) {
        this.setTimePeriodMillis(timePeriodMillis);
        return this;
    }

    public ThrottleDefinition maximumRequestsPerPeriod(long maximumRequestsPerPeriod) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression(maximumRequestsPerPeriod)));
        return this;
    }

    public ThrottleDefinition maximumRequestsPerPeriod(String maximumRequestsPerPeriod) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.simpleExpression(maximumRequestsPerPeriod)));
        return this;
    }

    public ThrottleDefinition correlationExpression(long correlationExpression) {
        return this.correlationExpression(ExpressionBuilder.constantExpression(correlationExpression));
    }

    public ThrottleDefinition correlationExpression(Expression correlationExpression) {
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
        return this;
    }

    public ThrottleDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        return this.callerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
    }

    public ThrottleDefinition callerRunsWhenRejected(String callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThrottleDefinition asyncDelayed() {
        return this.asyncDelayed(true);
    }

    public ThrottleDefinition asyncDelayed(boolean asyncDelayed) {
        return this.asyncDelayed(Boolean.toString(asyncDelayed));
    }

    public ThrottleDefinition asyncDelayed(String asyncDelayed) {
        this.setAsyncDelayed(asyncDelayed);
        return this;
    }

    public ThrottleDefinition rejectExecution(boolean rejectExecution) {
        return this.rejectExecution(Boolean.toString(rejectExecution));
    }

    public ThrottleDefinition rejectExecution(String rejectExecution) {
        this.setRejectExecution(rejectExecution);
        return this;
    }

    @Override
    public ThrottleDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ThrottleDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(String timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    public String getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(String asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public String getRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(String rejectExecution) {
        this.rejectExecution = rejectExecution;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }
}

