/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.streaming.PushTopicHelper;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ServiceHelper;
import org.codehaus.jackson.map.ObjectMapper;
import org.cometd.bayeux.client.ClientSessionChannel;

public class SalesforceConsumer
extends DefaultConsumer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EVENT_PROPERTY = "event";
    private static final String TYPE_PROPERTY = "type";
    private static final String CREATED_DATE_PROPERTY = "createdDate";
    private static final String SOBJECT_PROPERTY = "sobject";
    private static final double MINIMUM_VERSION = 24.0;
    private final SalesforceEndpoint endpoint;
    private final SubscriptionHelper subscriptionHelper;
    private final String topicName;
    private final Class<?> sObjectClass;
    private boolean subscribed;

    public SalesforceConsumer(SalesforceEndpoint endpoint, Processor processor, SubscriptionHelper helper) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        if (Double.valueOf(endpoint.getConfiguration().getApiVersion()) < 24.0) {
            throw new IllegalArgumentException("Minimum supported API version for consumer endpoints is 24.0");
        }
        this.topicName = endpoint.getTopicName();
        this.subscriptionHelper = helper;
        String sObjectName = endpoint.getConfiguration().getSObjectName();
        if (sObjectName != null) {
            this.sObjectClass = endpoint.getComponent().getClassMap().get(sObjectName);
            if (this.sObjectClass == null) {
                throw new IllegalArgumentException(String.format("SObject Class not found for %s", sObjectName));
            }
        } else {
            String className = endpoint.getConfiguration().getSObjectClass();
            if (className != null) {
                this.sObjectClass = endpoint.getComponent().getCamelContext().getClassResolver().resolveClass(className);
                if (this.sObjectClass == null) {
                    throw new IllegalArgumentException(String.format("SObject Class not found %s", className));
                }
            } else {
                this.log.warn("Property sObjectName or sObjectClass NOT set, messages will be of type java.lang.Map");
                this.sObjectClass = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        SalesforceEndpointConfig config = this.endpoint.getConfiguration();
        if (config.getSObjectQuery() != null) {
            SalesforceComponent component = this.endpoint.getComponent();
            DefaultRestClient restClient = new DefaultRestClient(component.getConfig().getHttpClient(), this.endpoint.getConfiguration().getApiVersion(), this.endpoint.getConfiguration().getFormat(), component.getSession());
            ServiceHelper.startService((Object)restClient);
            try {
                PushTopicHelper helper = new PushTopicHelper(config, this.topicName, restClient);
                helper.createOrUpdateTopic();
            }
            finally {
                ServiceHelper.stopService((Object)restClient);
            }
        }
        this.subscriptionHelper.subscribe(this.topicName, this);
        this.subscribed = true;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.subscribed) {
            this.subscribed = false;
            this.subscriptionHelper.unsubscribe(this.topicName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(ClientSessionChannel channel, org.cometd.bayeux.Message message) {
        String msg;
        Exchange exchange = this.endpoint.createExchange();
        Message in = exchange.getIn();
        this.setHeaders(in, message);
        Map<String, Object> data = message.getDataAsMap();
        Map event = (Map)data.get(EVENT_PROPERTY);
        final Object eventType = event.get(TYPE_PROPERTY);
        Object createdDate = event.get(CREATED_DATE_PROPERTY);
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Received event %s on channel %s created on %s", eventType, channel.getChannelId(), createdDate));
        }
        in.setHeader("CamelSalesforceEventType", eventType);
        in.setHeader("CamelSalesforceCreatedDate", createdDate);
        Map sObject = (Map)data.get(SOBJECT_PROPERTY);
        try {
            String sObjectString = OBJECT_MAPPER.writeValueAsString(sObject);
            this.log.debug("Received SObject: {}", (Object)sObjectString);
            if (this.sObjectClass == null) {
                in.setBody((Object)sObject);
            } else {
                in.setBody(OBJECT_MAPPER.readValue((Reader)new StringReader(sObjectString), this.sObjectClass));
            }
        }
        catch (IOException e) {
            msg = String.format("Error parsing message [%s] from Topic %s: %s", message, this.topicName, e.getMessage());
            this.handleException(msg, (Throwable)((Object)new SalesforceException(msg, e)));
        }
        try {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (SalesforceConsumer.this.log.isTraceEnabled()) {
                        SalesforceConsumer.this.log.trace("Done processing event: {} {}", (Object)eventType.toString(), (Object)(doneSync ? "synchronously" : "asynchronously"));
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                msg = String.format("Error processing %s: %s", exchange, e);
                this.handleException(msg, (Throwable)((Object)new SalesforceException(msg, e)));
            }
            catch (Throwable throwable) {
                Exception ex = exchange.getException();
                if (ex != null) {
                    String msg2 = String.format("Unhandled exception: %s", ex.getMessage());
                    this.handleException(msg2, (Throwable)((Object)new SalesforceException(msg2, ex)));
                }
                throw throwable;
            }
            Exception ex = exchange.getException();
            if (ex != null) {
                msg = String.format("Unhandled exception: %s", ex.getMessage());
                this.handleException(msg, (Throwable)((Object)new SalesforceException(msg, ex)));
            }
        }
        Exception ex = exchange.getException();
        if (ex != null) {
            msg = String.format("Unhandled exception: %s", ex.getMessage());
            this.handleException(msg, (Throwable)((Object)new SalesforceException(msg, ex)));
        }
    }

    private void setHeaders(Message in, org.cometd.bayeux.Message message) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelSalesforceTopicName", this.topicName);
        headers.put("CamelSalesforceChannel", message.getChannel());
        headers.put("CamelSalesforceClientId", message.getClientId());
        in.setHeaders(headers);
    }

    public void handleException(String message, Throwable t) {
        super.handleException(message, t);
    }

    public String getTopicName() {
        return this.topicName;
    }
}

