/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualDeserializer;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;

public class MultiSelectPicklistDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer<Object> {
    private static final String FACTORY_METHOD = "fromValue";
    private final Class<? extends Enum> enumClass;
    private final Method factoryMethod;

    public MultiSelectPicklistDeserializer() {
        this.enumClass = null;
        this.factoryMethod = null;
    }

    public MultiSelectPicklistDeserializer(Class<? extends Enum> enumClass) throws JsonMappingException {
        this.enumClass = enumClass;
        try {
            this.factoryMethod = enumClass.getMethod(FACTORY_METHOD, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new JsonMappingException("Invalid pick-list enum class " + enumClass.getName(), e);
        }
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (this.enumClass == null) {
            throw new JsonMappingException("Unable to parse unknown pick-list type");
        }
        String listValue = jp.getText();
        try {
            String[] value = listValue.split(";");
            int length = value.length;
            Object resultArray = Array.newInstance(this.enumClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(resultArray, i, this.factoryMethod.invoke(null, value[i].trim()));
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new JsonParseException("Exception reading multi-select pick list value", jp.getCurrentLocation(), e);
        }
    }

    @Override
    public JsonDeserializer<Object> createContextual(DeserializationConfig config, BeanProperty property) throws JsonMappingException {
        Class<?> rawClass = property.getType().getRawClass();
        Class<?> componentType = rawClass.getComponentType();
        if (componentType == null || !componentType.isEnum()) {
            throw new JsonMappingException("Pick list Enum array expected for " + rawClass);
        }
        return new MultiSelectPicklistDeserializer(componentType);
    }
}

